/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.resource;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.WeakHashMap;
import net.astah.emf.common.ecore.resource.DataURIHandlerImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IDisposable;

public class ResourceStorage
extends AdapterImpl
implements IDisposable {
    private final WeakHashMap<URI, Object> a = new WeakHashMap();

    public ResourceStorage(ResourceSet resourceSet) {
        Objects.requireNonNull(resourceSet, "resourceSet");
        resourceSet.eAdapters().add((Object)this);
    }

    public static ResourceStorage getResourceStorage(Notifier notifier) {
        if (notifier instanceof EObject) {
            notifier = ((EObject)notifier).eResource();
        }
        if (notifier instanceof Resource) {
            notifier = ((Resource)notifier).getResourceSet();
        }
        if (notifier instanceof ResourceSet) {
            for (Adapter adapter : notifier.eAdapters()) {
                if (!(adapter instanceof ResourceStorage)) continue;
                return (ResourceStorage)adapter;
            }
            return new ResourceStorage((ResourceSet)notifier);
        }
        return null;
    }

    public URI store(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            URI uRI = DataURIHandlerImpl.builder(fileInputStream).build();
            return uRI;
        }
    }

    public URI store(byte[] byArray) throws IOException {
        return DataURIHandlerImpl.builder(byArray).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI uRI) throws IOException {
        WeakHashMap<URI, Object> weakHashMap = this.a;
        synchronized (weakHashMap) {
            this.a.remove(uRI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T cachingGet(URI uRI, Class<T> clazz, Loader<T> loader) throws IOException {
        WeakHashMap<URI, Object> weakHashMap;
        WeakHashMap<Object, Object> weakHashMap2 = this.a;
        synchronized (weakHashMap2) {
            weakHashMap = this.a.get(uRI);
            if (clazz.isInstance(weakHashMap)) {
                return clazz.cast(weakHashMap);
            }
        }
        weakHashMap2 = loader.load((ResourceSet)this.target, uRI);
        if (clazz.isInstance(weakHashMap2)) {
            weakHashMap = this.a;
            synchronized (weakHashMap) {
                WeakHashMap<URI, Object> weakHashMap3 = this.a.put(uRI, weakHashMap2);
                if (clazz.isInstance(weakHashMap3)) {
                    this.a.put(uRI, weakHashMap3);
                    return clazz.cast(weakHashMap3);
                }
            }
            return clazz.cast(weakHashMap2);
        }
        return null;
    }

    public void setTarget(Notifier notifier) {
        if (this.target == null && notifier instanceof ResourceSet) {
            DataURIHandlerImpl.install((ResourceSet)notifier);
            this.target = notifier;
        }
    }

    public void unsetTarget(Notifier notifier) {
        if (this.target == notifier) {
            this.target = null;
        }
    }

    public void dispose() {
        if (this.target != null) {
            this.target.eAdapters().remove((Object)this);
        }
    }

    public static InputStream createInputStream(ResourceSet resourceSet, URI uRI) throws IOException {
        return resourceSet.getURIConverter().createInputStream(uRI);
    }

    public static byte[] toByteArray(ResourceSet resourceSet, URI uRI) throws IOException {
        try (InputStream inputStream = ResourceStorage.createInputStream(resourceSet, uRI);){
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public static interface Loader<T> {
        public T load(ResourceSet var1, URI var2) throws IOException;
    }
}

