/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.resource;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import net.astah.emf.common.resource.UnhandledResourceException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.osgi.util.NLS;

public class ResourceSets {
    public static Resource getOrCreateResource(ResourceSet resourceSet, URI uRI) {
        return ResourceSets.getOrCreateResource(resourceSet, uRI, null);
    }

    public static Resource getOrCreateResource(ResourceSet resourceSet, URI uRI, String string) {
        Resource resource = resourceSet.getResource(uRI, false);
        if (resource != null) {
            return resource;
        }
        return resourceSet.createResource(uRI, string);
    }

    public static Resource createResourceOrThrow(ResourceSet resourceSet, URI uRI) throws IOException {
        return ResourceSets.createResourceOrThrow(resourceSet, uRI, null);
    }

    public static Resource createResourceOrThrow(ResourceSet resourceSet, URI uRI, String string) throws IOException {
        Resource resource = resourceSet.createResource(uRI, string);
        if (resource == null) {
            throw new UnhandledResourceException(NLS.bind((String)"An URI ''{0}'' (contentType={1}) is not handled", (Object)uRI, (Object)string), uRI, string);
        }
        return resource;
    }

    public static boolean isLoaded(ResourceSet resourceSet, Resource resource) {
        return resourceSet.getResources().contains((Object)resource) && resource.isLoaded();
    }

    public static boolean isLoaded(ResourceSet resourceSet, EObject eObject) {
        URI uRI = EcoreUtil.getURI((EObject)eObject);
        return uRI != null && resourceSet.getEObject(uRI, false) != null;
    }

    public static void resolveAllProperContents(Resource resource, Predicate<? super EObject> predicate) {
        for (EObject eObject : resource.getContents()) {
            ResourceSets.resolveAllProperContents(resource, eObject, predicate);
        }
    }

    public static void resolveAllProperContents(Resource resource, EObject eObject, Predicate<? super EObject> predicate) {
        assert (eObject.eResource() == resource);
        ResourceSets.a(eObject, predicate);
        for (EObject eObject2 : ((InternalEList)eObject.eContents()).basicList()) {
            if (((InternalEObject)eObject2).eDirectResource() != null) continue;
            ResourceSets.resolveAllProperContents(resource, eObject2, predicate);
        }
    }

    private static void a(EObject eObject, Predicate<? super EObject> predicate) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)((InternalEList)eObject.eCrossReferences()).basicList().iterator();
        if (featureIterator instanceof EContentsEList.Filterable) {
            ((EContentsEList.Filterable)featureIterator).filter(ResourceSets::a);
        }
        EStructuralFeature eStructuralFeature = null;
        int n = 0;
        while (featureIterator.hasNext()) {
            EObject eObject2 = (EObject)featureIterator.next();
            EStructuralFeature eStructuralFeature2 = featureIterator.feature();
            if (eStructuralFeature2 != eStructuralFeature) {
                eStructuralFeature = eStructuralFeature2;
                n = 0;
            }
            if (eObject2.eIsProxy() && predicate.test((EObject)eObject2)) {
                Object object = eObject.eGet(eStructuralFeature2, true);
                if (eStructuralFeature2.isMany()) {
                    ((List)object).get(n);
                }
            }
            ++n;
        }
    }

    static boolean a(EStructuralFeature eStructuralFeature) {
        return !eStructuralFeature.isDerived();
    }

    public static void dispose(ResourceSet resourceSet) {
        EList eList = resourceSet.getResources();
        eList.forEach(Resource::unload);
        resourceSet.eAdapters().clear();
        eList.clear();
    }

    public static IDisposable wrapDisposable(ResourceSet resourceSet) {
        return () -> ResourceSets.dispose(resourceSet);
    }
}

