/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.notify;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class NotificationProcessor<C> {
    public void process(C c2, Iterable<Notification> iterable) {
        for (Notification notification : iterable) {
            this.process(c2, notification);
        }
    }

    public void process(C c2, Notification notification) {
        if (this.shouldProcess(c2, notification)) {
            Object object = notification.getNotifier();
            if (object instanceof EObject) {
                this.processEObjectChange(c2, notification, (EObject)object);
            } else if (object instanceof Resource) {
                this.processResourceChange(c2, notification, (Resource)object);
            } else if (object instanceof ResourceSet) {
                this.processResourceSetChange(c2, notification, (ResourceSet)object);
            }
        }
    }

    protected void processEObjectChange(C c2, Notification notification, EObject eObject) {
        Object object = notification.getFeature();
        if (this.isContainmentReference(c2, object)) {
            switch (notification.getEventType()) {
                case 3: {
                    this.processAttach(c2, notification, eObject, notification.getNewValue());
                    break;
                }
                case 5: {
                    this.processAttachMany(c2, notification, eObject, (List)notification.getNewValue());
                    break;
                }
                case 4: {
                    this.processDetach(c2, notification, eObject, notification.getOldValue());
                    break;
                }
                case 6: {
                    this.processDetachMany(c2, notification, eObject, (List)notification.getOldValue());
                    break;
                }
                case 1: {
                    this.processDetach(c2, notification, eObject, notification.getOldValue());
                    this.processAttach(c2, notification, eObject, notification.getNewValue());
                }
            }
        } else {
            this.processChange(c2, notification, eObject);
        }
    }

    protected void processResourceChange(C c2, Notification notification, Resource resource) {
        if (notification.getFeatureID(Resource.class) == 2) {
            switch (notification.getEventType()) {
                case 3: {
                    this.processAttach(c2, notification, resource, notification.getNewValue());
                    break;
                }
                case 5: {
                    this.processAttachMany(c2, notification, resource, (List)notification.getNewValue());
                    break;
                }
                case 4: {
                    this.processDetach(c2, notification, resource, notification.getOldValue());
                    break;
                }
                case 6: {
                    this.processDetachMany(c2, notification, resource, (List)notification.getOldValue());
                }
            }
        }
    }

    protected void processResourceSetChange(C c2, Notification notification, ResourceSet resourceSet) {
        if (notification.getFeatureID(ResourceSet.class) == 0) {
            switch (notification.getEventType()) {
                case 3: {
                    this.processAttach(c2, notification, resourceSet, notification.getNewValue());
                    break;
                }
                case 5: {
                    this.processAttachMany(c2, notification, resourceSet, (List)notification.getNewValue());
                    break;
                }
                case 4: {
                    this.processDetach(c2, notification, resourceSet, notification.getOldValue());
                    break;
                }
                case 6: {
                    this.processDetachMany(c2, notification, resourceSet, (List)notification.getOldValue());
                }
            }
        }
    }

    protected void processAttachMany(C c2, Notification notification, Object object, List<?> list) {
        for (Object obj : list) {
            this.processAttach(c2, notification, object, obj);
        }
    }

    protected abstract void processAttach(C var1, Notification var2, Object var3, Object var4);

    protected void processDetachMany(C c2, Notification notification, Object object, List<?> list) {
        for (Object obj : list) {
            this.processDetach(c2, notification, object, obj);
        }
    }

    protected abstract void processDetach(C var1, Notification var2, Object var3, Object var4);

    protected abstract void processChange(C var1, Notification var2, Object var3);

    protected boolean shouldProcess(C c2, Notification notification) {
        return !notification.isTouch();
    }

    protected boolean isContainmentReference(C c2, Object object) {
        EReference eReference;
        if (object instanceof EReference && (eReference = (EReference)object).isContainment()) {
            EClassifier eClassifier = eReference.getEType();
            return eClassifier != null && eClassifier.getInstanceClass() != Map.Entry.class;
        }
        return false;
    }
}

