/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.notify;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.astah.emf.common.notify.EFeaturePath;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFeaturePathObserver
implements INotifyChangedListener {
    private static final Logger a = LoggerFactory.getLogger(EFeaturePathObserver.class);
    public static EFeaturePathObserver INSTANCE = new EFeaturePathObserver();
    private final AtomicInteger b = new AtomicInteger(1);

    protected EFeaturePathObserver() {
    }

    public static EFeaturePathObserver create() {
        return EFeaturePathObserver.create(new IdentityHashMap());
    }

    public static EFeaturePathObserver create(Map<?, ?> map) {
        Map<EStructuralFeature, e> map2 = map;
        Map<EStructuralFeature, e> map3 = map;
        return new d(map2, map3);
    }

    public IDisposable observe(EFeaturePath eFeaturePath, Listener listener) {
        this.observeSegments(eFeaturePath, Objects.requireNonNull(listener, "listener"));
        return new c(eFeaturePath, listener);
    }

    public void notifyChanged(Notification notification) {
        Object object = this.getNotifier(notification);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            Object object2 = this.getFeature(notification);
            if (object2 instanceof EStructuralFeature) {
                this.handleFeature(notification, (EStructuralFeature)object2, eObject);
            }
            EClass eClass = eObject.eClass();
            this.handleClass(notification, eClass, eObject);
        }
    }

    public void handleContainment(Notification notification, Collection<EObject> collection) {
        Collection<EObject> collection2 = null;
        for (EObject eObject : collection) {
            EStructuralFeature[] eStructuralFeatureArray = ((EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures()).crossReferences();
            if (eStructuralFeatureArray == null) continue;
            for (EStructuralFeature eStructuralFeature : eStructuralFeatureArray) {
                Set<EObject> set;
                e e2;
                if (!eStructuralFeature.isChangeable() || (e2 = this.getSegmentAdapter(eStructuralFeature, false)) == null) continue;
                if (collection2 == null) {
                    collection2 = collection.size() < 16 || collection instanceof Set ? collection : new HashSet<EObject>(collection);
                }
                if ((set = EFeaturePathObserver.a(eObject, eStructuralFeature, collection2, EObject.class)).isEmpty()) continue;
                e2.a(notification, eObject, set);
            }
        }
    }

    public void handleFeature(Notification notification) {
        Object object;
        Object object2 = this.getNotifier(notification);
        if (object2 instanceof EObject && (object = this.getFeature(notification)) instanceof EStructuralFeature) {
            EObject eObject = (EObject)object2;
            this.handleFeature(notification, (EStructuralFeature)object, eObject);
        }
    }

    public void handleClass(Notification notification) {
        Object object = this.getNotifier(notification);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            this.handleClass(notification, eClass, eObject);
        }
    }

    protected void handleFeature(Notification notification, EStructuralFeature eStructuralFeature, EObject eObject) {
        e e2 = this.getSegmentAdapter(eStructuralFeature, false);
        if (e2 != null) {
            e2.a(notification, eObject, null);
        }
    }

    protected void handleClass(Notification notification, EClass eClass, EObject eObject) {
        a a2 = this.getClassAdapter(eClass, true);
        a2.a(notification, eObject);
    }

    protected Object getNotifier(Notification notification) {
        return notification.getNotifier();
    }

    protected Object getFeature(Notification notification) {
        return notification.getFeature();
    }

    protected void observeSegments(EFeaturePath eFeaturePath, Listener listener) {
        e e2;
        EFeaturePath.Segment segment;
        Object object = eFeaturePath.iterator();
        while (object.hasNext()) {
            segment = object.next();
            e2 = this.getSegmentAdapter(segment, true);
            e2.a(segment, listener);
        }
        if (eFeaturePath.isInclusive() && (segment = ((EFeaturePath.Segment)(object = eFeaturePath.getLast())).getFeature()) instanceof EReference) {
            e2 = (EClass)((EFeaturePath.Segment)object).getEType();
            a a2 = this.getClassAdapter((EClass)e2, true);
            a2.a((EFeaturePath.Segment)object, listener);
        }
        a.debug("observe: {}", (Object)eFeaturePath);
    }

    protected void unobserveSegments(EFeaturePath eFeaturePath, Listener listener) {
        e e2;
        EFeaturePath.Segment segment;
        Object object = eFeaturePath.iterator();
        while (object.hasNext()) {
            segment = object.next();
            e2 = this.getSegmentAdapter(segment, false);
            Assert.isTrue((boolean)e2.b(segment, listener));
        }
        if (eFeaturePath.isInclusive() && (segment = ((EFeaturePath.Segment)(object = eFeaturePath.getLast())).getFeature()) instanceof EReference) {
            e2 = (EClass)((EFeaturePath.Segment)object).getEType();
            a a2 = this.getClassAdapter((EClass)e2, false);
            Assert.isTrue((boolean)a2.b((EFeaturePath.Segment)object, listener));
        }
        a.debug("unobserve: {}", (Object)eFeaturePath);
    }

    protected e getSegmentAdapter(EFeaturePath.Segment segment, boolean bl) {
        EReference eReference = segment.isInverse() ? segment.getEOpposite() : segment.getFeature();
        return this.getSegmentAdapter((EStructuralFeature)eReference, bl);
    }

    protected e getSegmentAdapter(EStructuralFeature eStructuralFeature, boolean bl) {
        EList eList = eStructuralFeature.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, e.class);
        if (adapter instanceof e) {
            return (e)adapter;
        }
        if (bl) {
            e e2 = new e();
            eList.add((Object)e2);
            return e2;
        }
        return null;
    }

    protected a getClassAdapter(EClass eClass, boolean bl) {
        EList eList = eClass.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, a.class);
        if (adapter instanceof a) {
            return (a)adapter;
        }
        if (bl) {
            a a2 = new a();
            eList.add((Object)a2);
            return a2;
        }
        return null;
    }

    protected void firePathChanged(List<Listener> list, EFeaturePath eFeaturePath, Notification notification, Set<EObject> set) {
        Event event = new Event(this, eFeaturePath, notification, set);
        for (Listener listener : list) {
            listener.pathChanged(event);
        }
    }

    static <E> Set<E> a(Notification notification, Class<E> clazz) {
        Set set = Collections.emptySet();
        switch (notification.getEventType()) {
            case 1: 
            case 3: 
            case 4: {
                Object object;
                Object object2 = notification.getOldValue();
                if (clazz.isInstance(object2)) {
                    set = EFeaturePathObserver.a(set, clazz.cast(object2));
                }
                if (!clazz.isInstance(object = notification.getNewValue())) break;
                set = EFeaturePathObserver.a(set, clazz.cast(object));
                break;
            }
            case 5: {
                Object object = notification.getNewValue();
                for (Object e2 : (List)object) {
                    if (!clazz.isInstance(e2)) continue;
                    set = EFeaturePathObserver.a(set, clazz.cast(e2));
                }
                break;
            }
            case 6: {
                Object object = notification.getOldValue();
                for (Object e3 : (List)object) {
                    if (!clazz.isInstance(e3)) continue;
                    set = EFeaturePathObserver.a(set, clazz.cast(e3));
                }
                break;
            }
        }
        return set.isEmpty() ? set : Collections.unmodifiableSet(set);
    }

    static <E> Set<E> a(EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection, Class<E> clazz) {
        Object object = eObject.eGet(eStructuralFeature);
        if (object != null) {
            if (eStructuralFeature.isMany()) {
                Set set = Collections.emptySet();
                for (Object e2 : (List)object) {
                    if (collection.contains(e2)) continue;
                    set = EFeaturePathObserver.a(set, clazz.cast(e2));
                }
                if (!set.isEmpty()) {
                    return Collections.unmodifiableSet(set);
                }
            } else if (!collection.contains(object)) {
                return Collections.singleton(clazz.cast(object));
            }
        }
        return Collections.emptySet();
    }

    static <E> Set<E> a(Set<E> set, E e2) {
        if (set.isEmpty()) {
            set = new HashSet();
        }
        set.add(e2);
        return set;
    }

    static class b<E>
    extends AbstractList<E> {
        int a;

        b() {
        }

        @Override
        public E get(int n) {
            return null;
        }

        @Override
        public boolean add(E e2) {
            ++this.a;
            return true;
        }

        @Override
        public boolean remove(Object object) {
            assert (this.a >= 0);
            --this.a;
            return true;
        }

        @Override
        public int size() {
            return this.a;
        }
    }

    class SegmentGroup
    extends ConcurrentHashMap<EFeaturePath.Segment, List<Listener>> {
        private static final long serialVersionUID = 1L;
        final e handler;

        SegmentGroup(e e2) {
            this.handler = e2;
        }

        e getHandler() {
            return this.handler;
        }

        void mergeCache(EFeaturePath.Segment segment2, List<Listener> list) {
            if (segment2.getPrevious() == null) {
                this.computeIfAbsent(segment2, segment -> new ArrayList()).addAll(list);
            } else {
                this.putIfAbsent(segment2, Collections.emptyList());
            }
        }

        synchronized void register(EFeaturePath.Segment segment2, Listener listener) {
            this.computeIfAbsent(segment2, segment -> segment.getPrevious() == null ? new CopyOnWriteArrayList() : new b()).add(listener);
        }

        synchronized boolean unregister(EFeaturePath.Segment segment, Listener listener) {
            List list = (List)this.get(segment);
            if (list != null && list.remove(listener)) {
                if (list.isEmpty()) {
                    this.remove(segment, list);
                }
                return true;
            }
            return false;
        }

        Set<EFeaturePath.Segment> filter(Set<EFeaturePath.Segment> set, Set<EObject> set2) {
            Set<EFeaturePath.Segment> set3 = Collections.emptySet();
            if (set == null) {
                block0: for (EFeaturePath.Segment segment : this.keySet()) {
                    EClass eClass = segment.getEClass();
                    for (EObject eObject : set2) {
                        if (!eClass.isInstance((Object)eObject)) continue;
                        set3 = EFeaturePathObserver.a(set3, segment);
                        continue block0;
                    }
                }
            } else {
                for (EFeaturePath.Segment segment : this.keySet()) {
                    EFeaturePath.Segment segment2 = segment.getNext();
                    if (segment2 == null || !set.contains(segment2)) continue;
                    set3 = EFeaturePathObserver.a(set3, segment);
                }
            }
            return set3;
        }

        void notifySegment(EFeaturePath.Segment segment, Notification notification, Set<EObject> set) {
            List list = (List)this.get(segment);
            if (list != null) {
                EFeaturePathObserver.this.firePathChanged(list, segment.getPath(), notification, set);
            }
        }
    }

    class a
    extends AdapterImpl {
        final SegmentGroup a;
        Map<Object, SegmentGroup> b;
        int c;

        a() {
            this.a = new SegmentGroup(null);
        }

        public boolean isAdapterForType(Object object) {
            return object == a.class;
        }

        void a(EFeaturePath.Segment segment, Listener listener) {
            this.a.register(segment, listener);
            EFeaturePathObserver.this.b.incrementAndGet();
        }

        boolean b(EFeaturePath.Segment segment, Listener listener) {
            if (this.a.unregister(segment, listener)) {
                EFeaturePathObserver.this.b.incrementAndGet();
                return true;
            }
            return false;
        }

        synchronized Map<Object, SegmentGroup> a() {
            int n;
            while (this.c != (n = EFeaturePathObserver.this.b.get())) {
                this.b = this.b();
                this.c = n;
            }
            return this.b;
        }

        Map<Object, SegmentGroup> b() {
            HashMap<Object, SegmentGroup> hashMap = new HashMap<Object, SegmentGroup>();
            EClass eClass = (EClass)this.getTarget();
            for (EClass eClass2 : eClass.getEAllSuperTypes()) {
                a a2 = EFeaturePathObserver.this.getClassAdapter(eClass2, false);
                if (a2 == null) continue;
                this.a(hashMap, a2.a);
            }
            this.a(hashMap, this.a);
            return hashMap.isEmpty() ? Collections.emptyMap() : hashMap;
        }

        void a(Map<Object, SegmentGroup> map, SegmentGroup segmentGroup) {
            segmentGroup.forEach((segment, list) -> {
                Object object = segment.a();
                SegmentGroup segmentGroup = (SegmentGroup)map.get(object);
                if (segmentGroup == null) {
                    segmentGroup = new SegmentGroup(EFeaturePathObserver.this.getSegmentAdapter((EFeaturePath.Segment)segment, false));
                    map.put(object, segmentGroup);
                }
                segmentGroup.mergeCache((EFeaturePath.Segment)segment, (List<Listener>)list);
            });
        }

        void a(Notification notification, EObject eObject) {
            for (SegmentGroup segmentGroup : this.a().values()) {
                Iterator iterator = ((ConcurrentHashMap.KeySetView)segmentGroup.keySet()).iterator();
                if (!iterator.hasNext()) continue;
                EFeaturePath.Segment segment = (EFeaturePath.Segment)iterator.next();
                HashSet hashSet = new HashSet();
                segment.a(eObject, hashSet);
                if (hashSet.isEmpty()) continue;
                Set<EObject> set = Collections.unmodifiableSet(hashSet);
                if (segment.getPrevious() == null) {
                    segmentGroup.notifySegment(segment, notification, set);
                    continue;
                }
                e e2 = segmentGroup.getHandler();
                e2.a(null, set, notification);
            }
        }
    }

    class e
    extends AdapterImpl {
        Map<Object, SegmentGroup> a;
        Map<Object, SegmentGroup> b;

        e() {
        }

        public boolean isAdapterForType(Object object) {
            return object == e.class;
        }

        synchronized void a(EFeaturePath.Segment segment, Listener listener) {
            Object object;
            Map<Object, SegmentGroup> map = this.a(segment, true);
            SegmentGroup segmentGroup = map.get(object = this.a(segment));
            if (segmentGroup == null) {
                segmentGroup = new SegmentGroup(this.b(segment));
                map.put(object, segmentGroup);
            }
            segmentGroup.register(segment, listener);
        }

        synchronized boolean b(EFeaturePath.Segment segment, Listener listener) {
            Object object;
            Map<Object, SegmentGroup> map = this.a(segment, false);
            SegmentGroup segmentGroup = map.get(object = this.a(segment));
            if (segmentGroup != null && segmentGroup.unregister(segment, listener)) {
                if (segmentGroup.isEmpty()) {
                    map.remove(object);
                    if (map.isEmpty()) {
                        if (segment.isInverse()) {
                            this.b = null;
                        } else {
                            this.a = null;
                        }
                    }
                }
                return true;
            }
            return false;
        }

        void a(Notification notification, EObject eObject, Set<EObject> set) {
            Collection<SegmentGroup> collection;
            Object object;
            Map<Object, SegmentGroup> map = this.a;
            if (map != null) {
                object = Collections.singleton(eObject);
                collection = map.values();
                this.a(null, (Set<EObject>)object, notification, collection);
            }
            if ((object = this.b) != null) {
                collection = set == null ? EFeaturePathObserver.a(notification, EObject.class) : set;
                Collection<SegmentGroup> collection2 = object.values();
                this.a(null, (Set<EObject>)collection, notification, collection2);
            }
        }

        void a(Set<EFeaturePath.Segment> set, Set<EObject> set2, Notification notification) {
            Object object;
            Map<Object, SegmentGroup> map = this.a;
            if (map != null) {
                object = map.values();
                this.a(set, set2, notification, (Collection<SegmentGroup>)object);
            }
            if ((object = this.b) != null) {
                Collection<SegmentGroup> collection = object.values();
                this.a(set, set2, notification, collection);
            }
        }

        void a(Set<EFeaturePath.Segment> set, Set<EObject> set2, Notification notification, Collection<SegmentGroup> collection) {
            for (SegmentGroup segmentGroup : collection) {
                Set<EFeaturePath.Segment> set3 = segmentGroup.filter(set, set2);
                Iterator<EFeaturePath.Segment> iterator = set3.iterator();
                if (!iterator.hasNext()) continue;
                EFeaturePath.Segment segment = iterator.next();
                EFeaturePath.Segment segment2 = segment.getPrevious();
                if (segment2 == null) {
                    for (EFeaturePath.Segment segment3 : set3) {
                        segmentGroup.notifySegment(segment3, notification, set2);
                    }
                    continue;
                }
                HashSet hashSet = new HashSet();
                for (EObject eObject : set2) {
                    segment2.a(eObject, hashSet);
                }
                if (hashSet.isEmpty()) continue;
                e e2 = segmentGroup.getHandler();
                e2.a(set3, Collections.unmodifiableSet(hashSet), notification);
            }
        }

        synchronized Map<Object, SegmentGroup> a(EFeaturePath.Segment segment, boolean bl) {
            if (segment.isInverse()) {
                if (this.b == null && bl) {
                    this.b = new ConcurrentHashMap<Object, SegmentGroup>();
                }
                return this.b;
            }
            if (this.a == null && bl) {
                this.a = new ConcurrentHashMap<Object, SegmentGroup>();
            }
            return this.a;
        }

        Object a(EFeaturePath.Segment segment) {
            EFeaturePath.Segment segment2 = segment.getPrevious();
            return segment2 != null ? segment2.a() : this;
        }

        e b(EFeaturePath.Segment segment) {
            EFeaturePath.Segment segment2 = segment.getPrevious();
            return segment2 != null ? EFeaturePathObserver.this.getSegmentAdapter(segment2, false) : this;
        }
    }

    class c
    implements IDisposable {
        final EFeaturePath a;
        final Listener b;
        boolean c;

        c(EFeaturePath eFeaturePath, Listener listener) {
            this.a = eFeaturePath;
            this.b = listener;
        }

        public void dispose() {
            if (!this.c) {
                this.c = true;
                EFeaturePathObserver.this.unobserveSegments(this.a, this.b);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.c) {
                a.warn("A path observation {} should be disposed explicitly", (Object)this.a);
                this.dispose();
            }
            super.finalize();
        }
    }

    static class d
    extends EFeaturePathObserver {
        final Map<EStructuralFeature, e> a;
        final Map<EClass, a> b;

        d(Map<EStructuralFeature, e> map, Map<EClass, a> map2) {
            this.a = Objects.requireNonNull(map, "segmentMap");
            this.b = Objects.requireNonNull(map2, "classMap");
        }

        @Override
        protected e getSegmentAdapter(EStructuralFeature eStructuralFeature2, boolean bl) {
            if (bl) {
                return this.a.computeIfAbsent(eStructuralFeature2, eStructuralFeature -> {
                    e e2 = new e();
                    e2.setTarget((Notifier)eStructuralFeature);
                    return e2;
                });
            }
            return this.a.get(eStructuralFeature2);
        }

        @Override
        protected a getClassAdapter(EClass eClass2, boolean bl) {
            if (bl) {
                return this.b.computeIfAbsent(eClass2, eClass -> {
                    a a2 = new a();
                    a2.setTarget((Notifier)eClass);
                    return a2;
                });
            }
            return this.b.get(eClass2);
        }
    }

    public static class Event
    extends EventObject {
        private final EFeaturePath path;
        private final Notification notification;
        private final Set<EObject> affectedObjects;

        public Event(EFeaturePathObserver eFeaturePathObserver, EFeaturePath eFeaturePath, Notification notification, Set<EObject> set) {
            super(eFeaturePathObserver);
            this.path = Objects.requireNonNull(eFeaturePath, "path");
            this.notification = Objects.requireNonNull(notification, "notification");
            this.affectedObjects = Objects.requireNonNull(set, "affectedObjects");
        }

        @Override
        public EFeaturePathObserver getSource() {
            return (EFeaturePathObserver)super.getSource();
        }

        public EFeaturePath getPath() {
            return this.path;
        }

        public Notification getNotification() {
            return this.notification;
        }

        public Set<EObject> getAffectedObjects() {
            return this.affectedObjects;
        }
    }

    public static interface Listener
    extends EventListener {
        public void pathChanged(Event var1);
    }
}

