/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.notify;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAdapterFactory
extends AdapterFactoryImpl {
    private static final Logger a = LoggerFactory.getLogger(DynamicAdapterFactory.class);
    protected Map<Object, Map<Object, Object>> adapterMap = new IdentityHashMap<Object, Map<Object, Object>>();
    protected Set<Object> typeCache;

    public void addAdapter(Object object, Object object2, Object object3) {
        Objects.requireNonNull(object3, "adapter");
        Map<Object, Object> map = this.adapterMap.get(object2);
        if (map == null) {
            map = new IdentityHashMap<Object, Object>();
            this.adapterMap.put(object2, map);
        }
        map.put(object, object3);
        if (this.typeCache != null) {
            this.typeCache.add(object2);
            EPackage ePackage = this.a(object);
            if (ePackage != null) {
                this.typeCache.add(ePackage);
            }
        }
    }

    public void removeAdapter(Object object, Object object2) {
        Map<Object, Object> map = this.adapterMap.get(object2);
        if (map != null && map.remove(object) != null) {
            if (map.isEmpty()) {
                this.adapterMap.remove(object2, map);
            }
            this.invalidateTypeCache();
        }
    }

    public boolean isFactoryForType(Object object) {
        if (this.typeCache == null) {
            this.typeCache = this.createTypeCache();
        }
        return this.typeCache.contains(object);
    }

    public Adapter adaptNew(Notifier notifier, Object object) {
        Object object2 = this.resolve(notifier, object);
        if (object2 instanceof Adapter) {
            return (Adapter)object2;
        }
        a.debug("Cannot adapt {} to {}", (Object)notifier, object);
        return null;
    }

    protected Object resolve(Object object, Object object2) {
        Map<Object, Object> map = this.adapterMap.get(object2);
        if (map != null) {
            EClass eClass;
            Object object3 = map.get(object);
            if (object3 != null) {
                return object3;
            }
            if (object instanceof EObject && (eClass = ((EObject)object).eClass()) != null) {
                Object object4;
                Object object5 = map.get(eClass);
                if (object5 != null) {
                    return object5;
                }
                EPackage ePackage = eClass.getEPackage();
                if (ePackage != null && (object4 = map.get(ePackage)) != null) {
                    return object4;
                }
            }
        }
        return object;
    }

    protected void invalidateTypeCache() {
        this.typeCache = null;
    }

    protected Set<Object> createTypeCache() {
        Set<Object> set = Collections.newSetFromMap(new IdentityHashMap());
        for (Map.Entry<Object, Map<Object, Object>> entry : this.adapterMap.entrySet()) {
            set.add(entry.getKey());
            for (Object object : entry.getValue().keySet()) {
                EPackage ePackage = this.a(object);
                if (ePackage == null) continue;
                set.add(ePackage);
            }
        }
        return set;
    }

    private EPackage a(Object object) {
        EPackage ePackage;
        EClass eClass;
        if (object instanceof EPackage) {
            return (EPackage)object;
        }
        if (object instanceof EClass) {
            return ((EClass)object).getEPackage();
        }
        if (object instanceof EObject && (eClass = ((EObject)object).eClass()) != null && (ePackage = eClass.getEPackage()) != EcorePackage.eINSTANCE) {
            return ePackage;
        }
        return null;
    }
}

