/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore.resource;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.astah.emf.common.ecore.resource.a;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

public class MemoryURIHandlerImpl
extends URIHandlerImpl {
    public static final String SCHEME_MEMORY = "memory";
    protected final Map<URI, Entry> entryMap = new ConcurrentHashMap<URI, Entry>();

    public static void install(ResourceSet resourceSet) {
        MemoryURIHandlerImpl.install(resourceSet.getURIConverter());
    }

    public static void install(URIConverter uRIConverter) {
        uRIConverter.getURIHandlers().add(0, (Object)new MemoryURIHandlerImpl());
    }

    public static byte[] getContent(ResourceSet resourceSet, URI uRI) {
        URIHandler uRIHandler = resourceSet.getURIConverter().getURIHandler(uRI);
        if (uRIHandler instanceof MemoryURIHandlerImpl) {
            return ((MemoryURIHandlerImpl)uRIHandler).getContent(uRI);
        }
        return null;
    }

    public byte[] getContent(URI uRI) {
        Entry entry = this.entryMap.get(uRI);
        return entry != null ? (byte[])entry.content.clone() : null;
    }

    public boolean canHandle(URI uRI) {
        return SCHEME_MEMORY.equalsIgnoreCase(uRI.scheme());
    }

    public OutputStream createOutputStream(URI uRI2, Map<?, ?> map) throws IOException {
        Entry entry = this.entryMap.computeIfAbsent(uRI2, uRI -> new Entry());
        return entry.createOutputStream(uRI2, map);
    }

    public InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
        return this.require(uRI).createInputStream(uRI, map);
    }

    public void delete(URI uRI, Map<?, ?> map) throws IOException {
        this.entryMap.remove(uRI);
    }

    public boolean exists(URI uRI, Map<?, ?> map) {
        return this.entryMap.containsKey(uRI);
    }

    public Map<String, ?> getAttributes(URI uRI, Map<?, ?> map) {
        Entry entry = this.entryMap.get(uRI);
        if (entry != null) {
            Set set = this.getRequestedAttributes(map);
            return entry.getAttributes(uRI, map, set);
        }
        return new HashMap();
    }

    public void setAttributes(URI uRI, Map<String, ?> map, Map<?, ?> map2) throws IOException {
        this.require(uRI).setAttributes(uRI, map, map2);
    }

    protected Entry require(URI uRI) throws IOException {
        Entry entry = this.entryMap.get(uRI);
        if (entry == null) {
            throw new FileNotFoundException(uRI.toString());
        }
        return entry;
    }

    protected static class Entry {
        private static final byte[] a = new byte[0];
        protected byte[] content = a;
        protected boolean readOnly;
        protected long timeStamp = -1L;

        protected Entry() {
        }

        public synchronized InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public OutputStream createOutputStream(URI uRI, Map<?, ?> map) throws IOException {
            if (this.readOnly) {
                throw new IOException("Readonly: " + uRI);
            }
            return new a(this);
        }

        public synchronized Map<String, ?> getAttributes(URI uRI, Map<?, ?> map, Set<String> set) {
            HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
            if (this.isRequested(set, "readOnly")) {
                hashMap.put("readOnly", Boolean.valueOf(this.readOnly));
            }
            if (this.isRequested(set, "timeStamp")) {
                hashMap.put("timeStamp", Long.valueOf(this.timeStamp));
            }
            if (this.isRequested(set, "length")) {
                hashMap.put("length", Integer.valueOf(this.content.length));
            }
            return hashMap;
        }

        public synchronized void setAttributes(URI uRI, Map<String, ?> map, Map<?, ?> map2) {
            Object obj;
            Object obj2 = map.get("timeStamp");
            if (obj2 instanceof Number) {
                this.timeStamp = ((Number)obj2).longValue();
            }
            if ((obj = map.get("readOnly")) instanceof Boolean) {
                this.readOnly = (Boolean)obj;
            }
        }

        protected boolean isRequested(Set<String> set, String string) {
            return set == null || set.contains(string);
        }
    }
}

