/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore.resource;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;

public class DataURIHandlerImpl
extends URIHandlerImpl {
    public static final String SCHEME_DATA = "data";
    private static final String a = "base64";
    private static final BaseEncoding b = BaseEncoding.base64();
    private static final Charset c = Charset.forName("UTF-8");
    private static final CharMatcher d = CharMatcher.ASCII.and(CharMatcher.JAVA_ISO_CONTROL.negate()).and(CharMatcher.isNot((char)' ')).and(CharMatcher.noneOf((CharSequence)"()<>@,;:\\\"/[]?="));
    private static final CharMatcher e = CharMatcher.ASCII.and(CharMatcher.noneOf((CharSequence)"\"\\\r"));
    private static final CharMatcher f = CharMatcher.anyOf((CharSequence)" \t\r\n");

    public static void install(ResourceSet resourceSet) {
        DataURIHandlerImpl.install(resourceSet.getURIConverter());
    }

    public static void install(URIConverter uRIConverter) {
        ListIterator listIterator = uRIConverter.getURIHandlers().listIterator();
        URI uRI = URI.createGenericURI((String)SCHEME_DATA, (String)",", null);
        while (listIterator.hasNext()) {
            URIHandler uRIHandler = (URIHandler)listIterator.next();
            if (!uRIHandler.canHandle(uRI)) continue;
            listIterator.previous();
            break;
        }
        listIterator.add(new DataURIHandlerImpl());
    }

    public static Builder builder(byte[] byArray) {
        Objects.requireNonNull(byArray, SCHEME_DATA);
        return DataURIHandlerImpl.builder(new ByteArrayInputStream(byArray));
    }

    public static Builder builder(InputStream inputStream) {
        Objects.requireNonNull(inputStream, SCHEME_DATA);
        return new Builder(inputStream);
    }

    public boolean canHandle(URI uRI) {
        return SCHEME_DATA.equalsIgnoreCase(uRI.scheme());
    }

    public Map<String, ?> contentDescription(URI uRI, Map<?, ?> map) throws IOException {
        a a2;
        MediaType mediaType;
        Map map2 = super.contentDescription(uRI, map);
        if (map2 != ContentHandler.INVALID_CONTENT_DESCRIPTION && (mediaType = this.parseMediaType(a2 = new a(uRI.opaquePart()))) != null) {
            String string = mediaType.type() + "/" + mediaType.subtype();
            map2.put("org.eclipse.emf.ecore:contentType", string);
            Charset charset = (Charset)mediaType.charset().orNull();
            if (charset != null) {
                map2.put("org.eclipse.core.runtime:charset", charset.name());
            }
        }
        return map2;
    }

    public InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
        if (uRI.hasOpaquePart()) {
            a a2 = new a(uRI.opaquePart());
            MediaType mediaType = this.parseMediaType(a2);
            if (a2.e()) {
                a2.a();
                if (a2.a(';') && a.equals(a2.a(d)) && a2.a(',')) {
                    CharSource charSource = CharSource.wrap((CharSequence)a2.c());
                    return b.decodingSource(charSource).openStream();
                }
                a2.b();
                if (a2.a(',')) {
                    String string = DataURIHandlerImpl.getCharset(mediaType).name();
                    String string2 = a2.c().toString();
                    String string3 = URLDecoder.decode(string2, string);
                    return new ByteArrayInputStream(string3.getBytes(string));
                }
            }
        }
        throw new FileNotFoundException(String.valueOf(uRI));
    }

    public boolean exists(URI uRI, Map<?, ?> map) {
        if (uRI.hasOpaquePart()) {
            a a2 = new a(uRI.opaquePart());
            this.parseMediaType(a2);
            if (a2.e()) {
                a2.a();
                if (a2.a(';') && a.equals(a2.a(d)) && a2.a(',')) {
                    return true;
                }
                a2.b();
                return a2.a(',');
            }
        }
        return false;
    }

    public Map<String, ?> getAttributes(URI uRI, Map<?, ?> map) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Set set = this.getRequestedAttributes(map);
        if (this.isRequested(set, "readOnly")) {
            hashMap.put("readOnly", true);
        }
        return hashMap;
    }

    public OutputStream createOutputStream(URI uRI, Map<?, ?> map) throws IOException {
        throw new IOException("Readonly URI: " + uRI);
    }

    public void delete(URI uRI, Map<?, ?> map) throws IOException {
        throw new IOException("Readonly URI: " + uRI);
    }

    public void setAttributes(URI uRI, Map<String, ?> map, Map<?, ?> map2) throws IOException {
        throw new IOException("Readonly URI: " + uRI);
    }

    protected MediaType parseMediaType(a a2) {
        String string;
        a2.a();
        String string2 = a2.a(d);
        if (string2 != null && a2.a('/') && (string = a2.a(d)) != null) {
            MediaType mediaType = MediaType.create((String)string2, (String)string);
            Multimap<String, String> multimap = this.parseParameters(a2);
            return multimap != null ? mediaType.withParameters(multimap) : mediaType;
        }
        a2.b();
        return null;
    }

    protected Multimap<String, String> parseParameters(a a2) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        a2.a();
        while (a2.a(';')) {
            a2.a(f);
            String string = a2.a(d);
            if (string == null || !a2.a('=')) break;
            String string2 = this.a(a2);
            if (string2 == null) continue;
            arrayListMultimap.put((Object)string, (Object)string2);
            a2.a();
        }
        a2.b();
        return arrayListMultimap.isEmpty() ? null : arrayListMultimap;
    }

    private String a(a a2) {
        if ('\"' == a2.d()) {
            a2.a('\"');
            StringBuilder stringBuilder = new StringBuilder();
            while ('\"' != a2.d()) {
                if ('\\' == a2.d()) {
                    a2.a('\\');
                    int n = a2.b(CharMatcher.ASCII);
                    if (n < 0) {
                        return null;
                    }
                    stringBuilder.append((char)n);
                    continue;
                }
                String string = a2.a(e);
                if (string == null) {
                    return null;
                }
                stringBuilder.append(string);
            }
            String string = stringBuilder.toString();
            a2.a('\"');
            return string;
        }
        return a2.a(d);
    }

    protected boolean isRequested(Set<String> set, String string) {
        return set == null || set.contains(string);
    }

    protected static Charset getCharset(MediaType mediaType) {
        return mediaType != null ? (Charset)mediaType.charset().or((Object)c) : c;
    }

    private static String b(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16).append('\"');
        for (char c2 : string.toCharArray()) {
            if (c2 == '\r' || c2 == '\\' || c2 == '\"') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append('\"').toString();
    }

    private static final class a {
        final String a;
        final int b;
        int c = 0;
        int d = -1;

        a(String string) {
            this.a = string;
            this.b = string.length();
        }

        public void a() {
            this.d = this.c;
        }

        public void b() {
            Preconditions.checkState((this.d >= 0 ? 1 : 0) != 0);
            this.c = this.d;
            this.d = -1;
        }

        String a(CharMatcher charMatcher) {
            int n = this.c;
            this.c = charMatcher.negate().indexIn((CharSequence)this.a, n);
            if (this.c <= n) {
                return null;
            }
            return this.a.substring(n, this.c);
        }

        int b(CharMatcher charMatcher) {
            char c2;
            if (this.e() && charMatcher.matches(c2 = this.d())) {
                ++this.c;
                return c2;
            }
            return -1;
        }

        boolean a(char c2) {
            if (this.e() && this.d() == c2) {
                ++this.c;
                return true;
            }
            return false;
        }

        CharSequence c() {
            if (this.e()) {
                CharBuffer charBuffer = CharBuffer.wrap(this.a, this.c, this.b);
                this.c += this.b - this.c;
                return charBuffer;
            }
            return "";
        }

        char d() {
            Preconditions.checkState((boolean)this.e());
            return this.a.charAt(this.c);
        }

        boolean e() {
            return this.c >= 0 && this.c < this.b;
        }
    }

    public static class Builder {
        private final InputStream a;
        private boolean b;
        private MediaType c;

        public Builder(InputStream inputStream) {
            this.a = inputStream;
        }

        public Builder withURIEncoded(boolean bl) {
            this.b = bl;
            return this;
        }

        public Builder withMediaType(MediaType mediaType) {
            this.c = mediaType;
            return this;
        }

        public URI build() throws IOException {
            return URI.createGenericURI((String)DataURIHandlerImpl.SCHEME_DATA, (String)this.buildOpaquePart(), null);
        }

        public String buildString() throws IOException {
            return "data:" + this.buildOpaquePart();
        }

        public String buildOpaquePart() throws IOException {
            try {
                StringWriter stringWriter = new StringWriter();
                if (this.c != null) {
                    this.a(stringWriter, this.c);
                }
                if (this.b) {
                    this.b(stringWriter);
                } else {
                    this.a(stringWriter);
                }
                String string = stringWriter.toString();
                return string;
            }
            finally {
                this.a.close();
            }
        }

        void a(Writer writer, MediaType mediaType) throws IOException {
            writer.write(mediaType.type());
            writer.write(47);
            writer.write(mediaType.subtype());
            ImmutableListMultimap immutableListMultimap = mediaType.parameters();
            if (!immutableListMultimap.isEmpty()) {
                for (Map.Entry entry : immutableListMultimap.entries()) {
                    writer.write(59);
                    writer.write((String)entry.getKey());
                    writer.write(61);
                    String string = (String)entry.getValue();
                    writer.write(d.matchesAllOf((CharSequence)string) ? string : DataURIHandlerImpl.b(string));
                }
            }
        }

        void a(Writer writer) throws IOException {
            writer.write(59);
            writer.write(DataURIHandlerImpl.a);
            writer.write(44);
            try (OutputStream outputStream = b.encodingStream(writer);){
                ByteStreams.copy((InputStream)this.a, (OutputStream)outputStream);
            }
        }

        void b(Writer writer) throws IOException {
            writer.write(44);
            byte[] byArray = ByteStreams.toByteArray((InputStream)this.a);
            String string = DataURIHandlerImpl.getCharset(this.c).name();
            writer.write(URLEncoder.encode(new String(byArray), string));
        }
    }
}

