/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore.plugin;

import lombok.NonNull;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RegistryReader
implements IDisposable {
    private static final Logger a = LoggerFactory.getLogger(RegistryReader.class);
    protected final IExtensionRegistry pluginRegistry;
    protected final String pluginID;
    protected final String extensionPointID;
    protected final String qualifiedExtensionPointID;
    private IRegistryChangeListener b;

    public RegistryReader(@NonNull IExtensionRegistry iExtensionRegistry, @NonNull String string, @NonNull String string2) {
        if (iExtensionRegistry == null) {
            throw new NullPointerException("pluginRegistry");
        }
        if (string == null) {
            throw new NullPointerException("pluginID");
        }
        if (string2 == null) {
            throw new NullPointerException("extensionPointID");
        }
        this.pluginRegistry = iExtensionRegistry;
        this.pluginID = string;
        this.extensionPointID = string2;
        this.qualifiedExtensionPointID = string + "." + string2;
    }

    protected void logError(IConfigurationElement iConfigurationElement, String string) {
        this.logError(iConfigurationElement, string, null);
    }

    protected void logError(IConfigurationElement iConfigurationElement, String string, Throwable throwable) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        Object[] objectArray = new Object[]{iExtension.getContributor().getName(), iExtension.getExtensionPointUniqueIdentifier(), iConfigurationElement.getName(), string};
        a.error(NLS.bind((String)"Plugin ''{0}'', extension ''{1}'', element <{2}>: {3}", (Object[])objectArray), throwable);
    }

    protected void logInfo(IConfigurationElement iConfigurationElement, String string) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        Object[] objectArray = new Object[]{iExtension.getContributor().getName(), iExtension.getExtensionPointUniqueIdentifier(), iConfigurationElement.getName(), string};
        a.info(NLS.bind((String)"Plugin ''{0}'', extension ''{1}'', element <{2}>: {3}", (Object[])objectArray));
    }

    protected void readElements(IConfigurationElement[] iConfigurationElementArray, boolean bl) {
        if (bl) {
            for (IConfigurationElement iConfigurationElement : iConfigurationElementArray) {
                this.parse(iConfigurationElement);
            }
        }
    }

    protected abstract void parse(IConfigurationElement var1);

    protected void logMissingAttribute(IConfigurationElement iConfigurationElement, String string) {
        this.logError(iConfigurationElement, NLS.bind((String)"The required attribute ''{0}'' not defined", (Object)string));
    }

    public void readRegistry() {
        IRegistryChangeListener iRegistryChangeListener;
        IExtensionPoint iExtensionPoint;
        if (this.b == null && (iExtensionPoint = this.a()) != null && (iRegistryChangeListener = this.a(iExtensionPoint)) != null) {
            this.pluginRegistry.addRegistryChangeListener(iRegistryChangeListener);
            this.b = iRegistryChangeListener;
        }
    }

    public void dispose() {
        if (this.b != null) {
            this.pluginRegistry.removeRegistryChangeListener(this.b);
            this.b = null;
            IExtensionPoint iExtensionPoint = this.a();
            if (iExtensionPoint != null) {
                this.readElements(iExtensionPoint.getConfigurationElements(), false);
            }
        }
    }

    private IRegistryChangeListener a(IExtensionPoint iExtensionPoint) {
        this.readElements(iExtensionPoint.getConfigurationElements(), true);
        return iRegistryChangeEvent -> {
            IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
            for (int i = 0; i < iExtensionDeltaArray.length; ++i) {
                IExtensionDelta iExtensionDelta = iExtensionDeltaArray[i];
                if (!iExtensionPoint.equals((Object)iExtensionDelta.getExtensionPoint())) continue;
                boolean bl = iExtensionDelta.getKind() == 1;
                IExtension iExtension = iExtensionDelta.getExtension();
                this.readElements(iExtension.getConfigurationElements(), bl);
            }
        };
    }

    private IExtensionPoint a() {
        return this.pluginRegistry.getExtensionPoint(this.pluginID, this.extensionPointID);
    }
}

