/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EObjects {
    public static String getID(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof XMLResource) {
            XMLResource xMLResource = (XMLResource)resource;
            return xMLResource.getID(eObject);
        }
        return null;
    }

    public static boolean isAttachedTo(EditingDomain editingDomain, EObject eObject) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject) == editingDomain;
    }

    public static boolean isReadOnly(EObject eObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        return editingDomain != null && editingDomain.isReadOnly(eObject.eResource());
    }

    public static boolean isSuperTypeOf(EClass eClass, EClass eClass2) {
        return eClass == EcorePackage.Literals.EOBJECT || eClass.isSuperTypeOf(eClass2);
    }

    public static String toStringFeature(EClass eClass, EStructuralFeature eStructuralFeature) {
        return EObjects.toStringFeature(eClass, eStructuralFeature, false);
    }

    public static String toStringFeature(EClass eClass, EStructuralFeature eStructuralFeature, boolean bl) {
        return EObjects.appendFeature(new StringBuilder(), eClass, eStructuralFeature, bl).toString();
    }

    public static String toStringEClassifier(EClassifier eClassifier) {
        return EObjects.appendEClassifier(new StringBuilder(), eClassifier).toString();
    }

    public static String toStringEPackage(EPackage ePackage) {
        return EObjects.appendEPackage(new StringBuilder(), ePackage).toString();
    }

    public static StringBuilder appendFeature(StringBuilder stringBuilder, EClass eClass, EStructuralFeature eStructuralFeature) {
        return EObjects.appendFeature(stringBuilder, eClass, eStructuralFeature, false);
    }

    public static StringBuilder appendFeature(StringBuilder stringBuilder, EClass eClass, EStructuralFeature eStructuralFeature, boolean bl) {
        if (bl || eClass != null && eStructuralFeature.getEContainingClass() != eClass) {
            stringBuilder.append("{");
            EObjects.appendEClassifier(stringBuilder, (EClassifier)(eClass != null ? eClass : eStructuralFeature.getEContainingClass()));
            stringBuilder.append("}::");
        }
        stringBuilder.append(eStructuralFeature.getName());
        return stringBuilder;
    }

    public static StringBuilder appendEClassifier(StringBuilder stringBuilder, EClassifier eClassifier) {
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage != null) {
            EObjects.appendEPackage(stringBuilder, ePackage);
            stringBuilder.append("::");
        }
        stringBuilder.append(eClassifier.getName());
        return stringBuilder;
    }

    public static StringBuilder appendEPackage(StringBuilder stringBuilder, EPackage ePackage) {
        stringBuilder.append(ePackage.getNsPrefix());
        return stringBuilder;
    }

    public static <T extends EObject> T getAncestor(Class<T> clazz, EObject eObject) {
        return (T)((EObject)clazz.cast(EObjects.getAncestor(clazz::isInstance, eObject)));
    }

    public static EObject getAncestor(EClass eClass, EObject eObject) {
        return EObjects.getAncestor(arg_0 -> ((EClass)eClass).isInstance(arg_0), eObject);
    }

    public static EObject getAncestor(Predicate<EObject> predicate, EObject eObject) {
        if (eObject != null) {
            int n = 0;
            for (InternalEObject internalEObject = (InternalEObject)eObject; ++n < 100000 && internalEObject != null; internalEObject = internalEObject.eInternalContainer()) {
                if (!predicate.test((EObject)internalEObject)) continue;
                return internalEObject;
            }
        }
        return null;
    }

    public static EObject getCommonAncestor(EObject eObject, EObject eObject2) {
        return EObjects.getCommonAncestor(ContainmentProvider.INSTANCE, eObject, eObject2);
    }

    public static EObject getCommonAncestor(ContainmentProvider containmentProvider, EObject eObject, EObject eObject2) {
        if (EObjects.a(containmentProvider, eObject, eObject2) != null) {
            return eObject;
        }
        EObject eObject3 = eObject;
        int n = 0;
        while (containmentProvider.getDirectResource(eObject3) == null) {
            if (eObject3 == eObject2) {
                return eObject2;
            }
            EObject eObject4 = containmentProvider.getContainer(eObject3);
            if (eObject4 == null) break;
            EObject eObject5 = EObjects.a(containmentProvider, eObject4, eObject2);
            if (eObject5 != null) {
                assert (eObject4 == containmentProvider.getContainer(eObject5));
                return eObject4;
            }
            eObject3 = eObject4;
            if (++n <= 100000) continue;
            break;
        }
        return null;
    }

    static EObject a(ContainmentProvider containmentProvider, EObject eObject, EObject eObject2) {
        int n = 0;
        while (eObject2 != null && containmentProvider.getDirectResource(eObject2) == null) {
            EObject eObject3 = containmentProvider.getContainer(eObject2);
            if (eObject3 == eObject) {
                return eObject2;
            }
            eObject2 = eObject3;
            if (++n <= 100000) continue;
            break;
        }
        return null;
    }

    public static interface ContainmentProvider {
        public static final ContainmentProvider INSTANCE = new Resolving();

        default public Resource getDirectResource(EObject eObject) {
            return ((InternalEObject)eObject).eDirectResource();
        }

        default public EObject getContainer(EObject eObject) {
            return ((InternalEObject)eObject).eInternalContainer();
        }

        default public List<? extends EObject> getContents(EObject eObject) {
            return ((InternalEList)eObject.eContents()).basicList();
        }

        default public EStructuralFeature getContainingFeature(EObject eObject, EObject eObject2) {
            return eObject2.eContainingFeature();
        }

        public static class Resolving
        implements ContainmentProvider {
            @Override
            public EObject getContainer(EObject eObject) {
                return eObject.eContainer();
            }

            @Override
            public List<? extends EObject> getContents(EObject eObject) {
                return eObject.eContents();
            }
        }
    }
}

