/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import net.astah.emf.common.ecore.ETypedSetting;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class EObjectReference<T extends EObject>
implements ETypedSetting<T> {
    protected final EClass eClass;
    protected final Class<T> instanceClass;
    protected final ResourceSet resourceSet;
    protected final URI uri;
    protected T eReferent;

    public EObjectReference(EClass eClass, Class<T> clazz, ResourceSet resourceSet, URI uRI) {
        this(eClass, clazz, resourceSet, uRI, null);
    }

    EObjectReference(EClass eClass, Class<T> clazz, ResourceSet resourceSet, URI uRI, T t) {
        Objects.requireNonNull(clazz, "instanceClass");
        Objects.requireNonNull(resourceSet, "resourceSet");
        Objects.requireNonNull(uRI, "uri");
        this.eClass = eClass != null ? eClass : EcorePackage.Literals.EOBJECT;
        this.instanceClass = clazz;
        this.resourceSet = resourceSet;
        this.uri = uRI;
        this.eReferent = t;
        this.validate();
    }

    public static <T extends EObject> EObjectReference<T> of(EClass eClass, Class<T> clazz, ResourceSet resourceSet, URI uRI) {
        return new EObjectReference<T>(eClass, clazz, resourceSet, uRI);
    }

    public static <T extends EObject> EObjectReference<T> of(T t) {
        Objects.requireNonNull(t, "eObject");
        Resource resource = t.eResource();
        if (resource == null || resource.getResourceSet() == null) {
            throw new IllegalArgumentException("eReferent is not attached to ResourceSet");
        }
        ResourceSet resourceSet = resource.getResourceSet();
        EClass eClass = t.eClass();
        Class clazz = eClass.getInstanceClass();
        URI uRI = EcoreUtil.getURI(t);
        return new EObjectReference<T>(eClass, clazz, resourceSet, uRI, t);
    }

    public EObject getEObject() {
        T t = this.get(true);
        if (t != null) {
            return t.eContainer();
        }
        return null;
    }

    public EStructuralFeature getEStructuralFeature() {
        T t = this.get(true);
        if (t != null) {
            return t.eContainmentFeature();
        }
        return null;
    }

    public void set(Object object) {
        XMLResource xMLResource;
        String string;
        EObject eObject = (EObject)this.instanceClass.cast(object);
        T t = this.require();
        this.eReferent = null;
        Resource resource = t.eResource();
        if (resource instanceof XMLResource && (string = (xMLResource = (XMLResource)resource).getID(t)) != null) {
            xMLResource.setID((EObject)object, string);
        }
        if ((xMLResource = t.eContainmentFeature()) != null) {
            string = t.eContainer();
            if (xMLResource.isMany()) {
                List list = (List)string.eGet((EStructuralFeature)xMLResource);
                this.doSet(list, t, eObject);
            } else {
                string.eSet((EStructuralFeature)xMLResource, (Object)eObject);
            }
        } else {
            string = this.requireDirectResource((EObject)t);
            EList eList = string.getContents();
            this.doSet((List)eList, (Object)t, (Object)eObject);
        }
    }

    public boolean isSet() {
        return this.get(true) != null;
    }

    public void unset() {
        T t = this.require();
        this.eReferent = null;
        EReference eReference = t.eContainmentFeature();
        if (eReference != null) {
            EObject eObject = t.eContainer();
            if (eReference.isMany()) {
                List list = (List)eObject.eGet((EStructuralFeature)eReference);
                this.doRemove(list, t);
            } else {
                eObject.eUnset((EStructuralFeature)eReference);
            }
        } else {
            Resource resource = this.requireDirectResource((EObject)t);
            EList eList = resource.getContents();
            this.doRemove((List)eList, (Object)t);
        }
    }

    @Override
    public T get(boolean bl) {
        EObject eObject;
        if (this.eReferent == null) {
            EObject eObject2 = this.resourceSet.getEObject(this.uri, bl);
            if (this.instanceClass.isInstance(eObject2)) {
                this.eReferent = (EObject)this.instanceClass.cast(eObject2);
            } else if (!bl && !this.eClass.isAbstract()) {
                this.eReferent = (EObject)this.instanceClass.cast(this.createProxy(this.eClass, this.uri));
            }
        } else if (this.eReferent.eIsProxy() && bl && this.instanceClass.isInstance(eObject = EcoreUtil.resolve(this.eReferent, (ResourceSet)this.resourceSet))) {
            this.eReferent = (EObject)this.instanceClass.cast(eObject);
        }
        return this.eReferent;
    }

    @Override
    public Class<T> getInstanceClass() {
        return this.instanceClass;
    }

    protected void validate() {
        Class clazz = this.eClass.getInstanceClass();
        if (clazz != null && !clazz.isAssignableFrom(this.instanceClass)) {
            String string = "instanceClass {0} is not compatible with {1}";
            throw new IllegalArgumentException(MessageFormat.format("instanceClass {0} is not compatible with {1}", this.instanceClass, this.eClass));
        }
    }

    protected EObject createProxy(EClass eClass, URI uRI) {
        EObject eObject = EcoreUtil.create((EClass)eClass);
        ((InternalEObject)eObject).eSetProxyURI(uRI);
        return eObject;
    }

    protected T require() {
        T t = this.get(true);
        if (t == null) {
            throw new IllegalStateException("Failed to resolve reference: " + this.uri);
        }
        return t;
    }

    protected Resource requireDirectResource(EObject eObject) {
        Resource.Internal internal = ((InternalEObject)eObject).eDirectResource();
        if (internal == null) {
            String string = "{0} has no containing resource or container";
            throw new IllegalStateException(MessageFormat.format("{0} has no containing resource or container", eObject));
        }
        return internal;
    }

    protected <E> void doSet(List<E> list, E e2, E e3) {
        int n = list.indexOf(e2);
        if (n < 0) {
            String string = "Failed to set element {0} to {1} of {2}";
            throw new IllegalStateException(MessageFormat.format("Failed to set element {0} to {1} of {2}", e2, e3, list));
        }
        list.set(n, e3);
    }

    protected <E> void doRemove(List<E> list, E e2) {
        if (!list.remove(e2)) {
            String string = "Failed to remove element {0} from list {1}";
            throw new IllegalStateException(MessageFormat.format("Failed to remove element {0} from list {1}", e2, list));
        }
    }
}

