/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.ecore;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.uml2.common.util.CacheAdapter;

public abstract class EFeatureCache<T extends EObject, V>
implements Function<T, V> {
    private static final Object b = new Object();
    protected final EStructuralFeature feature;
    protected final Function<T, V> producer;

    protected EFeatureCache(EStructuralFeature eStructuralFeature) {
        this(eStructuralFeature, null);
    }

    protected EFeatureCache(EStructuralFeature eStructuralFeature, Function<T, V> function) {
        assert (function != null || this.getClass() != EFeatureCache.class && this.getClass().getEnclosingClass() != EFeatureCache.class) : "produce() must be overridden";
        this.feature = eStructuralFeature;
        this.producer = function;
    }

    @Override
    public V apply(T t) {
        return this.get(t);
    }

    public abstract V get(T var1);

    public abstract void invalidate(EObject var1);

    protected V produce(T t) {
        return this.producer.apply(t);
    }

    protected V decode(Object object) {
        return object != b ? (V)this.cast(object) : null;
    }

    protected Object encode(V v) {
        return v != null ? v : b;
    }

    protected V cast(Object object) {
        return (V)object;
    }

    public static class Fine<T extends EObject, V>
    extends EFeatureCache<T, V>
    implements INotifyChangedListener {
        final Map<T, Reference<Object>> b = new WeakHashMap<T, Reference<Object>>();

        public Fine(EStructuralFeature eStructuralFeature) {
            super(eStructuralFeature);
        }

        public Fine(EStructuralFeature eStructuralFeature, Function<T, V> function) {
            super(eStructuralFeature, function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(T t) {
            Object object;
            Map<Object, Reference<Object>> map = this.b;
            synchronized (map) {
                Object object2;
                object = this.b.get(t);
                if (object != null && (object2 = ((Reference)object).get()) != null) {
                    return this.decode(object2);
                }
            }
            map = this.cast(this.produce(t));
            object = this.b;
            synchronized (object) {
                this.b.putIfAbsent(t, this.createReference(this.encode(map)));
            }
            return (V)map;
        }

        @Override
        public void invalidate(EObject eObject) {
            this.b.remove(eObject);
        }

        public void notifyChanged(Notification notification) {
            Object object = notification.getNotifier();
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                this.invalidate(eObject);
            }
        }

        protected Reference<Object> createReference(Object object) {
            return new SoftReference<Object>(object);
        }
    }

    public static class Local<T extends EObject, V>
    extends EFeatureCache<T, V> {
        public Local(EStructuralFeature eStructuralFeature) {
            super(eStructuralFeature);
        }

        public Local(EStructuralFeature eStructuralFeature, Function<T, V> function) {
            super(eStructuralFeature, function);
        }

        @Override
        public V get(T t) {
            Object object;
            Resource resource = t.eResource();
            CacheAdapter cacheAdapter = CacheAdapter.getCacheAdapter(t);
            if (cacheAdapter != null && (object = cacheAdapter.get(resource, t, (Object)this.feature)) != null) {
                return this.decode(object);
            }
            object = this.cast(this.produce(t));
            if (cacheAdapter != null) {
                cacheAdapter.put(resource, t, (Object)this.feature, this.encode(object));
            }
            return object;
        }

        @Override
        public void invalidate(EObject eObject) {
            Resource resource = eObject.eResource();
            CacheAdapter.getCacheAdapter((Notifier)eObject).put(resource, eObject, (Object)this.feature, null);
        }
    }

    public static class Global<T extends EObject, V>
    extends EFeatureCache<T, V> {
        public Global(EStructuralFeature eStructuralFeature) {
            super(eStructuralFeature);
        }

        public Global(EStructuralFeature eStructuralFeature, Function<T, V> function) {
            super(eStructuralFeature, function);
        }

        @Override
        public V get(T t) {
            Object object;
            CacheAdapter cacheAdapter = CacheAdapter.getCacheAdapter(t);
            if (cacheAdapter != null && (object = cacheAdapter.get(t, (Object)this.feature)) != null) {
                return this.decode(object);
            }
            object = this.cast(this.produce(t));
            if (cacheAdapter != null) {
                cacheAdapter.put(t, (Object)this.feature, this.encode(object));
            }
            return (V)object;
        }

        @Override
        public void invalidate(EObject eObject) {
            CacheAdapter.getCacheAdapter((Notifier)eObject).put(eObject, (Object)this.feature, null);
        }
    }
}

