/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.astah.emf.common.datatransfer.TransferableResourceImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EMFResourceTransferable
implements ClipboardOwner,
Transferable {
    private static final Logger b = LoggerFactory.getLogger(EMFResourceTransferable.class);
    private static Marker c = MarkerFactory.getMarker((String)"clipboard");
    public static final String MIME_TYPE = "application/vnd.xmi+xml";
    public static final DataFlavor XMI_RESOURCE_FLAVOR = EMFResourceTransferable.a("application/vnd.xmi+xml", Resource.class);
    public static final DataFlavor XMI_INPUT_STREAM_FLAVOR = EMFResourceTransferable.a("application/vnd.xmi+xml", InputStream.class);
    static final DataFlavor[] a = new DataFlavor[]{XMI_RESOURCE_FLAVOR, XMI_INPUT_STREAM_FLAVOR};
    protected byte[] bytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EMFResourceTransferable(Collection<? extends EObject> collection) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransferableResourceImpl transferableResourceImpl = new TransferableResourceImpl();
        try {
            transferableResourceImpl.getContents().addAll(collection);
            transferableResourceImpl.save(byteArrayOutputStream, null);
            this.bytes = byteArrayOutputStream.toByteArray();
            if (b.isTraceEnabled(c)) {
                b.trace(c, new String(this.bytes, transferableResourceImpl.getEncoding()));
            }
        }
        finally {
            transferableResourceImpl.unload();
        }
    }

    public EMFResourceTransferable(Transferable transferable) {
        if (transferable.isDataFlavorSupported(XMI_RESOURCE_FLAVOR) && transferable.isDataFlavorSupported(XMI_INPUT_STREAM_FLAVOR)) {
            try {
                Object object = transferable.getTransferData(XMI_INPUT_STREAM_FLAVOR);
                if (!(object instanceof InputStream)) {
                    throw new UnsupportedOperationException();
                }
                InputStream inputStream = (InputStream)object;
                this.bytes = new byte[inputStream.available()];
                inputStream.read(this.bytes);
                inputStream.close();
            }
            catch (UnsupportedFlavorException | IOException exception) {
                throw new UnsupportedOperationException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])a.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : a) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (this.bytes != null) {
            Class<TransferableResourceImpl> clazz = dataFlavor.getRepresentationClass();
            if (clazz.isAssignableFrom(TransferableResourceImpl.class)) {
                b.debug("Duplicating XMI Resource for {}", (Object)dataFlavor);
                TransferableResourceImpl transferableResourceImpl = new TransferableResourceImpl();
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes);){
                    transferableResourceImpl.load(byteArrayInputStream, null);
                }
                return transferableResourceImpl;
            }
            if (clazz == InputStream.class) {
                return new ByteArrayInputStream(this.bytes);
            }
        }
        return null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.bytes = null;
    }

    static DataFlavor a(String string, Class<?> clazz) {
        try {
            return new DataFlavor("application/vnd.xmi+xml;class=" + clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError(classNotFoundException.getMessage(), classNotFoundException);
        }
    }
}

