/*
 * Decompiled with CFR 0.152.
 */
package net.astah.emf.common.collect;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.astah.emf.common.collect.a;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.AbstractSequentialInternalEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class SingleEObjectEList<E>
extends AbstractSequentialInternalEList<E>
implements EList<E>,
EStructuralFeature.Setting,
InternalEList.Unsettable<E>,
InternalEList<E> {
    protected final InternalEObject owner;
    protected final int featureID;
    protected final int sourceFeatureID;

    public SingleEObjectEList(InternalEObject internalEObject, int n, int n2) {
        this.owner = internalEObject;
        this.featureID = n;
        this.sourceFeatureID = n2;
    }

    public EObject getEObject() {
        return this.owner;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.getEStructuralFeature(this.featureID);
    }

    public EStructuralFeature getEStructuralFeature(int n) {
        return this.owner.eClass().getEStructuralFeature(n);
    }

    public Object get(boolean bl) {
        return this;
    }

    public void set(Object object) {
        List list = (List)object;
        if (list.isEmpty()) {
            this.clear();
        } else if (list.size() == 1) {
            this.owner.eSet(this.sourceFeatureID, list.get(0));
        } else {
            throw new IllegalArgumentException("newValue must be single valued list");
        }
    }

    public boolean isSet() {
        if (this.useIsSet()) {
            return this.owner.eIsSet(this.sourceFeatureID);
        }
        return this.owner.eGet(this.sourceFeatureID, false, true) != null;
    }

    public void unset() {
        this.clear();
    }

    public Iterator<E> iterator() {
        return this.newIterator();
    }

    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        ListIterator<E> listIterator = this.newListIterator();
        Iterators.advance(listIterator, (int)n);
        return listIterator;
    }

    public int size() {
        return this.isSet() ? 1 : 0;
    }

    public List<E> basicList() {
        return new a(this, this.owner, this.featureID, this.sourceFeatureID);
    }

    public Iterator<E> basicIterator() {
        return this.newNonResolvingListIterator();
    }

    public ListIterator<E> basicListIterator(int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        ListIterator<E> listIterator = this.newNonResolvingListIterator();
        Iterators.advance(listIterator, (int)n);
        return listIterator;
    }

    public E get(int n) {
        return this.get(n, this.resolve());
    }

    public int indexOf(Object object) {
        return this.indexOf(object, this.resolve());
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object, this.resolve());
    }

    public boolean add(E e2) {
        this.add(0, e2);
        return true;
    }

    public void add(int n, E e2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        if (n != 0 || this.isSet()) {
            throw new IllegalStateException();
        }
        this.owner.eSet(this.sourceFeatureID, e2);
    }

    public boolean remove(Object object) {
        if (this.indexOf(object) < 0) {
            return false;
        }
        this.remove(0);
        return true;
    }

    public E remove(int n) {
        if (n != 0 || !this.isSet()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        Object object = this.owner.eGet(this.sourceFeatureID, false, true);
        this.owner.eUnset(this.sourceFeatureID);
        return (E)object;
    }

    public E set(int n, E e2) {
        if (n != 0 || !this.isSet()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        Object object = this.owner.eGet(this.sourceFeatureID, false, true);
        this.owner.eSet(this.sourceFeatureID, e2);
        return (E)object;
    }

    public void clear() {
        if (this.isSet()) {
            this.owner.eUnset(this.sourceFeatureID);
        }
    }

    public E basicGet(int n) {
        return this.get(n, false);
    }

    public int basicIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    public int basicLastIndexOf(Object object) {
        return this.indexOf(object, false);
    }

    protected ListIterator<E> newListIterator() {
        return this.resolve() ? this.newResolvingListIterator() : this.newNonResolvingListIterator();
    }

    protected ListIterator<E> newResolvingListIterator() {
        return new ResolvingFeatureIteratorImpl(this.owner, this.sourceFeatureID);
    }

    protected ListIterator<E> newNonResolvingListIterator() {
        return new FeatureIteratorImpl(this.owner, this.sourceFeatureID);
    }

    protected Iterator<E> newIterator() {
        return this.newListIterator();
    }

    protected boolean useIsSet() {
        return true;
    }

    protected boolean resolve() {
        return true;
    }

    protected E get(int n, boolean bl) {
        if (n != 0 || !this.isSet()) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        Object object = this.owner.eGet(this.sourceFeatureID, bl, true);
        return (E)object;
    }

    protected int indexOf(Object object, boolean bl) {
        return this.isSet() && Objects.equals(this.owner.eGet(this.sourceFeatureID, bl, true), object) ? 0 : -1;
    }

    public static class ResolvingFeatureIteratorImpl<E>
    extends FeatureIteratorImpl<E> {
        public ResolvingFeatureIteratorImpl(InternalEObject internalEObject, int n) {
            super(internalEObject, n);
        }

        @Override
        protected boolean resolve() {
            return true;
        }
    }

    public static class FeatureIteratorImpl<E>
    implements ListIterator<E> {
        protected final InternalEObject owner;
        protected final int sourceFeatureID;
        protected int cursor;
        protected int lastRet = -1;

        public FeatureIteratorImpl(InternalEObject internalEObject, int n) {
            this.owner = internalEObject;
            this.sourceFeatureID = n;
        }

        @Override
        public boolean hasNext() {
            return this.cursor == 0 && this.isSet();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.owner.eGet(this.sourceFeatureID, this.resolve(), true);
            this.lastRet = this.cursor++;
            return (E)object;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor == 1 && this.isSet();
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object object = this.owner.eGet(this.sourceFeatureID, this.resolve(), true);
            this.lastRet = --this.cursor;
            return (E)object;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet != 0) {
                throw new IllegalStateException();
            }
            this.owner.eUnset(this.sourceFeatureID);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
        }

        @Override
        public void set(E e2) {
            if (this.lastRet != 0) {
                throw new IllegalStateException();
            }
            this.owner.eSet(this.sourceFeatureID, e2);
        }

        @Override
        public void add(E e2) {
            if (this.isSet()) {
                throw new IllegalStateException();
            }
            this.owner.eSet(this.sourceFeatureID, e2);
            this.lastRet = -1;
            ++this.cursor;
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean useIsSet() {
            return true;
        }

        protected boolean isSet() {
            if (this.useIsSet()) {
                return this.owner.eIsSet(this.sourceFeatureID);
            }
            return this.owner.eGet(this.sourceFeatureID, false, true) != null;
        }
    }
}

