/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor.adjuster;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.NotationFactory;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.edit.layout.TextAreaLayout;
import net.astah.notation.editor.adjuster.Adjuster;
import net.astah.notation.editor.adjuster.AdjusterConstraint;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjustingTarget;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.editor.ProcessModelElements;
import net.astah.stpa.stamp.notation.editor.STAMPLabelViewElement;
import org.eclipse.emf.ecore.EObject;

public class ProcessModelElementReorderingGuide
implements MovingAdjuster {
    private MovingAdjustingTarget target;

    public void setTarget(MovingAdjustingTarget target) {
        this.target = target;
    }

    public MovingAdjuster.Result adjustMoving(final Pnt2d start, final Pnt2d end, Set<AdjusterConstraint> constraints) {
        return new MovingAdjuster.Result(){

            public Vector getVector() {
                return NotationFactory.eINSTANCE.createVector(end.x - start.x, end.y - start.y);
            }

            public GNode createShape() {
                List<EObject> selectedModels;
                GNode feedbackNode = new GNode();
                List selectedDiagramElements = ProcessModelElementReorderingGuide.this.target.getViewElements().stream().map(v -> (DiagramElement)v.getModel()).filter(d -> DiagramElements.getModelElement((DiagramElement)d) instanceof ProcessVariable || DiagramElements.getModelElement((DiagramElement)d) instanceof ProcessValue).collect(Collectors.toList());
                feedbackNode.addChild((GNode)ProcessModelElementReorderingGuide.this.createRect(selectedDiagramElements, this.getVector()));
                STAMPLabelViewElement selectedViewElement = (STAMPLabelViewElement)((Object)ProcessModelElementReorderingGuide.this.target.getViewElements().get(0));
                Shape label = selectedViewElement.getDestinationLabelToReorder(end);
                if (label != null && ProcessModelElements.createCommandToReorder(selectedModels = selectedDiagramElements.stream().map(d -> DiagramElements.getModelElement((DiagramElement)d)).collect(Collectors.toList()), label, end.y).canExecute()) {
                    feedbackNode.addChild((GNode)ProcessModelElementReorderingGuide.this.createLine(selectedViewElement, label, end.y));
                }
                return feedbackNode;
            }
        };
    }

    private GRect createRect(List<DiagramElement> selectedDiagramElements, Vector vector) {
        Bounds bounds = new LayoutCalculator().getTotalBounds(selectedDiagramElements);
        GRect rect = new GRect(bounds.getX() + vector.getX(), bounds.getY() + vector.getY(), bounds.getWidth(), bounds.getHeight());
        rect.setColorNo((byte)3);
        return rect;
    }

    private GPolyline createLine(STAMPLabelViewElement viewElement, Shape label, double y) {
        STAMPLabel firstLabel = (STAMPLabel)viewElement.getModel();
        DiagramElement compartment = firstLabel.getOwningElement();
        STAMPComponentShape componentShape = (STAMPComponentShape)compartment.getOwningElement();
        Bounds componentBounds = componentShape.getBounds();
        Bounds labelBounds = label.getBounds();
        double lineY = labelBounds.getY();
        if ((double)ProcessModelElements.getLocation(label, y) < 0.5) {
            TextAreaLayout layout = viewElement.getTextAreaLayout();
            lineY -= layout.getTopMargin();
        } else {
            lineY += labelBounds.getHeight();
        }
        GPolyline line = new GPolyline(new Pnt2d[]{new Pnt2d(componentBounds.getX(), lineY), new Pnt2d(componentBounds.getX() + componentShape.getBounds().getWidth(), lineY)});
        line.setColorNo((byte)3);
        return line;
    }

    public MovingAdjuster intersect(Adjuster<MovingAdjustingTarget> adjuster) {
        return null;
    }
}

