/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.awt.Color;
import javax.swing.ImageIcon;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jview.HyperLinkIcon;
import net.astah.jomt.jview.HyperLinkIconImpl;
import net.astah.jomt.jview.IconResource;
import net.astah.jomt.jview.RectangleDrawSuggest;
import net.astah.jomt.jviewElement.CommentBody;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IResizableViewElement;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ShapeTransformer;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.editor.STAMPShapeViewElementImpl;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class STAMPNoteViewElement
extends STAMPShapeViewElementImpl<STAMPShape>
implements IMovableViewElement,
IResizableViewElement {
    static final byte BODY_COLOR = 1;
    static final byte FRAME_COLOR = 2;
    static final byte KNOB_COLOR = 2;
    static final byte SHADOW_COLOR = 7;
    static final byte CHAR_COLOR = 2;
    protected CommentBody commentBody;
    protected GRect frame;
    private RectangleDrawSuggest drawSuggest;
    private HyperLinkIcon hyperLinkIcon;
    private MovingAdjuster.Factory movingAdjusterFactory;
    private ResizingAdjuster.Factory resizingAdjusterFactory;

    public STAMPNoteViewElement(STAMPShape model) {
        super(model);
    }

    protected void refresh() {
        super.refresh();
        this.init();
    }

    private void init() {
        this.initFrame();
        this.initCommentBody();
        this.initDrawSuggest();
        this.initHyperLinkIcon();
        this.initAdjusterFactory();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.drawSuggest)) {
            return adapter.cast(this.drawSuggest);
        }
        if (adapter.isInstance(this.hyperLinkIcon)) {
            return adapter.cast(this.hyperLinkIcon);
        }
        if (adapter.isInstance(this.movingAdjusterFactory)) {
            return adapter.cast(this.movingAdjusterFactory);
        }
        if (adapter.isInstance(this.resizingAdjusterFactory)) {
            return adapter.cast(this.resizingAdjusterFactory);
        }
        return (T)super.getAdapter(adapter);
    }

    private void initFrame() {
        if (this.frame == null) {
            this.frame = new GRect();
            int type = 0;
            type |= 4;
            this.frame.setType(type |= 1);
            this.frame.setModel((Object)this.getModel());
            this.frame.setFilled(false);
            this.frame.setAlpha(0.0f);
            this.frame.setSelectionType((byte)1);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this);
            this.addNodeSelectionListener((GNodeSelectionListener)this.frame);
            this.addNode((GNode)this.frame);
        }
    }

    private void initCommentBody() {
        if (this.commentBody == null) {
            this.commentBody = new CommentBody();
            this.commentBody.setModel((Object)this.getModel());
            this.commentBody.setBackgroundNo((byte)1);
            this.commentBody.setFilled(true);
            this.commentBody.setSelectionType((byte)2);
            this.frame.addNodeSelectionListener((GNodeSelectionListener)this.commentBody);
            this.addNode((GNode)this.commentBody);
        }
    }

    private void initDrawSuggest() {
        this.drawSuggest = new RectangleDrawSuggest((IViewElement)this);
        SwingImageIcon image = new SwingImageIcon((ImageIcon)IconResource.getNormalSizeNoteAnchorIcon());
        this.drawSuggest.addModeAction("net.astah.stpa.stamp.ui.control.mode.CreateNoteAnchor", (CImageIcon)image);
    }

    private void initHyperLinkIcon() {
        if (this.hyperLinkIcon != null) {
            return;
        }
        this.hyperLinkIcon = new HyperLinkIconImpl((IViewElement)this, (EObject)this.getModel());
        this.hyperLinkIcon.addIconNode();
    }

    private void initAdjusterFactory() {
        this.movingAdjusterFactory = (MovingAdjuster.Factory)((IDiagramViewElement)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class)).getAdapter(MovingAdjuster.Factory.class);
        this.resizingAdjusterFactory = (ResizingAdjuster.Factory)((IDiagramViewElement)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class)).getAdapter(ResizingAdjuster.Factory.class);
    }

    protected void update() {
        super.update();
        this.updateHyperLinkIcon();
    }

    private void updateHyperLinkIcon() {
        this.hyperLinkIcon.update();
    }

    protected void updateStroke() {
        Notifier model = this.getModel();
        IItemGraphicalStyleProvider provider = (IItemGraphicalStyleProvider)ItemProviders.adapt((Object)model, IItemGraphicalStyleProvider.class);
        Object width = provider.getGraphicalStyle((Object)model, (Object)IItemGraphicalStyleProvider.Feature.STROKE_WIDTH);
        if (width instanceof Number) {
            this.commentBody.setRimWidth(((Number)width).intValue());
        } else {
            this.commentBody.setRimWidth(1);
        }
    }

    public void updateColor() {
        Notifier model = this.getModel();
        IItemGraphicalStyleProvider provider = (IItemGraphicalStyleProvider)ItemProviders.adapt((Object)model, IItemGraphicalStyleProvider.class);
        URI fillColorURI = (URI)provider.getGraphicalStyle((Object)model, (Object)IItemGraphicalStyleProvider.Feature.FILL_COLOR);
        if (fillColorURI != null) {
            Color fillColor = new ColorURIResolver(null, null).resolve(fillColorURI);
            this.commentBody.setBackgroundColor((CColor)new SwingColor(fillColor));
        } else {
            this.commentBody.setBackgroundColor(GolfWidgetFactory.instance().createCColor(Color.PINK));
        }
        URI strokeColorURI = (URI)provider.getGraphicalStyle((Object)model, (Object)IItemGraphicalStyleProvider.Feature.STROKE_COLOR);
        if (strokeColorURI != null) {
            Color strokeColor = new ColorURIResolver(null, null).resolve(strokeColorURI);
            this.commentBody.setForegraundColor((CColor)new SwingColor(strokeColor));
        } else {
            this.commentBody.setColorNo((byte)2);
        }
        this.frame.setKnobColorNo((byte)2);
        this.commentBody.setShadowColorNo((byte)7);
    }

    protected void layout(Bounds bounds) {
        super.layout(bounds);
        this.layoutFrame(bounds);
        this.layoutHyperLinkIcon();
    }

    protected void layoutHyperLinkIcon() {
        this.hyperLinkIcon.relocate((GNode)this.frame);
    }

    private void layoutFrame(Bounds bounds) {
        this.frame.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.commentBody.update(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    protected GGeometry getBounds(Rectangle2d bounds) {
        return super.getBounds(this.frame, bounds);
    }

    public void setDepth(int depth) {
        super.setDepth(depth);
        this.commentBody.setDepth(depth);
        this.frame.setDepth(depth - 1);
    }

    public void setSelected(boolean selected) {
        this.frame.setSelected(selected);
        super.setSelected(selected);
    }

    public ITransformer startMove(Pnt2d startLocation) {
        return new ShapeTransformer((IShapeViewElement)this, startLocation);
    }

    public ITransformer startResize(Pnt2d startLocation, int knob) {
        return new ShapeTransformer((IShapeViewElement)this, startLocation, knob);
    }
}

