/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.awt.geom.Point2D;
import net.astah.golf.draw.GArrow;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CImageIcon;
import net.astah.notation.editor.EdgeTransformer;
import net.astah.notation.editor.IEdgeViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IRepointableViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.editor.STAMPEdgeViewElementImpl;
import net.astah.stpa.stamp.notation.editor.STAMPLinkDrawSuggest;

public abstract class STAMPLinkViewElement
extends STAMPEdgeViewElementImpl
implements IMovableViewElement,
IRepointableViewElement {
    private STAMPLinkDrawSuggest drawSuggest;

    public STAMPLinkViewElement(STAMPEdge model) {
        super(model);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance((Object)this.drawSuggest)) {
            return adapter.cast((Object)this.drawSuggest);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.initDrawSuggest();
    }

    private void initDrawSuggest() {
        this.drawSuggest = new STAMPLinkDrawSuggest((IViewElement)this);
        this.drawSuggest.addCommandAction(this.getCommandAction(), this.getIcon());
    }

    protected abstract String getCommandAction();

    protected abstract CImageIcon getIcon();

    public void setSelected() {
        this.setSelected(true);
        this.getChildren().stream().filter(child -> child instanceof GArrow).forEach(arrowChild -> arrowChild.setSelected(true));
        super.setSelected();
    }

    public ITransformer startMove(Pnt2d startLocation) {
        return new EdgeTransformer((IEdgeViewElement)this, startLocation, EdgeTransformer.MoveType.MOVE);
    }

    public ITransformer startRepoint(Pnt2d startLocation) {
        GArrow arrow = this.getArrow();
        if ((this.isPickKnob(arrow.getKnobPoints()[0], startLocation) || this.isPickKnob(arrow.getKnobPoints()[arrow.getKnobPoints().length - 1], startLocation)) && !this.isSelected()) {
            return null;
        }
        return new EdgeTransformer((IEdgeViewElement)this, startLocation, EdgeTransformer.MoveType.REPOINT);
    }

    private GArrow getArrow() {
        return this.getChildren().stream().filter(GArrow.class::isInstance).map(GArrow.class::cast).findFirst().orElse(null);
    }

    private boolean isPickKnob(Pnt2d knobLocation, Pnt2d mouseLocation) {
        return new Rectangle2d(knobLocation.x - 5.0, knobLocation.y - 5.0, 10.0, 10.0).contains((Point2D)mouseLocation);
    }
}

