/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import javax.swing.ImageIcon;
import net.astah.dd.dc.Bounds;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GOval;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jview.OvalDrawSuggest;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ShapeTransformer;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.editor.STAMPLinkEndDrawSuggest;
import net.astah.stpa.stamp.notation.editor.STAMPShapeViewElementImpl;
import net.astah.stpa.stamp.provider.STAMPEditPlugin;

public class STAMPLinkEndViewElement
extends STAMPShapeViewElementImpl<STAMPShape>
implements IMovableViewElement {
    protected GOval bodyRect;
    private OvalDrawSuggest drawSuggest;
    private MovingAdjuster.Factory movingAdjusterFactory;
    private static final byte FRAME_COLOR = 2;
    private static final byte BODY_COLOR = 2;
    private static final byte KNOB_COLOR = 2;
    private static final byte SHADOW_COLOR = 7;

    public STAMPLinkEndViewElement(STAMPShape model) {
        super(model);
    }

    public void refresh() {
        super.refresh();
        this.init();
    }

    protected void init() {
        this.initBodyRect();
        this.initDrawSuggest();
        this.initAdjusterFactory();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.drawSuggest)) {
            return adapter.cast(this.drawSuggest);
        }
        if (adapter.isInstance(this.movingAdjusterFactory)) {
            return adapter.cast(this.movingAdjusterFactory);
        }
        return (T)super.getAdapter(adapter);
    }

    protected void initBodyRect() {
        if (this.bodyRect == null) {
            int type = 0;
            type |= 4;
            this.bodyRect = new GOval();
            this.bodyRect.setType(type |= 1);
            this.bodyRect.setFilled(true);
            this.bodyRect.setModel((Object)this.getModel());
            this.bodyRect.addNodeSelectionListener((GNodeSelectionListener)this.bodyRect);
            this.bodyRect.setSelectionType((byte)3);
            this.addNodeSelectionListener((GNodeSelectionListener)this.bodyRect);
            this.addNode((GNode)this.bodyRect);
        }
    }

    protected void initAdjusterFactory() {
        this.movingAdjusterFactory = (MovingAdjuster.Factory)((IDiagramViewElement)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class)).getAdapter(MovingAdjuster.Factory.class);
    }

    public void update() {
        super.update();
        this.updateBodyRect();
    }

    protected void updateBodyRect() {
        this.bodyRect.setVisible(true);
        this.bodyRect.setPickable(true);
        this.bodyRect.setSelectable(true);
    }

    protected void updateStroke() {
        GraphicalStyles.applyStrokeWidth((GRimmedGeometry)this.bodyRect, (Object)this.getModel(), (int)2);
    }

    protected void updateColor() {
        GraphicalStyles.applyFillColor((GGeometry)this.bodyRect, (Object)this.getModel(), (byte)2);
        GraphicalStyles.applyStrokeColor((GGeometry)this.bodyRect, (Object)this.getModel(), (byte)2);
        this.bodyRect.setKnobColorNo((byte)2);
        this.bodyRect.setShadowColorNo((byte)7);
    }

    protected void layout(Bounds bounds) {
        this.layoutBodyRect(bounds);
    }

    protected void layoutBodyRect(Bounds bounds) {
        this.bodyRect.setPoint(new Pnt2d(bounds.getX(), bounds.getY()));
        this.bodyRect.setWidth(bounds.getWidth());
        this.bodyRect.setHeight(bounds.getHeight());
    }

    protected GGeometry getBounds(Rectangle2d bounds) {
        if (this.bodyRect != null) {
            bounds.x = this.bodyRect.getX();
            bounds.y = this.bodyRect.getY();
            bounds.width = this.bodyRect.getWidth();
            bounds.height = this.bodyRect.getHeight();
        }
        return this.bodyRect;
    }

    public void setSelected() {
        this.bodyRect.setSelected(true);
    }

    public ITransformer startMove(Pnt2d startLocation) {
        return new ShapeTransformer((IShapeViewElement)this, startLocation);
    }

    private void initDrawSuggest() {
        this.drawSuggest = new STAMPLinkEndDrawSuggest((IViewElement)this);
        String key = "diagramview.button.drop_down_component";
        SwingImageIcon image = new SwingImageIcon((ImageIcon)SwingIconRegistry.INSTANCE.getIcon(STAMPEditPlugin.getPlugin().getImage("full/obj16/Link")));
        this.drawSuggest.addModeAction("net.astah.stpa.stamp.ui.control.mode.CreateControlLink", (CImageIcon)image, key);
    }
}

