/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.List;
import net.astah.dd.dc.Point;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jview.EdgeDrawSuggest;
import net.astah.notation.Edge;
import net.astah.notation.editor.IViewElement;

public class STAMPLinkDrawSuggest
extends EdgeDrawSuggest {
    public STAMPLinkDrawSuggest(IViewElement owner) {
        super(owner);
    }

    public boolean doAction(CCanvas canvas, Pnt2d pnt, int id) {
        List nodes = canvas.getSelectedNodes();
        canvas.unselect();
        this.getOwner().setSelected();
        boolean result = super.doAction(canvas, pnt, id);
        if (!result) {
            canvas.unselect();
            for (GNode node : nodes) {
                node.setSelected(true);
            }
        }
        return result;
    }

    public boolean isDoCreateRelationAction() {
        return false;
    }

    public Pnt2d createModeArgumentPoint(Pnt2d mouseEventPnt) {
        return null;
    }

    protected Pnt2d getButtonPoint(GNode node, GIconButton button, Pnt2d mousePnt) {
        List waypoints;
        Line2d midLine;
        Object model = node.getModel();
        if (!(model instanceof Edge)) {
            return null;
        }
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Point origin = layoutCalculator.getOrigin(model);
        Point midpoint = layoutCalculator.getAnchorPoint(model, null, origin);
        if (midpoint != null && (midLine = this.getNearestLine(waypoints = Geometries.toPnt2d((List)layoutCalculator.getWaypoints(model, origin)), Geometries.toPnt2d((Point)midpoint))) != null) {
            double theta = Math.atan2(midLine.getY2() - midLine.getY1(), midLine.getX2() - midLine.getX1());
            double horizontal = button.getWidth();
            double vertical = button.getHeight();
            double r = Math.abs(Math.sqrt(1.0 / (Math.pow(Math.sin(theta += Math.toRadians(-90.0)), 2.0) / Math.pow(vertical, 2.0) + Math.pow(Math.cos(theta), 2.0) / Math.pow(horizontal, 2.0))));
            double x = r * Math.cos(theta);
            double y = r * Math.sin(theta);
            return new Pnt2d(midpoint.getX() + x - button.getWidth() / 2.0, midpoint.getY() + y - button.getHeight() / 2.0);
        }
        return new Pnt2d(0.0, 0.0);
    }

    protected boolean isExcludeKnobsOnWay() {
        return false;
    }
}

