/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.GolfAction;
import net.astah.golf.control.KeybindHandler;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRoundRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.BaseHighlighter;
import net.astah.jomt.jview.Highlighter;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.Shape;
import net.astah.notation.edit.layout.Layout;
import net.astah.notation.edit.layout.TextAreaLayout;
import net.astah.notation.edit.provider.IItemLayoutProvider;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.IEdgeViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IResizableViewElement;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.Feedback;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.editor.ProcessModelElements;
import net.astah.stpa.stamp.notation.editor.STAMPCompartmentViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPComponentViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPLabelTransformer;
import net.astah.stpa.stamp.notation.editor.STAMPLinkViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPNoteViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPShapeViewElementImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;

public class STAMPLabelViewElement
extends STAMPShapeViewElementImpl<STAMPLabel>
implements IMovableViewElement,
IResizableViewElement,
KeybindHandler {
    private CJomtTextNode name;
    private MovingAdjuster.Factory movingAdjusterFactory;
    private Highlighter highlighter;
    private static final byte KNOB_COLOR = 2;
    private static final byte NAME_COLOR = 2;
    private static final String ACTION_PREFIX = "net.astah.stpa.stamp.ui.control.";
    private static final String ACTION_POSTFIX = "%%%d";
    private static final String ACTION_ADD_CONTROL_ACTION = "net.astah.stpa.stamp.ui.control.AddControlAction%%%d";
    private static final String ACTION_ADD_FEEDBACK = "net.astah.stpa.stamp.ui.control.AddFeedback%%%d";
    private static final String ACTION_ADD_PROCESS_VARIABLE = "net.astah.stpa.stamp.ui.control.AddProcessVariable%%%d";
    private static final String ACTION_ADD_PROCESS_VALUE = "net.astah.stpa.stamp.ui.control.AddProcessValue%%%d";

    public STAMPLabelViewElement(STAMPLabel model) {
        super(model);
    }

    public void refresh() {
        super.refresh();
        this.init();
    }

    private void init() {
        this.initName();
        this.initAdjusterFactory();
        this.initHighlighter();
    }

    private void initHighlighter() {
        this.highlighter = new BaseHighlighter((IViewElement)this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.movingAdjusterFactory)) {
            return adapter.cast(this.movingAdjusterFactory);
        }
        if (adapter.isInstance(this.highlighter)) {
            IEdgeViewElement edgeViewElement = (IEdgeViewElement)this.getAncestor(IEdgeViewElement.class);
            STAMPComponentViewElement componentViewElement = (STAMPComponentViewElement)((Object)this.getAncestor(STAMPComponentViewElement.class));
            if (edgeViewElement == null && componentViewElement != null) {
                return componentViewElement.getAdapter(adapter);
            }
            return adapter.cast(this.highlighter);
        }
        return (T)super.getAdapter(adapter);
    }

    private void initName() {
        if (this.name == null) {
            TextAreaLayout layout;
            this.name = JomtWidgetFactory.instance().createJomtTextAreaNode();
            if (this.getParent() instanceof STAMPLinkViewElement || ProcessModelElements.isProcessModelElement((DiagramElement)this.getModel())) {
                this.name.setType(69);
                this.name.setWrapLine(true);
            } else {
                if (this.getParent() instanceof STAMPComponentViewElement) {
                    this.name.setType(68);
                } else {
                    this.name.setType(64);
                }
                this.name.setWrapLine(this.isMultiline());
            }
            this.name.setModel((Object)this.getModel());
            if (this.getParent() instanceof STAMPNoteViewElement || this.isProcessModelName()) {
                this.name.setSelectionType((byte)0);
                this.name.setSelectionKnobNodeType((byte)100);
                this.name.setComponentSelectAll(false);
            } else {
                this.name.setSelectionType((byte)1);
                this.name.setSelectionKnobNodeType((byte)101);
                this.name.setComponentSelectAll(true);
                this.name.setAllowedNewLine(false);
            }
            this.name.addNodeSelectionListener((GNodeSelectionListener)this);
            this.name.setAlpha(0.0f);
            STAMPDiagramElement owner = ((STAMPLabel)this.getModel()).getSTAMPOwningElement();
            if (!(owner instanceof STAMPEdge) && (layout = this.getTextAreaLayout()) != null && layout.isLineWrappable() && !layout.isWidthStretch()) {
                this.addFocusListener(owner, layout);
            }
            if (this.isProcessModelName()) {
                this.name.setEditable(false);
            }
            this.addNode((GNode)this.name);
        }
    }

    private void initAdjusterFactory() {
        STAMPCompartmentViewElement viewElement = (STAMPCompartmentViewElement)((Object)ViewElements.getAncestor((GNode)this, STAMPCompartmentViewElement.class));
        if (viewElement != null) {
            this.movingAdjusterFactory = viewElement.getAdapter(MovingAdjuster.Factory.class);
        }
    }

    private boolean isMultiline() {
        Element element = (Element)DiagramElements.getModelElement((DiagramElement)((DiagramElement)this.getModel()), Element.class);
        if (element == null) {
            return false;
        }
        IItemPropertySource propertySource = (IItemPropertySource)ItemProviders.adapt((EObject)element, IItemPropertySource.class);
        if (propertySource != null) {
            for (String featureName : Arrays.asList("name", "body")) {
                Object feature;
                IItemPropertyDescriptor propertyDescriptor = propertySource.getPropertyDescriptor((Object)element, (Object)featureName);
                if (propertyDescriptor == null || !((feature = propertyDescriptor.getFeature((Object)element)) instanceof EStructuralFeature) || ((EStructuralFeature)feature).getEType().getInstanceClass() != String.class) continue;
                return propertyDescriptor.isMultiLine((Object)element);
            }
        }
        return false;
    }

    private void addFocusListener(final STAMPDiagramElement owner, final TextAreaLayout layout) {
        final Component component = this.name.getTextComponent().getComponent();
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)STAMPLabelViewElement.this.getModel())) != null) {
                    STAMPLabelViewElement.this.setWidthToComponent(component, owner, layout);
                }
            }
        });
    }

    private void setWidthToComponent(Component component, STAMPDiagramElement owner, TextAreaLayout layout) {
        if (layout.needsToWrapLine((DiagramElement)this.getModel())) {
            component.setSize((int)(new LayoutCalculator().getBounds((Object)owner).getWidth() - layout.getLeftMargin() - layout.getRightMargin()), component.getHeight());
        }
    }

    protected void update() {
        super.update();
        this.updateName();
    }

    private void updateName() {
        String mark = "";
        EObject element = DiagramElements.getModelElement((DiagramElement)((DiagramElement)this.getModel()));
        if (element instanceof ProcessVariable) {
            mark = "* ";
        } else if (element instanceof ProcessValue) {
            mark = "- ";
        }
        String nameText = ((STAMPLabel)this.getModel()).getText() == null ? "" : ((STAMPLabel)this.getModel()).getText();
        this.name.setString(mark + nameText);
        this.name.setSelectedString(nameText);
    }

    public void updateStyle() {
        super.updateStyle();
        this.updateFont();
    }

    protected void updateColor() {
        GraphicalStyles.applyFontColor((GGeometry)this.name, (Object)this.getModel(), (byte)2);
        this.name.setKnobColorNo((byte)2);
    }

    public boolean isHighlighted() {
        if (((STAMPLabel)this.getModel()).getOwningElement() instanceof STAMPComponentShape) {
            return false;
        }
        return super.isHighlighted();
    }

    protected GNode createHighlightShape() {
        GRoundRect rect = this.createHighlightRect();
        rect.setAlpha(0.2f);
        rect.setFilled(true);
        rect.setBackgroundColor(GraphicalStyles.getHighlightColor((Object)this.getModel(), (Object)IItemGraphicalStyleProvider.Feature.FONT_COLOR));
        return rect;
    }

    private GRoundRect createHighlightRect() {
        Rectangle2d bounds = new Rectangle2d();
        this.getBounds(bounds);
        double x = bounds.x - 10.0;
        double y = bounds.y - 10.0;
        double width = bounds.width + 20.0;
        double height = bounds.height + 20.0;
        return new GRoundRect(x, y, width, height, 20.0, 20.0);
    }

    protected void updateFont() {
        GraphicalStyles.applyFont((GGeometry)this.name, (Object)this.getModel());
    }

    protected void layout(Bounds bounds) {
        super.layout(bounds);
        TextAreaLayout layout = this.getTextAreaLayout();
        if (layout != null) {
            this.name.setWrapLine(layout.needsToWrapLine((DiagramElement)this.getModel()));
        }
        this.layoutNameRect(bounds);
    }

    protected void layoutHighlightShape() {
        super.layoutHighlightShape();
        if (this.highlight != null) {
            GRoundRect rect = this.createHighlightRect();
            ((GRoundRect)this.highlight).setRoundRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
    }

    private void layoutNameRect(Bounds bounds) {
        if (bounds.getHeight() != 0.0) {
            this.name.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        } else {
            this.name.setVisible(false);
        }
    }

    private boolean isProcessModelName() {
        STAMPLabel label = (STAMPLabel)this.getModel();
        DiagramElement owner = label.getOwningElement();
        if (!(owner instanceof STAMPCompartment)) {
            return false;
        }
        EObject element = DiagramElements.getModelElement((DiagramElement)owner);
        if (!(element instanceof ProcessModel)) {
            return false;
        }
        EList elements = owner.getOwnedElements();
        return !elements.isEmpty() && elements.get(0) == label;
    }

    public TextAreaLayout getTextAreaLayout() {
        STAMPDiagramElement owner = ((STAMPLabel)this.getModel()).getSTAMPOwningElement();
        IItemLayoutProvider provider = (IItemLayoutProvider)ItemProviders.adapt((EObject)owner, IItemLayoutProvider.class);
        Layout layout = provider.getLayout((Object)owner);
        if (layout == null) {
            return null;
        }
        Layout ownedLayout = layout.getOwnedLayoutById("text_area");
        return ownedLayout instanceof TextAreaLayout ? (TextAreaLayout)ownedLayout : null;
    }

    protected GGeometry getBounds(Rectangle2d bounds) {
        return super.getBounds(this.name.body, bounds);
    }

    public IViewElement getMovableViewElement() {
        IViewElement movableViewElement;
        GNode parent = this.getParent();
        if (parent instanceof IViewElement && (movableViewElement = ((IViewElement)parent).getMovableViewElement()) != null) {
            return movableViewElement;
        }
        return super.getMovableViewElement();
    }

    public GNode createMovingShape() {
        GNode tempNode;
        GNode node = super.createMovingShape();
        if (node == null) {
            return null;
        }
        GNode parent = this.getParent();
        if (parent instanceof IViewElement && (tempNode = ((IViewElement)parent).createMovingShape()) != null) {
            node.addChild(tempNode);
        }
        return node;
    }

    public void setDepth(int depth) {
        super.setDepth(depth);
        this.name.setDepth(depth);
    }

    public void setSelected() {
        if (!(this.getParent() instanceof STAMPComponentViewElement)) {
            super.setSelected();
        }
    }

    public void selectionChange(boolean selected) {
        if (this.getParent() instanceof STAMPNoteViewElement) {
            this.getParent().setSelected(selected);
        }
    }

    public ITransformer startMove(Pnt2d startLocation) {
        GNode parentNode = this.getParent();
        if (parentNode instanceof STAMPComponentViewElement) {
            return ((STAMPComponentViewElement)parentNode).startMove(startLocation);
        }
        if (parentNode instanceof STAMPNoteViewElement) {
            return null;
        }
        return new STAMPLabelTransformer((IShapeViewElement)this, startLocation);
    }

    public ITransformer startResize(Pnt2d startLocation, int knob) {
        GNode parentNode = this.getParent();
        if (parentNode instanceof STAMPComponentViewElement || parentNode instanceof STAMPNoteViewElement) {
            return null;
        }
        return new STAMPLabelTransformer((IShapeViewElement)this, startLocation, knob);
    }

    public void handleKeybind(Object action) {
        String actionName = this.getActionName(action);
        if (actionName == null) {
            return;
        }
        GolfAction golfAction = new GolfAction(actionName);
        ActionEvent actionEvent = new ActionEvent((Object)this, 1001, actionName);
        golfAction.actionPerformed(actionEvent);
    }

    private String getActionName(Object action) {
        EObject model = DiagramElements.getModelElement((DiagramElement)((DiagramElement)this.getModel()));
        if (action == KeybindHandler.ActionKind.PRESSED_ENTER || action == KeybindHandler.ActionKind.PRESSED_SHIFT_ENTER) {
            if (model instanceof Signal) {
                Link link = (Link)EObjects.getAncestor(Link.class, (EObject)model);
                int index = link.getSignals().indexOf((Object)model);
                if (action == KeybindHandler.ActionKind.PRESSED_ENTER) {
                    ++index;
                }
                if (model instanceof ControlAction) {
                    return String.format(ACTION_ADD_CONTROL_ACTION, index);
                }
                if (model instanceof Feedback) {
                    return String.format(ACTION_ADD_FEEDBACK, index);
                }
            } else {
                if (model instanceof ProcessVariable) {
                    ProcessModel processModel = (ProcessModel)EObjects.getAncestor(ProcessModel.class, (EObject)model);
                    int index = processModel.getVariables().indexOf((Object)model);
                    if (action == KeybindHandler.ActionKind.PRESSED_ENTER) {
                        ++index;
                    }
                    return String.format(ACTION_ADD_PROCESS_VARIABLE, index);
                }
                if (model instanceof ProcessValue) {
                    ProcessVariable processVariable = (ProcessVariable)EObjects.getAncestor(ProcessVariable.class, (EObject)model);
                    int index = processVariable.getValues().indexOf((Object)model);
                    if (action == KeybindHandler.ActionKind.PRESSED_ENTER) {
                        ++index;
                    }
                    return String.format(ACTION_ADD_PROCESS_VALUE, index);
                }
            }
        }
        return null;
    }

    public Shape getDestinationLabelToReorder(Pnt2d end) {
        DiagramElement compartment = ((STAMPLabel)this.getModel()).getOwningElement();
        Shape owner = (Shape)compartment.getOwningElement();
        Rectangle2d rect = Geometries.toRectangle2d((Bounds)owner.getBounds());
        if (!rect.contains((Point2D)end)) {
            return null;
        }
        EList diagramElements = compartment.getOwnedElements();
        Shape label = null;
        for (int i = 1; i < diagramElements.size(); ++i) {
            label = (Shape)diagramElements.get(i);
            Bounds bounds = label.getBounds();
            if (!(end.y <= bounds.getY() + bounds.getHeight())) continue;
            return label;
        }
        return label;
    }

    public int compareTo(IViewElement viewElement) {
        STAMPLabel label = (STAMPLabel)this.getModel();
        if (!ProcessModelElements.isProcessModelElement((DiagramElement)label)) {
            return super.compareTo(viewElement);
        }
        if (!(viewElement instanceof STAMPLabelViewElement)) {
            return super.compareTo(viewElement);
        }
        STAMPLabel comparedLabel = (STAMPLabel)((STAMPLabelViewElement)viewElement).getModel();
        if (!ProcessModelElements.isProcessModelElement((DiagramElement)comparedLabel)) {
            return super.compareTo(viewElement);
        }
        return Double.compare(label.getBounds().getY(), comparedLabel.getBounds().getY());
    }
}

