/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.Shape;
import net.astah.notation.editor.IComposableTransformer;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.ShapeTransformer;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.notation.editor.ProcessModelElements;
import net.astah.stpa.stamp.notation.editor.STAMPLabelViewElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;

public class STAMPLabelTransformer
extends ShapeTransformer
implements IComposableTransformer {
    public STAMPLabelTransformer(@NonNull IShapeViewElement target, @NonNull Pnt2d startLocation) {
        super(target, startLocation);
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (startLocation == null) {
            throw new NullPointerException("startLocation");
        }
    }

    public STAMPLabelTransformer(@NonNull IShapeViewElement target, @NonNull Pnt2d startLocation, int knob) {
        super(target, startLocation, knob);
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (startLocation == null) {
            throw new NullPointerException("startLocation");
        }
    }

    protected boolean isRestrictedBySize(Shape shape, Bounds bounds) {
        return true;
    }

    public GNode createFeedbackNode(@NonNull LayoutCalculator layoutCalculator) {
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        return ProcessModelElements.isProcessModelElement((DiagramElement)((IShapeViewElement)this.getTarget()).getModel()) ? new GNode() : super.createFeedbackNode(layoutCalculator);
    }

    public void move(@NonNull Pnt2d endLocation, @NonNull LayoutCalculator layoutCalculator, GNode hoveredNode, @NonNull Set<?> constraints) {
        if (endLocation == null) {
            throw new NullPointerException("endLocation");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints");
        }
        List<EObject> models = this.targets.stream().map(v -> DiagramElements.getModelElement((DiagramElement)((DiagramElement)v.getModel()))).collect(Collectors.toList());
        if (models.stream().anyMatch(m -> m instanceof ProcessVariable || m instanceof ProcessValue)) {
            this.command = this.move(models, endLocation, hoveredNode, layoutCalculator);
        } else {
            super.move(endLocation, layoutCalculator, hoveredNode, constraints);
        }
    }

    protected Command move(Shape shape, Pnt2d endLocation, GNode hoveredNode, LayoutCalculator layoutCalculator) {
        EObject selectedModel = DiagramElements.getModelElement((DiagramElement)shape);
        if (selectedModel instanceof ProcessVariable || selectedModel instanceof ProcessValue) {
            Shape destinationLabel = ((STAMPLabelViewElement)this.getTarget()).getDestinationLabelToReorder(endLocation);
            return destinationLabel != null ? ProcessModelElements.createCommandToReorder(Collections.singletonList(selectedModel), destinationLabel, endLocation.y) : UnexecutableCommand.INSTANCE;
        }
        return super.move(shape, endLocation, hoveredNode, layoutCalculator);
    }

    private Command move(List<EObject> models, Pnt2d endLocation, GNode hoveredNode, LayoutCalculator layoutCalculator) {
        Shape destinationLabel = ((STAMPLabelViewElement)this.getTarget()).getDestinationLabelToReorder(endLocation);
        return destinationLabel != null ? ProcessModelElements.createCommandToReorder(models, destinationLabel, endLocation.y) : UnexecutableCommand.INSTANCE;
    }

    public ITransformer merge(ITransformer other) {
        if (!(other instanceof STAMPLabelTransformer)) {
            return null;
        }
        EObject model = DiagramElements.getModelElement((DiagramElement)((DiagramElement)((IShapeViewElement)this.getTarget()).getModel()));
        if (!(model instanceof ProcessVariable) && !(model instanceof ProcessValue)) {
            return null;
        }
        other.getTargets().stream().filter(t -> !this.targets.contains(t)).map(it -> (IShapeViewElement)it).forEach(v -> this.targets.add(v));
        Collections.sort(this.targets);
        return this;
    }
}

