/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRect;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionChangedListener;
import net.astah.golf.widget.SelectionChangedEvent;
import net.astah.golf.widget.swing.Selections;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jview.Highlighter;
import net.astah.jomt.jview.IconResource;
import net.astah.notation.editor.DiagramViewElementImpl;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.AlignmentGuide;
import net.astah.notation.editor.adjuster.ComposableAdjuster;
import net.astah.notation.editor.adjuster.EvenGuide;
import net.astah.notation.editor.adjuster.EvenSizeGuide;
import net.astah.notation.editor.adjuster.FixedAspectRatioAdjuster;
import net.astah.notation.editor.adjuster.LinearAdjuster;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.notation.editor.adjuster.MovingCompoundAdjuster;
import net.astah.notation.editor.adjuster.OnGridAdjuster;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.notation.editor.adjuster.ResizingCompoundAdjuster;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.editor.STAMPDiagramDrawSuggest;
import org.eclipse.emf.common.notify.Notifier;

public abstract class STAMPDiagramViewElement
extends DiagramViewElementImpl<STAMPDiagram, STAMPDiagramElement>
implements ISelectionChangedListener {
    private GRect dgmFrame = null;
    private boolean isCurrent;
    private boolean isFocus;
    private STAMPDiagramDrawSuggest drawSuggest;
    private Collection<Highlighter> currentHighlighters = new HashSet<Highlighter>();
    private static final MovingAdjuster.Factory DEFAULT_MOVING_ADJUSTER = STAMPDiagramViewElement.getDefaultMovingAdjusterFactory();
    private static final ResizingAdjuster.Factory DEFAULT_RESIZING_ADJUSTER = STAMPDiagramViewElement.getDefaultResizingAdjusterFactory();

    public STAMPDiagramViewElement(STAMPDiagram object) {
        super((Diagram)object);
        this.updateDgmFrame();
        this.initDrawSuggest();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance((Object)this.drawSuggest)) {
            return adapter.cast((Object)this.drawSuggest);
        }
        if (adapter.isInstance(DEFAULT_MOVING_ADJUSTER)) {
            return adapter.cast(DEFAULT_MOVING_ADJUSTER);
        }
        if (adapter.isInstance(DEFAULT_RESIZING_ADJUSTER)) {
            return adapter.cast(DEFAULT_RESIZING_ADJUSTER);
        }
        return (T)super.getAdapter(adapter);
    }

    private void initDrawSuggest() {
        this.drawSuggest = new STAMPDiagramDrawSuggest((IViewElement)this);
        SwingImageIcon image = new SwingImageIcon((ImageIcon)IconResource.getNormalSizeAssocIcon());
        this.drawSuggest.addCommandAction("net.astah.jomt.jcontrol.CreateShape", 2, (CImageIcon)image);
    }

    private void updateDgmFrame() {
        this.dgmFrame = new GRect(this.dgmRect);
        this.dgmFrame.setColorNo((byte)6);
        this.dgmFrame.setFilled(false);
        this.dgmFrame.setDepth(Integer.MAX_VALUE);
        this.dgmFrame.setSelectable(false);
        if (RuntimeGlobal.sysProp != null) {
            boolean isDgmFrameVisibility = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.diagram_frame_visibility");
            this.dgmFrame.setVisible(isDgmFrameVisibility);
        }
    }

    protected Bounds getTotalBounds(List<DiagramElement> elements) {
        return new LayoutCalculator().getTotalBounds(elements, true);
    }

    private static MovingAdjuster.Factory getDefaultMovingAdjusterFactory() {
        return new MovingAdjuster.Factory(){

            public MovingAdjuster createAdjuster() {
                return (MovingAdjuster)((MovingCompoundAdjuster)((MovingCompoundAdjuster)((MovingCompoundAdjuster)new MovingCompoundAdjuster().add((ComposableAdjuster)new LinearAdjuster())).add((ComposableAdjuster)new OnGridAdjuster())).add((ComposableAdjuster)new AlignmentGuide())).add((ComposableAdjuster)new EvenGuide());
            }
        };
    }

    private static ResizingAdjuster.Factory getDefaultResizingAdjusterFactory() {
        return new ResizingAdjuster.Factory(){

            public ResizingAdjuster createAdjuster() {
                return (ResizingAdjuster)((ResizingCompoundAdjuster)new ResizingCompoundAdjuster().add((ComposableAdjuster)new FixedAspectRatioAdjuster())).add((ComposableAdjuster)new EvenSizeGuide());
            }
        };
    }

    public void update(Notifier notifier, Object object) {
    }

    public boolean isDiagramFrameReady() {
        return this.dgmFrame != null;
    }

    public double getX() {
        return this.dgmFrame.getX();
    }

    public double getY() {
        return this.dgmFrame.getY();
    }

    public double getWidth() {
        return this.dgmFrame.getWidth();
    }

    public double getHeight() {
        return this.dgmFrame.getHeight();
    }

    public boolean isCurrent() {
        return this.isCurrent;
    }

    public void setCurrent(boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    public boolean isFocus() {
        return this.isFocus;
    }

    public void setFocus(boolean isFocus) {
        this.isFocus = isFocus;
    }

    public GNode getBodyNode() {
        return this.dgmFrame;
    }

    protected List<? extends STAMPDiagramElement> getOwnedElements() {
        STAMPDiagram model = (STAMPDiagram)this.getModel();
        if (model != null) {
            return model.getSTAMPOwnedElements();
        }
        return Collections.emptyList();
    }

    public void setCreateEditState(boolean isEditState) {
    }

    public boolean getCreateEditState() {
        return false;
    }

    public void layout(LayoutCalculator layoutCalculator) {
        super.layout(layoutCalculator);
        this.updateDgmFrame();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Collection<Highlighter> highlighters = this.getHighlighters(event.getSelection());
        this.currentHighlighters.forEach(h -> {
            if (!highlighters.contains(h)) {
                h.setHighlighted(false);
            }
        });
        highlighters.forEach(h -> {
            if (!this.currentHighlighters.contains(h)) {
                h.setHighlighted(true);
            }
        });
        this.currentHighlighters.clear();
        this.currentHighlighters.addAll(highlighters);
    }

    private Collection<Highlighter> getHighlighters(ISelection selection) {
        if (Selections.size((ISelection)selection) != 1) {
            return Collections.emptyList();
        }
        Object target = Selections.getFirstElement((ISelection)selection);
        if (target instanceof IViewElement) {
            Highlighter highlighter = (Highlighter)((IViewElement)target).getAdapter(Highlighter.class);
            if (highlighter != null) {
                return highlighter.getHighlightTogether();
            }
        } else if (target instanceof Element && this.isHighlightModel((Element)target)) {
            for (GNode child : this.getAllNodes()) {
                IViewElement ve;
                Highlighter highlighter;
                DiagramElement diagramElement;
                if (!(child.getModel() instanceof DiagramElement) || !(diagramElement = (DiagramElement)child.getModel()).getModelElements().contains(target) || (highlighter = (Highlighter)(ve = (IViewElement)ViewElements.getAncestor((GNode)child, IViewElement.class)).getAdapter(Highlighter.class)) == null) continue;
                return Arrays.asList(highlighter);
            }
        }
        return Collections.emptyList();
    }

    protected boolean isHighlightModel(Element target) {
        return true;
    }
}

