/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import com.google.common.collect.Iterables;
import javax.swing.ImageIcon;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRoundRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.RectangleDrawSuggest;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IMovableViewElement;
import net.astah.notation.editor.IResizableViewElement;
import net.astah.notation.editor.ITransformer;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.ResizingAdjuster;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.editor.STAMPComponentBaseViewElement;
import net.astah.stpa.stamp.notation.editor.STAMPComponentDrawSuggest;
import net.astah.stpa.stamp.notation.editor.STAMPComponentHighlighter;
import net.astah.stpa.stamp.notation.editor.STAMPComponentTransformer;
import net.astah.stpa.stamp.notation.editor.STAMPLabelViewElement;
import net.astah.stpa.stamp.provider.STAMPEditPlugin;

public class STAMPComponentViewElement
extends STAMPComponentBaseViewElement
implements IMovableViewElement,
IResizableViewElement {
    private RectangleDrawSuggest drawSuggest;
    private STAMPComponentHighlighter highlighter;
    private ResizingAdjuster.Factory resizingAdjusterFactory;
    private static final byte FRAME_COLOR = 2;
    private static final byte BODY_COLOR = -1;
    private static final byte KNOB_COLOR = 2;
    private static final byte SHADOW_COLOR = 7;
    private static final double HIGHLIGHT_MARGIN = 5.0;

    public STAMPComponentViewElement(STAMPComponentShape model) {
        super(model);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.drawSuggest)) {
            return adapter.cast(this.drawSuggest);
        }
        if (adapter.isInstance(this.resizingAdjusterFactory)) {
            return adapter.cast(this.resizingAdjusterFactory);
        }
        if (adapter.isInstance((Object)this.highlighter)) {
            return adapter.cast((Object)this.highlighter);
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void init() {
        super.init();
        this.initHighlighter();
    }

    private void initHighlighter() {
        this.highlighter = new STAMPComponentHighlighter(this);
    }

    @Override
    protected void initDrawSuggest() {
        super.initDrawSuggest();
        this.drawSuggest = new STAMPComponentDrawSuggest((IViewElement)this);
        String key = "diagramview.button.drop_down_component";
        SwingImageIcon image = new SwingImageIcon((ImageIcon)SwingIconRegistry.INSTANCE.getIcon(STAMPEditPlugin.getPlugin().getImage("full/obj16/Link")));
        this.drawSuggest.addModeAction("net.astah.stpa.stamp.ui.control.mode.CreateControlLink", (CImageIcon)image, key);
        ResourceBundleList resource = PropertyManager.getJudeResourceBundle();
        if (resource != null && Boolean.valueOf(resource.getString("stpa.compartment_suggest")).booleanValue()) {
            SwingImageIcon compartmentImage = new SwingImageIcon((ImageIcon)SwingIconRegistry.INSTANCE.getIcon(STAMPEditPlugin.getPlugin().getImage("full/suggest16/Compartment")));
            GIconButton insideDrawButton = new GIconButton((CImageIcon)compartmentImage, "net.astah.ui.control.CreateCompartment", 1);
            this.drawSuggest.addButton(insideDrawButton);
        }
    }

    @Override
    protected void initAdjusterFactory() {
        super.initAdjusterFactory();
        this.resizingAdjusterFactory = (ResizingAdjuster.Factory)((IDiagramViewElement)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class)).getAdapter(ResizingAdjuster.Factory.class);
    }

    @Override
    protected void updateColor() {
        GraphicalStyles.applyFillColor((GGeometry)this.bodyRect, (Object)this.getModel(), (byte)-1);
        GraphicalStyles.applyStrokeColor((GGeometry)this.bodyRect, (Object)this.getModel(), (byte)2);
        this.bodyRect.setKnobColorNo((byte)2);
        this.bodyRect.setShadowColorNo((byte)7);
    }

    protected IViewElement getEditingTextViewElement() {
        return (IViewElement)Iterables.getFirst((Iterable)this.viewElements(STAMPLabelViewElement.class), null);
    }

    public ITransformer startMove(Pnt2d startLocation) {
        return new STAMPComponentTransformer(this, startLocation);
    }

    public ITransformer startResize(Pnt2d startLocation, int knob) {
        return new STAMPComponentTransformer(this, startLocation, knob);
    }

    protected GNode createHighlightShape() {
        GRoundRect highlightShape = this.createHighlightRect();
        highlightShape.setAlpha(0.5f);
        highlightShape.setFilled(true);
        highlightShape.setRimWidth(10);
        highlightShape.setForegroundColor(GraphicalStyles.getHighlightColor((Object)this.getModel(), (Object)IItemGraphicalStyleProvider.Feature.FILL_COLOR));
        this.highlight = highlightShape;
        return highlightShape;
    }

    private GRoundRect createHighlightRect() {
        double x = this.bodyRect.getX() - 5.0;
        double y = this.bodyRect.getY() - 5.0;
        double width = this.bodyRect.getWidth() + 10.0;
        double height = this.bodyRect.getHeight() + 10.0;
        return new GRoundRect(x, y, width, height);
    }

    protected void layoutHighlightShape() {
        super.layoutHighlightShape();
        if (this.highlight != null) {
            GRoundRect rect = this.createHighlightRect();
            ((GRoundRect)this.highlight).setRoundRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
    }
}

