/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.notation.editor.EdgeViewElementImpl;
import net.astah.notation.editor.IShapeViewElement;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ShapeTransformer;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.editor.STAMPComponentViewElement;

public class STAMPComponentTransformer
extends ShapeTransformer {
    protected IViewElement newParent;

    public STAMPComponentTransformer(@NonNull STAMPComponentViewElement target, @NonNull Pnt2d startLocation) {
        super((IShapeViewElement)target, startLocation);
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (startLocation == null) {
            throw new NullPointerException("startLocation");
        }
        this.newParent = null;
    }

    public STAMPComponentTransformer(@NonNull STAMPComponentViewElement target, @NonNull Pnt2d startLocation, int knob) {
        super((IShapeViewElement)target, startLocation, knob);
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (startLocation == null) {
            throw new NullPointerException("startLocation");
        }
        this.newParent = null;
    }

    public void dispose() {
        super.dispose();
        this.newParent = null;
    }

    public GNode createFeedbackNode(LayoutCalculator layoutCalculator) {
        GNode node;
        this.createAffectingTransformers();
        GNode feedbackNode = super.createFeedbackNode(layoutCalculator);
        if (feedbackNode != null && this.newParent instanceof STAMPComponentViewElement && (node = this.newParent.createFeedbackShape()) != null) {
            node.setDepth(-1);
            ((GRimmedGeometry)node).setRimWidth(2);
            feedbackNode.addChild(node);
        }
        return feedbackNode;
    }

    public void move(@NonNull Pnt2d endLocation, @NonNull LayoutCalculator layoutCalculator, GNode hoverdNode, @NonNull Set<?> constraints) {
        if (endLocation == null) {
            throw new NullPointerException("endLocation");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints");
        }
        this.newParent = null;
        super.move(endLocation, layoutCalculator, hoverdNode, constraints);
    }

    public STAMPComponentViewElement getTarget() {
        return (STAMPComponentViewElement)super.getTarget();
    }

    protected Iterable<IViewElement> getAffectingViewElements() {
        Iterable affectings = super.getAffectingViewElements();
        if (this.newParent != null && this.getTarget().getParent() != this.newParent && this.newParent instanceof STAMPComponentViewElement && ViewElements.isAncestor((GNode)((GNode)this.newParent), (GNode)this.getTarget())) {
            return Iterables.concat((Iterable)affectings, Collections.singleton(this.newParent), (Iterable)this.newParent.getAffectingViewElements());
        }
        return affectings;
    }

    protected boolean isAffectingElement(IViewElement viewElement) {
        if (this.newParent != null && this.getTarget().getParent() != this.newParent) {
            if (this.newParent instanceof STAMPComponentViewElement) {
                return viewElement != this.getTarget().getParent();
            }
            return viewElement instanceof EdgeViewElementImpl;
        }
        return super.isAffectingElement(viewElement);
    }

    protected DiagramElement getLocationElement(GNode hoveredNode) {
        if (!this.isMoveTransform()) {
            return ((STAMPComponentShape)this.getTarget().getModel()).getOwningElement();
        }
        if (hoveredNode == null) {
            this.newParent = this.getDiagramViewElement();
            return (DiagramElement)this.newParent.getModel();
        }
        STAMPComponentViewElement viewElement = (STAMPComponentViewElement)((Object)ViewElements.getAncestor((GNode)hoveredNode, STAMPComponentViewElement.class));
        if (viewElement == null || viewElement.getModel() == null) {
            this.newParent = this.getDiagramViewElement();
            return (DiagramElement)this.newParent.getModel();
        }
        this.newParent = viewElement;
        return (DiagramElement)viewElement.getModel();
    }
}

