/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.Collections;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.SetLocationCommand;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.draw.GIconButton;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jview.DiagramEditors;
import net.astah.jomt.jview.RectangleDrawSuggest;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPShape;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class STAMPComponentDrawSuggest
extends RectangleDrawSuggest {
    private CCanvas currentCanvas;
    private STAMPShape shape;

    public STAMPComponentDrawSuggest(IViewElement owner) {
        super(owner);
    }

    public boolean doDoubleClick(CCanvas canvas, Pnt2d pnt, int id) {
        this.currentCanvas = canvas;
        DiagramElement container = (DiagramElement)this.getOwner().getModel();
        DiagramElement parent = container == null ? (DiagramElement)this.getOwner().getModel() : container;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)parent);
        Point mousePoint = DCFactory.eINSTANCE.createPoint(pnt.getX(), pnt.getY());
        this.shape = this.prepareShape();
        CompoundCommand command = new CompoundCommand();
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)parent, (Object)new CommandParameter((Object)parent, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, (Object)this.shape, 0), Collections.singleton(parent)));
        command.append(SetLocationCommand.create((EditingDomain)domain, (Object)new DiagramContext((Diagram)EObjects.getAncestor(Diagram.class, (EObject)parent), null, pnt, parent), (Object)this.shape, (Object)mousePoint));
        CommandJob job = new CommandJob(domain, (Command)command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        job.schedule();
        return true;
    }

    private STAMPShape prepareShape() {
        STAMPComponentShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPComponentShape();
        DiagramElements.setModelElement((DiagramElement)shape, (EObject)STAMPFactory.eINSTANCE.createComponent());
        return shape;
    }

    protected Pnt2d getButtonPoint(GNode node, GIconButton button, Pnt2d mousePnt) {
        if (button.getAction() != null && button.getAction().getActionName().endsWith("CreateCompartment")) {
            GRect rect = (GRect)node;
            double buttonWidth = button.getWidth();
            double buttonHeight = button.getHeight();
            double x = rect.getX() + rect.getWidth() - buttonWidth;
            double y = rect.getY() + buttonHeight / 2.0;
            return new Pnt2d(x, y);
        }
        return super.getButtonPoint(node, button, mousePnt);
    }

    protected boolean isTargetBody(GNode node) {
        return super.isTargetBody(node) && node.getModel() instanceof STAMPCompartmentableShape;
    }

    protected void postExecute() {
        DiagramEditors.selectOnCurrentEditor((DiagramElement)this.shape);
        ViewElements.startEditing((CCanvas)this.currentCanvas, (Notifier)this.shape);
    }
}

