/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import com.google.common.collect.Iterables;
import net.astah.dd.dc.Bounds;
import net.astah.golf.draw.GGeometry;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GNodeSelectionListener;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.jomt.jview.HyperLinkIcon;
import net.astah.jomt.jview.HyperLinkIconImpl;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.editor.IDiagramViewElement;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.editor.STAMPShapeViewElementImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public abstract class STAMPComponentBaseViewElement
extends STAMPShapeViewElementImpl<STAMPComponentShape> {
    protected GRect bodyRect;
    protected HyperLinkIcon hyperLinkIcon;
    protected MovingAdjuster.Factory movingAdjusterFactory;

    public STAMPComponentBaseViewElement(STAMPComponentShape model) {
        super(model);
    }

    public void refresh() {
        super.refresh();
        this.init();
        this.updateRimmedPick();
    }

    protected void init() {
        this.initBodyRect();
        this.initDrawSuggest();
        this.initHyperLinkIcon();
        this.initAdjusterFactory();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.hyperLinkIcon)) {
            return adapter.cast(this.hyperLinkIcon);
        }
        if (adapter.isInstance(this.movingAdjusterFactory)) {
            return adapter.cast(this.movingAdjusterFactory);
        }
        return (T)super.getAdapter(adapter);
    }

    protected void initBodyRect() {
        if (this.bodyRect == null) {
            int type = 0;
            type |= 4;
            this.bodyRect = new GRect();
            this.bodyRect.setUseIgnoreRimmedPick(true);
            this.bodyRect.setType(type |= 1);
            this.bodyRect.setFilled(true);
            this.bodyRect.setModel((Object)this.getModel());
            this.bodyRect.addNodeSelectionListener((GNodeSelectionListener)this.bodyRect);
            this.bodyRect.setSelectionType((byte)3);
            this.addNodeSelectionListener((GNodeSelectionListener)this.bodyRect);
            this.addNode((GNode)this.bodyRect);
        }
    }

    protected void initDrawSuggest() {
    }

    protected void initHyperLinkIcon() {
        if (this.hyperLinkIcon != null) {
            return;
        }
        this.hyperLinkIcon = new HyperLinkIconImpl((IViewElement)this, (EObject)this.getModel());
        this.hyperLinkIcon.addIconNode();
    }

    protected void initAdjusterFactory() {
        this.movingAdjusterFactory = (MovingAdjuster.Factory)((IDiagramViewElement)ViewElements.getAncestor((GNode)this, IDiagramViewElement.class)).getAdapter(MovingAdjuster.Factory.class);
    }

    public void update() {
        super.update();
        this.updateBodyRect();
        this.updateHyperLinkIcon();
    }

    protected void updateBodyRect() {
        this.bodyRect.setVisible(true);
        this.bodyRect.setPickable(true);
        this.bodyRect.setSelectable(true);
    }

    protected void updateRimmedPick() {
        this.bodyRect.setRimmedPick(Iterables.any(this.getOwnedElements(), arg_0 -> ((EClass)((STAMPComponentShape)this.getModel()).eClass()).isInstance(arg_0)));
    }

    protected void updateStroke() {
        GraphicalStyles.applyStrokeWidth((GRimmedGeometry)this.bodyRect, (Object)this.getModel(), (int)2);
    }

    protected abstract void updateColor();

    protected void updateHyperLinkIcon() {
        this.hyperLinkIcon.update();
    }

    protected void layoutHyperLinkIcon() {
        this.hyperLinkIcon.relocate((GNode)this.bodyRect);
    }

    protected void layout(Bounds bounds) {
        this.layoutBodyRect(bounds);
        this.layoutHyperLinkIcon();
    }

    protected void layoutBodyRect(Bounds bounds) {
        this.bodyRect.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    protected GGeometry getBounds(Rectangle2d bounds) {
        return super.getBounds(this.bodyRect, bounds);
    }

    public void setSelected() {
        this.bodyRect.setSelected(true);
    }
}

