/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.jomt.jview.RectangleDrawSuggest;
import net.astah.notation.editor.ViewElementImpl;
import net.astah.notation.editor.adjuster.MovingAdjuster;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.editor.adjuster.ProcessModelElementReorderingGuide;
import org.eclipse.emf.common.notify.Notifier;

public class STAMPCompartmentViewElement
extends ViewElementImpl<STAMPCompartment, STAMPDiagramElement> {
    private GPolyline line;
    private GRect bodyRect;
    private RectangleDrawSuggest drawSuggest;
    private final byte BODY_COLOR = (byte)2;
    private static final MovingAdjuster.Factory DEFAULT_MOVING_ADJUSTER = new MovingAdjuster.Factory(){

        public MovingAdjuster createAdjuster() {
            return new ProcessModelElementReorderingGuide();
        }
    };

    public STAMPCompartmentViewElement(STAMPCompartment object) {
        super((Notifier)object);
    }

    public void refresh(Notifier notifier, Object object) {
        super.refresh(notifier, object);
        this.init();
    }

    protected void init() {
        this.initBodyRect();
        this.initLine();
    }

    protected void initBodyRect() {
        if (this.bodyRect == null) {
            int type = 0;
            type |= 4;
            this.bodyRect = new GRect();
            this.bodyRect.setType(type |= 1);
            this.bodyRect.setAlpha(0.0f);
            this.bodyRect.setColorNo((byte)2);
            this.bodyRect.setSelectable(false);
            this.bodyRect.setPickable(false);
            this.bodyRect.setFilled(false);
            this.bodyRect.setModel((Object)this.getModel());
            this.bodyRect.setRimWidth(2);
            this.addNode((GNode)this.bodyRect);
        }
    }

    private void initLine() {
        if (this.line == null) {
            this.line = new GPolyline();
            this.line.setColorNo((byte)2);
            Pnt2d[] pnts = new Pnt2d[]{new Pnt2d(), new Pnt2d()};
            this.line.setPoints(pnts);
            this.addNode((GNode)this.line);
        }
    }

    public void layout(LayoutCalculator layoutCalculator) {
        STAMPCompartment model = (STAMPCompartment)this.getModel();
        if (model != null) {
            Bounds newBounds = this.getBounds(model, layoutCalculator);
            this.setAffectingViewElementNeedsLayout();
            this.layout(newBounds);
        }
        super.layout(layoutCalculator);
    }

    private Bounds getBounds(STAMPCompartment model, LayoutCalculator layoutCalculator) {
        return layoutCalculator.getBounds((Object)model);
    }

    protected void layout(Bounds bounds) {
        this.layoutBodyRect(bounds);
        this.layoutLine(bounds);
    }

    private void layoutBodyRect(Bounds bounds) {
        this.bodyRect.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private void layoutLine(Bounds bounds) {
        Pnt2d[] linePnts = this.line.getPoints();
        linePnts[0].set(bounds.getX(), bounds.getY());
        linePnts[1].set(bounds.getX() + bounds.getWidth(), bounds.getY());
        this.line.setPoints(linePnts);
    }

    protected List<? extends STAMPDiagramElement> getOwnedElements() {
        return ((STAMPCompartment)this.getModel()).getSTAMPOwnedElements();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.drawSuggest)) {
            return adapter.cast(this.drawSuggest);
        }
        if (adapter.isInstance(DEFAULT_MOVING_ADJUSTER)) {
            return adapter.cast(DEFAULT_MOVING_ADJUSTER);
        }
        return (T)super.getAdapter(adapter);
    }

    public void update(Notifier notifier, Object object) {
    }
}

