/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.notation.editor;

import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.notation.Shape;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ProcessModelElements {
    public static Command createCommandToReorder(List<EObject> selectedModels, Shape destinationLabel, double y) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)selectedModels.get(0));
        EObject destinationModel = DiagramElements.getModelElement((DiagramElement)destinationLabel);
        float location = ProcessModelElements.getLocation(destinationLabel, y);
        return DragAndDropCommand.create((EditingDomain)domain, (Object)destinationModel, (float)location, (int)2, (int)2, selectedModels);
    }

    public static float getLocation(Shape destinationLabel, double y) {
        return (float)((y - destinationLabel.getBounds().getY()) / destinationLabel.getBounds().getHeight());
    }

    static boolean isProcessModelElement(DiagramElement diagramElement) {
        EObject model = DiagramElements.getModelElement((DiagramElement)diagramElement);
        return model instanceof ProcessVariable || model instanceof ProcessValue;
    }
}

