/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.ui.swing;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import lombok.NonNull;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.provider.swing.EditingDomainTableTransferHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTableTableTransferHandler
extends EditingDomainTableTransferHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger a = LoggerFactory.getLogger(GenericTableTableTransferHandler.class);
    protected final TransactionalEditingDomain txDomain;

    public GenericTableTableTransferHandler(@NonNull TransactionalEditingDomain transactionalEditingDomain, @NonNull EditingDomain editingDomain) {
        super(editingDomain);
        if (transactionalEditingDomain == null) {
            throw new NullPointerException("txDomain");
        }
        if (editingDomain == null) {
            throw new NullPointerException("domain");
        }
        this.txDomain = transactionalEditingDomain;
    }

    protected Collection<?> createTransferData(JComponent jComponent) {
        return this.invoke(() -> this.doCreateTransferData(jComponent), Collections.emptyList(), "create transfer data", new Object[0]);
    }

    protected Command createCommand(TransferHandler.TransferSupport transferSupport) {
        return this.invoke(() -> this.doCreateCommand(transferSupport), null, "create command", new Object[0]);
    }

    protected Collection<?> doCreateTransferData(JComponent jComponent) {
        return super.createTransferData(jComponent);
    }

    protected Command doCreateCommand(TransferHandler.TransferSupport transferSupport) {
        return super.createCommand(transferSupport);
    }

    protected void executeCommand(Command command) {
        new CommandJob(this.txDomain, command).schedule();
    }

    <V> V invoke(Callable<V> callable, V v, String string, Object ... objectArray) {
        try {
            return (V)Transactions.runExclusive((TransactionalEditingDomain)this.txDomain, callable);
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", (Throwable)interruptedException);
            return v;
        }
        catch (CancellationException cancellationException) {
            a.debug("Cancelled: " + MessageFormat.format(string, objectArray), (Throwable)cancellationException);
            return v;
        }
        catch (ExecutionException executionException) {
            a.warn("Failed: " + MessageFormat.format(string, objectArray), executionException.getCause());
            return v;
        }
    }
}

