/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.ui.swing;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.astah.emf.edit.provider.swing.PropertyDescriptor;
import net.astah.golf.view.swing.IPropertyDescriptor;
import net.astah.golf.view.swing.IPropertySource;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.PropertySourceCellRenderer;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.IInputProvider;
import net.astah.golf.widget.swing.TableHeaderCellRendererAdapter;
import net.astah.table.CellDescriptor;
import net.astah.table.Dataset;
import net.astah.table.Grid;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.engine.IEngineDataset;
import net.astah.table.engine.impl.CellDescriptorEngineAdapter;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class GenericTableColumnProvider
extends TableColumnProvider {
    protected AdapterFactory adapterFactory;
    protected Grid grid;

    public GenericTableColumnProvider() {
        this(null);
    }

    public GenericTableColumnProvider(AdapterFactory adapterFactory) {
        super(Collections.emptyList());
        this.setAdapterFactory(adapterFactory);
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.updateColumns();
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setGrid(Grid grid) {
        this.grid = grid;
        this.updateColumns();
    }

    protected void updateColumns() {
        this.columnDescriptors.clear();
        if (this.grid != null && this.adapterFactory != null) {
            int n = 0;
            for (Tuple tuple : this.grid.getColumnTuples()) {
                String string = String.valueOf(n++);
                Comparator<?> comparator = this.getComparator(tuple);
                TuplePropertyColumnDescriptor tuplePropertyColumnDescriptor = new TuplePropertyColumnDescriptor(string, tuple);
                if (comparator != null) {
                    tuplePropertyColumnDescriptor.setSortOrder(SortOrder.UNSORTED);
                    tuplePropertyColumnDescriptor.setComparator(comparator);
                }
                this.columnDescriptors.add(tuplePropertyColumnDescriptor);
            }
        }
    }

    protected TableCellRenderer createHeaderRenderer(TuplePropertyColumnDescriptor tuplePropertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
        Tuple tuple = tuplePropertyColumnDescriptor.getTuple();
        for (final CellDescriptor cellDescriptor : DatasetEngineAdapter.getHeaderDescriptors((AdapterFactory)this.adapterFactory, (Object)tuple.getDataset(), (Tuple)tuple)) {
            final IItemPropertyDescriptor iItemPropertyDescriptor = CellDescriptorEngineAdapter.getHeaderPropertyDescriptor((AdapterFactory)this.adapterFactory, (Object)cellDescriptor, (Tuple)tuple);
            if (iItemPropertyDescriptor == null) continue;
            PropertySourceCellRenderer propertySourceCellRenderer = new PropertySourceCellRenderer(iPropertySourceProvider){
                private static final long serialVersionUID = 1L;

                protected Object getRowValue(JTable jTable, int n) {
                    return cellDescriptor;
                }

                protected IPropertyDescriptor getPropertyDescriptor(Object object) {
                    return new PropertyDescriptor(object, iItemPropertyDescriptor);
                }

                protected IPropertySource getPropertySource(Object object) {
                    return super.getPropertySource(iItemPropertyDescriptor.getPropertyValue((Object)cellDescriptor));
                }

                protected void setValue(Object object) {
                    String string = Objects.toString(object, "");
                    if (this.isLineWrap()) {
                        this.label.setText(string, false);
                    } else {
                        this.setText(string);
                    }
                }
            };
            propertySourceCellRenderer.setLineWrap(cellDescriptor.isLineWrap());
            propertySourceCellRenderer.setShowImage(false);
            return new TableHeaderCellRendererAdapter((DefaultTableCellRenderer)propertySourceCellRenderer);
        }
        return null;
    }

    protected TableCellRenderer createCellRenderer(TuplePropertyColumnDescriptor tuplePropertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
        return new TableColumnProvider.ColumnCellRenderer((TableColumnProvider.PropertyColumnDescriptor)tuplePropertyColumnDescriptor, iPropertySourceProvider);
    }

    protected TableCellEditor createCellEditor(TuplePropertyColumnDescriptor tuplePropertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
        return new TupleColumnCellEditor((TableColumnProvider.PropertyColumnDescriptor)tuplePropertyColumnDescriptor, iPropertySourceProvider);
    }

    protected Comparator<?> getComparator(Tuple tuple) {
        assert (tuple.eContainmentFeature() == TablePackage.Literals.GRID__COLUMN_TUPLE);
        Dataset dataset = tuple.getDataset();
        Adapter adapter = this.adapterFactory.adapt((Notifier)dataset, IEngineDataset.class);
        if (adapter instanceof IEngineDataset) {
            return ((IEngineDataset)adapter).getCellComparator((Object)dataset, tuple);
        }
        return null;
    }

    public class TupleColumnCellEditor
    extends TableColumnProvider.ColumnCellEditor {
        private static final long serialVersionUID = 6384615163517250195L;

        public TupleColumnCellEditor(TableColumnProvider.PropertyColumnDescriptor propertyColumnDescriptor, IPropertySourceProvider iPropertySourceProvider) {
            super(propertyColumnDescriptor, iPropertySourceProvider);
        }

        protected boolean isEditable(JTable jTable, int n, int n2) {
            if (jTable.getValueAt(n, n2) == null) {
                return false;
            }
            return super.isEditable(jTable, n, n2);
        }
    }

    public class TuplePropertyColumnDescriptor
    extends TableColumnProvider.IdPropertyColumnDescriptor {
        protected Tuple tuple;

        protected TuplePropertyColumnDescriptor(Object object, Tuple tuple) {
            super(object);
            this.tuple = tuple;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public boolean isLineWrap(Object object, int n) {
            Dataset dataset;
            Iterator iterator;
            if (super.isLineWrap(object, n)) {
                return true;
            }
            if (object instanceof Tuple && (iterator = DatasetEngineAdapter.getCellDescriptors((AdapterFactory)GenericTableColumnProvider.this.adapterFactory, (Object)(dataset = this.tuple.getDataset()), (Tuple)((Tuple)object), (Tuple)this.tuple).iterator()).hasNext()) {
                CellDescriptor cellDescriptor = (CellDescriptor)iterator.next();
                return cellDescriptor.isLineWrap();
            }
            return false;
        }

        public Object getHeaderValue(IInputProvider iInputProvider) {
            return this.tuple;
        }

        protected TableCellRenderer createHeaderRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return GenericTableColumnProvider.this.createHeaderRenderer(this, iPropertySourceProvider);
        }

        protected TableCellRenderer createCellRenderer(IPropertySourceProvider iPropertySourceProvider) {
            return GenericTableColumnProvider.this.createCellRenderer(this, iPropertySourceProvider);
        }

        protected TableCellEditor createCellEditor(IPropertySourceProvider iPropertySourceProvider) {
            TableCellEditor tableCellEditor = GenericTableColumnProvider.this.createCellEditor(this, iPropertySourceProvider);
            if (tableCellEditor instanceof TableColumnProvider.ColumnCellEditor) {
                ((TableColumnProvider.ColumnCellEditor)tableCellEditor).setClickCountToStart(2);
            }
            return tableCellEditor;
        }
    }
}

