/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.ui.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.table.ui.swing.TableCellDialogPanel;

public class DialogCellEditor
implements TableCellEditor {
    protected final ITableColumnProvider.IColumnDescriptor columnDescriptor;
    protected final IPropertySourceProvider propertySourceProvider;
    private final TableCellDialogPanel a;
    protected final String title;
    private final List<CellEditorListener> b;
    protected int clickCountToStart = 2;

    public DialogCellEditor(ITableColumnProvider.IColumnDescriptor iColumnDescriptor, IPropertySourceProvider iPropertySourceProvider, TableCellDialogPanel tableCellDialogPanel, String string) {
        this.columnDescriptor = iColumnDescriptor;
        this.propertySourceProvider = iPropertySourceProvider;
        this.a = tableCellDialogPanel;
        this.title = string;
        this.b = new ArrayList<CellEditorListener>();
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        if (eventObject instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)eventObject;
            if (keyEvent.getModifiers() != 0) {
                return false;
            }
            if (keyEvent.getKeyChar() == '\uffff') {
                return false;
            }
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        return false;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.a.setInput(object, jTable, n, n2);
        this.a.addHierarchyListener(hierarchyEvent -> {
            Window window = SwingUtilities.getWindowAncestor(this.a);
            if (window instanceof Dialog && !((Dialog)window).isResizable()) {
                ((Dialog)window).setResizable(true);
            }
        });
        Component component = SwingUtilities.getRoot(jTable);
        int n3 = JOptionPane.showConfirmDialog(component, this.a, this.title, 2, -1);
        if (n3 == 0) {
            this.a.okHandler();
        } else {
            this.a.cancelHandler();
        }
        return null;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }
}

