/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.ui.mode;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import lombok.NonNull;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.control.Mode;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.CTable;
import net.astah.jomt.jview.TableEditor;
import net.astah.notation.TableView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class TableMode
extends Mode {
    protected final TableEditor tableEditor;

    public TableMode(@NonNull TableEditor tableEditor) {
        if (tableEditor == null) {
            throw new NullPointerException("tableEditor");
        }
        this.tableEditor = tableEditor;
        JTable jTable = this.getJTable();
        jTable.addKeyListener((KeyListener)((Object)this));
        jTable.addMouseListener((MouseListener)((Object)this));
    }

    protected TableEditor getTableEditor() {
        return this.tableEditor;
    }

    protected EditingDomain getDomain() {
        return this.getTableEditor().getDomain();
    }

    protected CTable getTable() {
        return this.getTableEditor().getTable();
    }

    protected JTable getJTable() {
        return (JTable)this.getTableEditor().getTable().getComponent();
    }

    protected TableView getTableModel() {
        return (TableView)this.getTableEditor().getModel();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        JTable jTable = this.getJTable();
        if (InputEventSupport.isControlDown((InputEvent)keyEvent) && keyEvent.getKeyCode() == 68) {
            int[] nArray = jTable.getSelectedRows();
            if (nArray.length > 0) {
                TableMode.a(jTable, nArray);
                if (this.deleteRows(nArray)) {
                    keyEvent.consume();
                }
            }
        } else if (keyEvent.getKeyCode() == 10 && (n = jTable.getSelectedRow()) == jTable.getRowCount() - 1 && this.addRow(jTable.convertRowIndexToModel(n))) {
            keyEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            JTable jTable = this.getJTable();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int n2 = n >= 0 ? jTable.convertRowIndexToModel(n) : -1;
            int n3 = jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
            if (jTable.isEditing()) {
                jTable.getCellEditor().stopCellEditing();
            }
            int n4 = jTable.rowAtPoint(mouseEvent.getPoint());
            int n5 = jTable.columnAtPoint(mouseEvent.getPoint());
            if (n4 >= 0 && n5 >= 0) {
                jTable.changeSelection(n4, n5, false, false);
            } else {
                jTable.clearSelection();
            }
            CPopupMenu cPopupMenu = this.createPopupMenu(n2, n3);
            if (cPopupMenu != null) {
                cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        super.mousePressed(mouseEvent);
    }

    protected CPopupMenu createPopupMenu(int n, int n2) {
        return null;
    }

    protected boolean addRow(int n) {
        Command command = this.createAddRowCommand(n);
        if (command.canExecute()) {
            this.executeCommand(command);
            return true;
        }
        return true;
    }

    protected boolean deleteRows(@NonNull int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("rows");
        }
        Command command = this.createDeleteRowCommand(nArray);
        if (command.canExecute()) {
            this.executeCommand(command);
            return true;
        }
        return false;
    }

    protected Command createAddRowCommand(int n) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createDeleteRowCommand(int n) {
        return n < 0 ? UnexecutableCommand.INSTANCE : this.createDeleteRowCommand(new int[]{n});
    }

    protected Command createDeleteRowCommand(@NonNull int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("rows");
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected void executeCommand(@NonNull Command command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)this.getTableModel());
        if (transactionalEditingDomain != null) {
            new CommandJob(transactionalEditingDomain, command).schedule();
        } else {
            this.getDomain().getCommandStack().execute(command);
        }
    }

    static void a(JTable jTable, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = jTable.convertRowIndexToModel(nArray[i]);
        }
    }
}

