/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.ui.export;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.IItemVariantLabelProvider;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTableModel;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.table.CellDescriptor;
import net.astah.table.Tuple;
import net.astah.table.engine.impl.CellDescriptorEngineAdapter;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import net.astah.table.ui.Messages;
import net.astah.table.ui.export.RichTextStrings;
import net.astah.table.ui.export.TableExport;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.StyledString;

public class TableExcelExport
extends TableExport {
    public TableExcelExport(List<JTable> list) {
        super(list);
    }

    public TableExcelExport(JTable jTable) {
        super(jTable);
    }

    @Override
    public void export(String string) {
        if (!string.endsWith(".xlsx")) {
            string = string + ".xlsx";
        }
        try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();){
            this.createSheets(xSSFWorkbook);
            if (Iterators.size((Iterator)xSSFWorkbook.sheetIterator()) == 0) {
                xSSFWorkbook.createSheet();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                xSSFWorkbook.write((OutputStream)fileOutputStream);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, Messages.table_excel_export_can_not_write_file_message, "Alert", 0);
            }
            xSSFWorkbook.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    protected void createSheets(XSSFWorkbook xSSFWorkbook) {
        for (JTable jTable : this.a) {
            this.a(jTable, this.getSheetName(jTable), xSSFWorkbook);
        }
    }

    protected String getSheetName(JTable jTable) {
        return jTable.getName();
    }

    private void a(JTable jTable, String string, XSSFWorkbook xSSFWorkbook) {
        int n;
        RichTextString richTextString3;
        Object object2;
        Object object3;
        Object object4;
        XSSFCellStyle xSSFCellStyle;
        XSSFCellStyle xSSFCellStyle2;
        int n2;
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet();
        if (string != null) {
            xSSFWorkbook.setSheetName(xSSFWorkbook.getSheetIndex((Sheet)xSSFSheet), string);
        }
        TableModel tableModel = jTable.getModel();
        RichTextStrings richTextStrings = new RichTextStrings(xSSFWorkbook);
        Row row = xSSFSheet.createRow(0);
        if (tableModel instanceof TransactionalContentProviderTableModel) {
            TransactionalContentProviderTableModel transactionalContentProviderTableModel = (TransactionalContentProviderTableModel)tableModel;
            for (n2 = 0; n2 < transactionalContentProviderTableModel.getColumnCount(); ++n2) {
                IItemPropertyDescriptor iItemPropertyDescriptor;
                Cell cell = row.createCell(n2);
                xSSFCellStyle2 = xSSFWorkbook.createCellStyle();
                xSSFCellStyle2.cloneStyleFrom(cell.getCellStyle());
                xSSFCellStyle2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                xSSFCellStyle2.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
                cell.setCellStyle((CellStyle)xSSFCellStyle2);
                xSSFCellStyle = (ITableColumnProvider.IColumnDescriptor)transactionalContentProviderTableModel.getColumnProvider().getColumnDescriptors().get(n2);
                object4 = (Tuple)xSSFCellStyle.getHeaderValue(null);
                object3 = ItemProviders.getAdapterFactory((EObject)object4);
                object2 = DatasetEngineAdapter.getHeaderDescriptors((AdapterFactory)object3, (Object)object4.getDataset(), (Tuple)object4);
                richTextString3 = (CellDescriptor)Iterables.getFirst((Iterable)object2, null);
                if (richTextString3 == null || (iItemPropertyDescriptor = CellDescriptorEngineAdapter.getHeaderPropertyDescriptor((AdapterFactory)object3, (Object)richTextString3, (Tuple)object4)) == null) continue;
                Object object5 = iItemPropertyDescriptor.getPropertyValue(object4);
                if (object5 instanceof IItemLabelProvider) {
                    cell.setCellValue(((IItemLabelProvider)object5).getText(object4));
                } else {
                    cell.setCellValue(object5.toString());
                }
                XSSFCellStyle xSSFCellStyle3 = xSSFWorkbook.createCellStyle();
                xSSFCellStyle3.setWrapText(true);
                cell.setCellStyle((CellStyle)xSSFCellStyle3);
            }
        }
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            Row row2 = xSSFSheet.createRow(n + 1);
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                xSSFCellStyle2 = row2.createCell(i);
                xSSFCellStyle = xSSFWorkbook.createCellStyle();
                object4 = tableModel.getValueAt(n, i);
                if (object4 instanceof IItemPropertySource) {
                    object4 = ((IItemPropertySource)object4).getEditableValue(object4);
                }
                if (object4 instanceof List) {
                    object3 = ((List)object4).stream().map(this::a).map(object -> richTextStrings.createRichText(object)).reduce((richTextString, richTextString2) -> richTextStrings.merge((RichTextString)richTextString, (RichTextString)richTextString2, "\n")).orElse(null);
                    if (object3 != null) {
                        xSSFCellStyle2.setCellValue((RichTextString)object3);
                    }
                } else if (object4 instanceof EObject) {
                    object3 = this.a(object4);
                    if (object3 instanceof StyledString) {
                        object2 = (StyledString)object3;
                        richTextString3 = richTextStrings.createRichText((StyledString)object2);
                        xSSFCellStyle2.setCellValue(richTextString3);
                    } else {
                        xSSFCellStyle2.setCellValue(richTextStrings.createRichText(object3.toString()));
                    }
                } else {
                    if (object4 == null) continue;
                    xSSFCellStyle2.setCellValue(richTextStrings.createRichText(object4.toString()));
                }
                xSSFCellStyle.setWrapText(true);
                xSSFCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                xSSFCellStyle2.setCellStyle((CellStyle)xSSFCellStyle);
            }
        }
        for (n = 0; n < jTable.getColumnCount(); ++n) {
            n2 = jTable.getColumnModel().getColumn(n).getWidth();
            int n3 = n2 * 256 / 9;
            xSSFSheet.setColumnWidth(n, n3);
        }
    }

    private Object a(Object object) {
        IItemVariantLabelProvider iItemVariantLabelProvider;
        Object object2 = "";
        IItemStyledLabelProvider iItemStyledLabelProvider = (IItemStyledLabelProvider)ItemProviders.adapt((Object)object, IItemStyledLabelProvider.class);
        if (iItemStyledLabelProvider != null) {
            object2 = iItemStyledLabelProvider.getStyledText(object);
        }
        if (!(object2 instanceof StyledString) && (iItemVariantLabelProvider = (IItemVariantLabelProvider)ItemProviders.adapt((Object)object, IItemVariantLabelProvider.class)) != null) {
            object2 = iItemVariantLabelProvider.getText(object, (Object)ExtraLabelVariant.FULL);
        }
        return object2;
    }
}

