/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JTable;
import net.astah.golf.widget.CGraphics;
import net.astah.golf.widget.swing.SwingGraphics2D;
import net.astah.jomt.jview.PrintUtilities;
import net.astah.jomt.jview.TableEditor;
import net.astah.jomt.jview.swing.SwingEditorPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicClassMembers;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class SwingTableEditorPrinter
extends SwingEditorPrinter {
    private TableEditor a;
    private JTable b;
    private static final Logger c = LoggerFactory.getLogger(SwingTableEditorPrinter.class);

    public SwingTableEditorPrinter(TableEditor tableEditor, JTable jTable) {
        this.a = tableEditor;
        this.b = jTable;
    }

    public Printable getPrintable() {
        return new PrintableImpl();
    }

    public Printable getMultiPrintable() {
        return new MultiPrintableImpl();
    }

    public int getNumbersOfPrintable(PageFormat pageFormat) {
        int n;
        double d = Math.round(pageFormat.getImageableX());
        double d2 = Math.round(pageFormat.getImageableY());
        double d3 = pageFormat.getImageableHeight();
        double d4 = pageFormat.getImageableWidth();
        double d5 = this.b.getWidth();
        double d6 = 1.0;
        double d7 = (double)this.b.getTableHeader().getHeight() * d6;
        if (d < 24.0) {
            d4 -= 2.0 * (24.0 - d);
        }
        if (d2 < 24.0) {
            d3 -= 2.0 * (24.0 - d2);
        }
        double d8 = d4 - 5.0 - 5.0;
        double d9 = d3 - PrintUtilities.getHeaderSpace() - PrintUtilities.getFooterSpace() - 0.0 - 0.0;
        if (d5 >= d8) {
            d6 = d8 / d5;
        }
        double d10 = d9 - (d7 *= d6);
        int[] nArray = new int[this.b.getRowCount()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.b.getRowHeight(n);
        }
        n = this.getTotalPages(this.b, d10, d6, nArray);
        return n;
    }

    protected int getTotalPages(JTable jTable, double d, double d2, int[] nArray) {
        return this.a(0, nArray, d, 0, d2);
    }

    private int a(int n, int[] nArray, double d, int n2, double d2) {
        ++n2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n; i < nArray.length; ++i) {
            d5 = (double)nArray[i] * d2;
            if (d5 > d) {
                d4 = d5 + d3 - (double)((int)d);
                n2 += this.getExtendPage(d4, d);
                d3 = this.getAdditionalHeight(d4, d);
                continue;
            }
            if (d3 + d5 < d) {
                d3 += d5;
                continue;
            }
            n2 = this.a(i, nArray, d, n2, d2);
            break;
        }
        return n2;
    }

    @Keep
    @KeepPublicClassMembers
    class MultiPrintableImpl
    implements Printable {
        MultiPrintableImpl() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            SwingTableEditorPrinter.this.b.clearSelection();
            SwingTableEditorPrinter.this.b.removeEditor();
            PrintUtilities.setPrintName((String)SwingTableEditorPrinter.this.a.getEditorTitle());
            PrintUtilities.setPrintType((String)"CRUD");
            int n2 = SwingTableEditorPrinter.this.a.getTotalPages();
            PrintUtilities.setPageIndex((int)(n + 1));
            try {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.black);
                int[] nArray = new int[SwingTableEditorPrinter.this.b.getRowCount()];
                nArray = SwingTableEditorPrinter.this.getEachLength(SwingTableEditorPrinter.this.b);
                double d = Math.round(pageFormat.getImageableX());
                double d2 = Math.round(pageFormat.getImageableY());
                double d3 = pageFormat.getImageableHeight();
                double d4 = pageFormat.getImageableWidth();
                double d5 = SwingTableEditorPrinter.this.b.getWidth();
                if (d5 == 0.0) {
                    d5 = SwingTableEditorPrinter.this.b.getTableHeader().getPreferredSize().getWidth();
                }
                double d6 = 1.0;
                double d7 = SwingTableEditorPrinter.this.b.getTableHeader().getHeight();
                double d8 = d7 * d6;
                if (d < 24.0) {
                    d4 -= 2.0 * (24.0 - d);
                    d = 24.0;
                }
                if (d2 < 24.0) {
                    d3 -= 2.0 * (24.0 - d2);
                    d2 = 24.0;
                }
                Font font = new Font("Serif", 0, 8);
                graphics2D.setFont(font);
                double d9 = d + 5.0;
                double d10 = d2 + 10.0;
                PrintUtilities.drawHeader((CGraphics)new SwingGraphics2D(graphics2D), (double)d, (double)d4, (Font)font, (double)d9, (double)d10);
                PrintUtilities.drawFooter((CGraphics)new SwingGraphics2D(graphics2D), (double)d, (double)d2, (double)d4, (double)d3, (Font)font, (double)PrintUtilities.getFooterSpace());
                double d11 = d4 - 5.0 - 5.0;
                double d12 = d3 - PrintUtilities.getHeaderSpace() - PrintUtilities.getFooterSpace() - 0.0 - 0.0;
                double d13 = d + 5.0;
                double d14 = d2 + 0.0 + PrintUtilities.getHeaderSpace();
                if (d5 >= d11) {
                    d6 = d11 / d5;
                }
                d8 = d7 * d6;
                double d15 = d5 * d6;
                double d16 = d12 - d8;
                double[] dArray = new double[n2];
                double[] dArray2 = new double[n2];
                double[] dArray3 = new double[n2];
                dArray3 = SwingTableEditorPrinter.this.getEachHeight(SwingTableEditorPrinter.this.b, d16, dArray, d6, nArray);
                dArray2 = SwingTableEditorPrinter.this.a.getStartPoint(dArray2, dArray);
                double d17 = SwingTableEditorPrinter.this.a.getTotalHeight(n, dArray);
                graphics2D.translate(d13, d14);
                graphics2D.translate(0.0, d8 - d17);
                graphics2D.setClip(0, (int)Math.round(dArray2[n]), (int)d15, (int)Math.ceil(dArray[n]));
                graphics2D.scale(d6, d6);
                SwingTableEditorPrinter.this.b.paint(graphics2D);
                graphics2D.scale(1.0 / d6, 1.0 / d6);
                graphics2D.translate(0.0, d17);
                graphics2D.translate(0.0, -d8);
                graphics2D.setClip(0, 0, (int)Math.ceil(d15), (int)Math.ceil(d8) - 1);
                graphics2D.scale(d6, d6);
                SwingTableEditorPrinter.this.b.getTableHeader().paint(graphics2D);
                graphics2D.scale(1.0 / d6, 1.0 / d6);
                graphics2D.setClip(0, 0, (int)Math.ceil(d15) - 1, (int)Math.ceil(dArray[n] + d8) - 1);
                graphics2D.drawRect(0, 0, (int)Math.ceil(d15) - 1, (int)Math.ceil(dArray3[n] + d8) - 1);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, (int)d8, (int)d5 - 1, (int)d8 - 1);
            }
            catch (Exception exception) {
                c.error("error has occurred.", (Throwable)exception);
            }
            return 0;
        }
    }

    @Keep
    @KeepPublicClassMembers
    class PrintableImpl
    implements Printable {
        PrintableImpl() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            SwingTableEditorPrinter.this.b.clearSelection();
            SwingTableEditorPrinter.this.b.removeEditor();
            PrintUtilities.setPrintName((String)SwingTableEditorPrinter.this.a.getEditorTitle());
            PrintUtilities.setPrintType((String)"CRUD");
            PrintUtilities.setPageIndex((int)(n + 1));
            PrintUtilities.setMultiPageIndex((int)(n + 1));
            try {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setColor(Color.black);
                double d = Math.round(pageFormat.getImageableX());
                double d2 = Math.round(pageFormat.getImageableY());
                double d3 = pageFormat.getImageableHeight();
                double d4 = pageFormat.getImageableWidth();
                double d5 = SwingTableEditorPrinter.this.b.getWidth();
                if (d5 == 0.0) {
                    d5 = SwingTableEditorPrinter.this.b.getTableHeader().getPreferredSize().getWidth();
                }
                double d6 = SwingTableEditorPrinter.this.b.getHeight();
                double d7 = SwingTableEditorPrinter.this.b.getTableHeader().getHeight();
                double d8 = 1.0;
                double d9 = d7 * d8;
                if (d < 24.0) {
                    d4 -= 2.0 * (24.0 - d);
                    d = 24.0;
                }
                if (d2 < 24.0) {
                    d3 -= 2.0 * (24.0 - d2);
                    d2 = 24.0;
                }
                Font font = new Font("Serif", 0, 8);
                graphics2D.setFont(font);
                double d10 = d + 5.0;
                double d11 = d2 + 10.0;
                PrintUtilities.drawHeader((CGraphics)new SwingGraphics2D(graphics2D), (double)d, (double)d4, (Font)font, (double)d10, (double)d11);
                PrintUtilities.drawFooter((CGraphics)new SwingGraphics2D(graphics2D), (double)d, (double)d2, (double)d4, (double)d3, (Font)font, (double)PrintUtilities.getFooterSpace());
                double d12 = d4 - 5.0 - 5.0;
                double d13 = d3 - PrintUtilities.getHeaderSpace() - PrintUtilities.getFooterSpace() - 0.0 - 0.0;
                double d14 = d + 5.0;
                double d15 = d2 + 0.0 + PrintUtilities.getHeaderSpace();
                if (d5 >= d12) {
                    d8 = d12 / d5;
                }
                if ((d6 + d9) * d8 >= d13) {
                    d8 = d13 / (d6 + d9);
                }
                d9 = d7 * d8;
                graphics2D.translate(d14, d15);
                graphics2D.scale(d8, d8);
                graphics2D.setClip(0, 0, (int)d5, (int)d7);
                SwingTableEditorPrinter.this.b.getTableHeader().paint(graphics2D);
                graphics2D.drawRect(0, 0, (int)d5 - 1, (int)d7 - 1);
                graphics2D.translate(0.0, d7 - 1.0);
                graphics2D.setClip(0, 0, (int)d5, (int)d6);
                SwingTableEditorPrinter.this.b.paint(graphics2D);
                graphics2D.drawRect(0, 0, (int)d5 - 1, (int)d6 - 1);
                graphics2D.scale(1.0 / d8, 1.0 / d8);
            }
            catch (Exception exception) {
                c.error("error has occurred.", (Throwable)exception);
            }
            return 0;
        }
    }
}

