/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.EntityStoreListener;
import net.astah.golf.model.IExObservable;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.util.UIFactory;
import net.astah.golf.view.UIView;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.CIcon;
import net.astah.golf.widget.CInternalFrame;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.CTable;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.golf.widget.swing.SwingInternalFrame;
import net.astah.golf.widget.swing.SwingTable;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.SaveFileChooser;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.NamespaceNameFactory;
import net.astah.jomt.jview.TableEditor;
import net.astah.jomt.jview.TableEditorPeer;
import net.astah.jomt.jview.swing.SwingEditorPeer;
import net.astah.jomt.jview.swing.SwingTableEditorPrinter;
import net.astah.notation.TableView;
import net.astah.table.FeaturePath;
import net.astah.table.FeatureSegment;
import net.astah.table.Grid;
import net.astah.table.Table;
import net.astah.table.TableFactory;
import net.astah.table.edit.command.RefreshGridCommand;
import net.astah.table.edit.domain.GridRefresher;
import net.astah.table.edit.provider.GenericTableAdapterFactory;
import net.astah.table.edit.provider.GridObserver;
import net.astah.table.engine.impl.TableEngineAdapter;
import net.astah.table.ui.TableUIView;
import net.astah.table.ui.Tables;
import net.astah.table.ui.export.TableExcelExport;
import net.astah.table.ui.swing.GenericTableColumnProvider;
import net.astah.table.ui.swing.GenericTableTableTransferHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class SwingTableEditorPeer
extends SwingEditorPeer
implements ListSelectionListener,
TableModelListener,
TableEditorPeer {
    private static final Logger a = LoggerFactory.getLogger(SwingTableEditorPeer.class);
    private Diagram b;
    private JTable c;
    private SwingTable d;
    protected Table tableModel;
    protected Grid grid;
    protected EditingDomain domain;
    protected final Disposable disposable = new Disposable();

    public CIcon getEditorIcon() {
        return new SwingIcon(this.a(this.b));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void initialize(Diagram diagram, CJComponent cJComponent) {
        this.b = diagram;
        TableEditor tableEditor = this.getTableEditor();
        CInternalFrame cInternalFrame = this.createFrame(cJComponent);
        this.frame = (JInternalFrame)((SwingInternalFrame)cInternalFrame).getComponent();
        this.hideTitleBarOfEditorFrame();
        tableEditor.addComponent((CComponent)cInternalFrame);
        tableEditor.setSelectionType(1);
        tableEditor.setUiFactory(new UIFactory(TableEditor.getResources()));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.setFrameIcon(this.a(diagram));
        this.c = this.createTable();
        if (this.c == null) {
            return;
        }
        EditableTextComponentMouseAdapther.install((JTable)this.c);
        this.d = new SwingTable(this.c);
        TableUIView tableUIView = new TableUIView((CTable)this.d);
        tableEditor.addUIView((UIView)tableUIView);
        tableEditor.setCurrentUIView((UIView)tableUIView);
        JScrollPane jScrollPane = new JScrollPane(this.c);
        this.frame.getContentPane().add("Center", jScrollPane);
        this.frame.getContentPane().add("North", this.createNorthPanel());
        this.frame.getContentPane().add("South", this.createSouthPanel());
        this.frame.pack();
        jScrollPane.addMouseListener((MouseListener)((Object)this));
        this.frame.setSize(((JComponent)((SwingComponent)cJComponent).getComponent()).getSize());
        this.frame.setVisible(true);
        this.setTitle(LabelProviders.getName((Object)diagram), NamespaceNameFactory.getNamespace((Object)diagram));
        this.printer = new SwingTableEditorPrinter(tableEditor, (JTable)((SwingTable)this.getTable()).getComponent());
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore != null && !ViewGlobal.isSilentMode) {
            iJomtEntityStore.addEntityStoreListener((EntityStoreListener)tableEditor);
        }
        Enumeration<TableColumn> enumeration = this.c.getColumnModel().getColumns();
        for (float f : this.getColumnsWidthRatio()) {
            if (!enumeration.hasMoreElements()) continue;
            enumeration.nextElement().setPreferredWidth((int)((float)this.c.getWidth() * f));
        }
    }

    protected float[] getColumnsWidthRatio() {
        return new float[0];
    }

    private Icon a(Diagram diagram) {
        Object object = LabelProviders.getImage((Object)diagram);
        if (object != null) {
            Icon icon = SwingIconRegistry.INSTANCE.getIcon(object);
            return icon;
        }
        return null;
    }

    protected TableEditor getTableEditor() {
        return (TableEditor)this.uiView;
    }

    protected JTable createTable() {
        AdapterFactory adapterFactory = this.createTableAdapterFactory();
        this.disposable.add((Object)adapterFactory);
        TableView tableView = (TableView)this.getDiagram();
        this.tableModel = this.prepareTableModel(tableView);
        this.grid = this.prepareGrid(tableView, adapterFactory, this.tableModel);
        this.domain = this.prepareDomain(adapterFactory, this.grid);
        this.disposable.add((Object)GridObserver.observe((Grid)this.grid, (IChangeNotifier)((IChangeNotifier)adapterFactory)));
        this.disposable.add((Object)new GridRefresher(TransactionUtil.getEditingDomain((EObject)tableView), this.grid));
        return this.createJTable(adapterFactory, this.grid);
    }

    protected JTable createJTable(AdapterFactory adapterFactory, Grid grid) {
        GenericTableColumnProvider genericTableColumnProvider = new GenericTableColumnProvider();
        genericTableColumnProvider.setAdapterFactory(adapterFactory);
        genericTableColumnProvider.setGrid(grid);
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return ((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)transactionalEditingDomain).adapterFactory(adapterFactory)).columnProvider((ITableColumnProvider)genericTableColumnProvider).transferHandler((TransferHandler)((Object)new GenericTableTableTransferHandler(transactionalEditingDomain, this.domain)))).input((Object)grid).font(this.resolveTableFont())).build((JTable)new GenericTable());
    }

    protected Table prepareTableModel(TableView tableView) {
        throw new UnsupportedOperationException("createTable() must be overridden");
    }

    protected Grid prepareGrid(TableView tableView, AdapterFactory adapterFactory, Table table) {
        return TableEngineAdapter.generateGrid((AdapterFactory)adapterFactory, (Object)table, (boolean)false);
    }

    protected EditingDomain prepareDomain(AdapterFactory adapterFactory, Grid grid) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)grid);
        if (editingDomain == null) {
            CommandStack commandStack = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.b).getCommandStack();
            editingDomain = new AdapterFactoryEditingDomain(adapterFactory, commandStack);
            ResourceImpl resourceImpl = new ResourceImpl(URI.createURI((String)""));
            ResourceSet resourceSet = editingDomain.getResourceSet();
            resourceSet.getResources().add((Object)resourceImpl);
            resourceImpl.getContents().add((Object)grid);
            this.disposable.add((Object)ResourceSets.wrapDisposable((ResourceSet)resourceSet));
        }
        return editingDomain;
    }

    protected Container createNorthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Container container = this.createToolBar();
        if (container != null) {
            jPanel.add(container);
        }
        return jPanel;
    }

    protected Container createToolBar() {
        FlowLayout flowLayout = new FlowLayout(2, 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(flowLayout);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        jToolBar.add(this.createExportButton());
        return jToolBar;
    }

    protected JButton createExportButton() {
        return new ExportExcelButton();
    }

    protected Container createSouthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        return jPanel;
    }

    public void update(EntityStoreEvent entityStoreEvent) {
        Font font = this.resolveTableFont();
        if (this.c.getFont() != font) {
            this.c.setFont(font);
            this.c.getTableHeader().setFont(font);
            ((GenericTable)this.c).adjustRowHeight();
        }
    }

    public void stopEditing() {
        if (this.c.isEditing()) {
            this.c.getCellEditor().stopCellEditing();
        }
    }

    public void remove() {
        if (this.c != null) {
            JTableBuilder.dispose((JTable)this.c);
        }
        this.disposable.dispose();
    }

    public void setTitle(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" / ");
        stringBuilder.append(LabelProviders.getTypeText((Object)this.getDiagram()));
        if (!string2.equals("") && RuntimeGlobal.sysProp.getBooleanWithDefault("diagram.editor.show_namespace")) {
            stringBuilder.append(" [");
            stringBuilder.append(string2);
            stringBuilder.append("]");
        }
        this.a(stringBuilder.toString());
    }

    private void a(String string) {
        this.frame.setTitle(string);
    }

    public CTable getTable() {
        return this.d;
    }

    public Table getTableModel() {
        return this.tableModel;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public CTable getRowTable() {
        throw new UnsupportedOperationException("getRowTable() must be overridden");
    }

    public CPopupMenu getPopup(String string) {
        throw new UnsupportedOperationException("getPopup() must be overridden");
    }

    public void updatePasteLocation(CPopupMenu cPopupMenu, MouseEvent mouseEvent) {
        throw new UnsupportedOperationException("updatePasteLocation() must be overridden");
    }

    public void updateHyperlinkPopup(IExObservable iExObservable, CPopupMenu cPopupMenu) {
        throw new UnsupportedOperationException("updateHyperlinkPopup() must be overridden");
    }

    public int getRowCount() {
        return 0;
    }

    public int getColumnCount() {
        return 0;
    }

    public int[] getSelectedRows() {
        return null;
    }

    public int[] getSelectedColumns() {
        throw new UnsupportedOperationException("getSelectedColumns() must be overridden");
    }

    public String getValueAt(int n, int n2) {
        throw new UnsupportedOperationException("getValueAt() must be overridden");
    }

    public void updateLookAndFeel() {
    }

    public ISelection getEditorSelection(ISelection iSelection) {
        if (iSelection instanceof ITableSelection) {
            return this.getEditorSelection((ITableSelection)iSelection);
        }
        return iSelection;
    }

    protected ISelection getEditorSelection(ITableSelection iTableSelection) {
        return iTableSelection;
    }

    public Diagram getDiagram() {
        return this.b;
    }

    protected AdapterFactory createTableAdapterFactory() {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return new GenericTableAdapterFactory(ItemProviders.getAdapterFactory((EditingDomain)transactionalEditingDomain));
    }

    protected static void applyFeaturePath(FeaturePath featurePath, EFeaturePath eFeaturePath) {
        EList eList = featurePath.getSegments();
        for (EFeaturePath.Segment segment : eFeaturePath) {
            FeatureSegment featureSegment = TableFactory.eINSTANCE.createFeatureSegment();
            if (segment.isInverse()) {
                featureSegment.setFeature((EStructuralFeature)segment.getEOpposite());
                featureSegment.setInverse(true);
            } else {
                featureSegment.setFeature(segment.getFeature());
                featureSegment.setInverse(false);
            }
            eList.add((Object)featureSegment);
        }
    }

    protected Font resolveTableFont() {
        URI uRI;
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = (IItemGraphicalStyleProvider)ItemProviders.adapt((EObject)this.getDiagram(), IItemGraphicalStyleProvider.class);
        if (iItemGraphicalStyleProvider != null && (uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle((Object)this.getDiagram(), (Object)IItemGraphicalStyleProvider.Feature.FONT)) != null) {
            return new FontURIResolver(null).resolve(uRI);
        }
        return JomtFontUtilities.getScaledProjectFont();
    }

    public void startCellEditing(int n, int n2) {
        Tables.startCellEditing(this.c, n, n2);
    }

    public void tableEditorActivated(Editor editor) {
    }

    public class ExportExcelButton
    extends JButton {
        private static final long serialVersionUID = -3380471736931530321L;
        static final String NAME = "exportExcelButton";
        ImageIcon exportIcon = (ImageIcon)SwingIconRegistry.INSTANCE.getIcon((Object)this.getClass().getResource("/net/astah/jomt/resource/images/export.png"));

        public ExportExcelButton() {
            this.setName(NAME);
            this.setExportIcon();
            String string = PropertyManager.getProjectViewResourceBundle().getString("ui.export_excel_dialog.title.label");
            this.setToolTipText(string);
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportExcelButton.this.export();
                }
            });
        }

        public void setExportIcon() {
            this.setIcon(this.exportIcon);
        }

        private void export() {
            JTable jTable = (JTable)SwingTableEditorPeer.this.getTable().getComponent();
            if (jTable == null) {
                return;
            }
            new SaveFileChooser(SwingTableEditorPeer.this.uiView.getComponent().getComponent(), "xlsx", "xlsx Files", SwingTableEditorPeer.this.getDiagram().getName(), false).select(file -> {
                this.exportFile(jTable, file.getPath());
                return true;
            });
        }

        protected void exportFile(JTable jTable, String string) {
            new TableExcelExport(jTable).export(string);
        }
    }

    public class UpdateButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        static final String NAME = "updateButton";
        ImageIcon updateIcon = (ImageIcon)SwingIconRegistry.INSTANCE.getIcon((Object)this.getClass().getResource("/net/astah/jomt/resource/images/update.png"));

        public UpdateButton() {
            this.setName(NAME);
            this.setUpdateIcon();
            String string = PropertyManager.getProjectViewResourceBundle().getString("projectview.button.update.label");
            this.setToolTipText(string);
            this.setFocusable(false);
            this.addActionListener(actionEvent -> {
                RefreshGridCommand refreshGridCommand = new RefreshGridCommand(SwingTableEditorPeer.this.domain, (EObject)SwingTableEditorPeer.this.grid);
                try {
                    SwingTableEditorPeer.this.domain.getCommandStack().execute((Command)refreshGridCommand);
                }
                catch (Exception exception) {
                    a.error("Refreshing the grid failed", (Throwable)exception);
                }
            });
        }

        public void setUpdateIcon() {
            this.setIcon(this.updateIcon);
        }
    }
}

