/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics.swing;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Image;
import net.astah.emf.common.resource.ResourceStorage;
import net.astah.golf.view.swing.SwingResourceStorages;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.ScaledImageIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jmodel.ImagePresentation;
import net.astah.jmodel.JmodelPackage;
import net.astah.notation.ImageShape;
import net.astah.notation.NotationPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingImageAdapter
extends AdapterImpl {
    private static final Logger a = LoggerFactory.getLogger(SwingImageAdapter.class);
    protected URI imageURI;

    protected SwingImageAdapter() {
    }

    public static SwingImageAdapter getInstance(Notifier notifier) {
        EList eList = notifier.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, SwingImageAdapter.class);
        if (adapter instanceof SwingImageAdapter) {
            return (SwingImageAdapter)adapter;
        }
        SwingImageAdapter swingImageAdapter = new SwingImageAdapter();
        eList.add((Object)swingImageAdapter);
        return swingImageAdapter;
    }

    public boolean isAdapterForType(Object object) {
        return object == SwingImageAdapter.class;
    }

    public URI getImageURI() {
        if (this.imageURI == null) {
            String string = null;
            if (this.target instanceof Image) {
                string = ((Image)this.target).getSource();
            } else if (this.target instanceof ImageShape) {
                string = ((ImageShape)this.target).getSource();
            } else if (this.target instanceof ImagePresentation) {
                string = ((ImagePresentation)this.target).getSource();
            }
            if (string != null) {
                this.imageURI = URI.createURI((String)string);
            }
        }
        return this.imageURI;
    }

    public CImageIcon getImage() {
        return this.getImage(this.target);
    }

    public CImageIcon getImage(Notifier notifier) {
        ResourceStorage resourceStorage;
        URI uRI = this.getImageURI();
        if (uRI != null && (resourceStorage = ResourceStorage.getResourceStorage((Notifier)notifier)) != null) {
            try {
                return SwingResourceStorages.getImage((ResourceStorage)resourceStorage, (URI)uRI);
            }
            catch (IOException iOException) {
                a.warn("Failed to load image", (Throwable)iOException);
            }
        }
        return null;
    }

    public CImageIcon getImageWithScale() {
        return this.getImage(this.target, Collections.singleton(new SwingIconRegistry.Scale(1.0)));
    }

    public CImageIcon getImage(Notifier notifier, Set<SwingIconRegistry.Modifier> set) {
        CImageIcon cImageIcon = this.getImage(notifier);
        double d = SwingIconRegistry.Scale.getValue(set);
        if (d == 1.0) {
            return cImageIcon;
        }
        return new SwingImageIcon((ImageIcon)new ScaledImageIcon((Icon)cImageIcon.getImageIcon(), d));
    }

    public void setTarget(Notifier notifier) {
        super.setTarget(notifier);
        this.imageURI = null;
    }

    public void notifyChanged(Notification notification) {
        if (!notification.isTouch()) {
            Object object = notification.getFeature();
            if (object == DGPackage.Literals.IMAGE__SOURCE) {
                this.imageURI = null;
            } else if (object == NotationPackage.Literals.IMAGE_SHAPE__SOURCE) {
                this.imageURI = null;
            } else if (object == JmodelPackage.Literals.IMAGE_PRESENTATION__SOURCE) {
                this.imageURI = null;
            }
        }
    }
}

