/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import java.awt.Font;
import java.util.Arrays;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Style;
import net.astah.dd.dg.Text;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.notation.provider.graphics.DGLayoutHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DGSetStyleHelper
extends DGLayoutHelper {
    protected Object feature;

    public DGSetStyleHelper(EditingDomain editingDomain, Object object, Object object2) {
        super(editingDomain, null, object2);
        ColorURIResolver colorURIResolver = new ColorURIResolver(null, null);
        this.feature = object;
        if (object instanceof IItemGraphicalStyleProvider.Feature) {
            if (object2 instanceof URI && (object == IItemGraphicalStyleProvider.Feature.FILL_COLOR || object == IItemGraphicalStyleProvider.Feature.STROKE_COLOR || object == IItemGraphicalStyleProvider.Feature.FONT_COLOR)) {
                this.value = DCFactory.eINSTANCE.createColor(colorURIResolver.resolve((URI)object2).getRGB());
            }
            switch ((IItemGraphicalStyleProvider.Feature)object) {
                case FILL_COLOR: {
                    this.feature = DGPackage.Literals.STYLE__FILL_COLOR;
                    break;
                }
                case STROKE_COLOR: {
                    this.feature = DGPackage.Literals.STYLE__STROKE_COLOR;
                    break;
                }
                case FONT_COLOR: {
                    this.feature = DGPackage.Literals.STYLE__FONT_COLOR;
                    break;
                }
                case FONT: {
                    this.feature = DGPackage.Literals.STYLE__FONT_NAME;
                }
            }
        }
    }

    public Command caseLine(Line line) {
        if (this.feature == DGPackage.Literals.STYLE__FILL_COLOR) {
            return IdentityCommand.INSTANCE;
        }
        this.a((EObject)line);
        this.appendFeatureSetCommand((EObject)line, DGPackage.Literals.LINE);
        return (Command)super.caseLine(line);
    }

    public Command casePolyline(Polyline polyline) {
        if (this.feature == DGPackage.Literals.STYLE__FILL_COLOR) {
            return IdentityCommand.INSTANCE;
        }
        this.a((EObject)polyline);
        this.appendFeatureSetCommand((EObject)polyline, DGPackage.Literals.POLYLINE);
        return (Command)super.casePolyline(polyline);
    }

    public Command caseRectangle(Rectangle rectangle) {
        if (this.feature == DGPackage.Literals.STYLE__FONT_COLOR || this.feature == DGPackage.Literals.STYLE__FONT_BOLD || this.feature == DGPackage.Literals.STYLE__FONT_ITALIC || this.feature == DGPackage.Literals.STYLE__FONT_NAME || this.feature == DGPackage.Literals.STYLE__FONT_SIZE) {
            return (Command)super.caseRectangle(rectangle);
        }
        this.a((EObject)rectangle);
        this.appendFeatureSetCommand((EObject)rectangle, DGPackage.Literals.RECTANGLE);
        return (Command)super.caseRectangle(rectangle);
    }

    public Command caseEllipse(Ellipse ellipse) {
        this.a((EObject)ellipse);
        this.appendFeatureSetCommand((EObject)ellipse, DGPackage.Literals.ELLIPSE);
        return (Command)super.caseEllipse(ellipse);
    }

    public Command caseText(Text text) {
        if (this.feature == DGPackage.Literals.STYLE__FILL_COLOR || this.feature == DGPackage.Literals.STYLE__STROKE_COLOR) {
            return (Command)super.caseText(text);
        }
        if (this.feature == DGPackage.Literals.STYLE__FONT_NAME) {
            this.appendFontSetCommand((EObject)text, (URI)this.value);
        } else {
            this.a((EObject)text);
            this.appendFeatureSetCommand((EObject)text, DGPackage.Literals.TEXT);
        }
        return (Command)super.caseText(text);
    }

    protected void appendFeatureSetCommand(EObject eObject, EClass eClass) {
        if (this.feature instanceof EStructuralFeature && eClass.getEAllStructuralFeatures().contains(this.feature)) {
            this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)eObject, (Object)this.feature, (Object)this.value));
        }
    }

    protected void appendFontSetCommand(EObject eObject, URI uRI) {
        Style style;
        EList eList = ((GraphicalElement)eObject).getLocalStyles();
        if (eList.isEmpty()) {
            style = DGFactory.eINSTANCE.createStyle();
            this.command.append(AddCommand.create((EditingDomain)this.domain, (Object)eObject, (Object)DGPackage.Literals.GRAPHICAL_ELEMENT__LOCAL_STYLE, Arrays.asList(style)));
        } else {
            style = (Style)eList.get(0);
        }
        FontURIResolver fontURIResolver = new FontURIResolver(null);
        Font font = fontURIResolver.resolve(uRI);
        this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)style, (Object)DGPackage.Literals.STYLE__FONT_NAME, (Object)font.getFontName()));
        this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)style, (Object)DGPackage.Literals.STYLE__FONT_SIZE, (Object)font.getSize()));
        this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)style, (Object)DGPackage.Literals.STYLE__FONT_BOLD, (Object)font.isBold()));
        this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)style, (Object)DGPackage.Literals.STYLE__FONT_ITALIC, (Object)font.isItalic()));
    }

    private void a(EObject eObject) {
        if (this.feature instanceof EStructuralFeature && DGPackage.Literals.STYLE.getEAllStructuralFeatures().contains(this.feature) || this.feature instanceof IItemGraphicalStyleProvider.Feature) {
            Style style;
            EList eList = ((GraphicalElement)eObject).getLocalStyles();
            if (eList.isEmpty()) {
                style = DGFactory.eINSTANCE.createStyle();
                this.command.append(AddCommand.create((EditingDomain)this.domain, (Object)eObject, (Object)DGPackage.Literals.GRAPHICAL_ELEMENT__LOCAL_STYLE, Arrays.asList(style)));
            } else {
                style = (Style)eList.get(0);
            }
            this.appendFeatureSetCommand((EObject)style, DGPackage.Literals.STYLE);
        }
    }
}

