/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.awt.Font;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.dd.di.edit.command.SetSizeCommand;
import net.astah.emf.edit.command.DataTypeCommands;
import net.astah.golf.geom2D.RoundRectangle2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CImageIcon;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.notation.provider.graphics.DGGeometryProviderHelper;
import net.astah.notation.provider.graphics.DGGetBoundsHelper;
import net.astah.notation.provider.graphics.DGLayoutHelper;
import net.astah.notation.provider.graphics.swing.SwingImageAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DGSetSizeHelper
extends DGLayoutHelper {
    private static final double a = 0.0;

    public DGSetSizeHelper(EditingDomain editingDomain, Object object, Object object2) {
        super(editingDomain, object, object2);
    }

    public Command caseEllipse(Ellipse ellipse) {
        Point point = DGGeometryProviderHelper.getCenter(ellipse, this.getAccessor());
        Dimension dimension = DGGeometryProviderHelper.getRadii(ellipse, this.getAccessor());
        if (this.value instanceof Dimension && point != null && dimension != null) {
            Dimension dimension2 = this.correctCommonMinimum((Dimension)this.value);
            double d = dimension2.getWidth() / 2.0;
            double d2 = dimension2.getHeight() / 2.0;
            double d3 = point.getX() + d - dimension.getWidth();
            double d4 = point.getY() + d2 - dimension.getHeight();
            Point point2 = DCFactory.eINSTANCE.createPoint(d3, d4);
            Dimension dimension3 = DCFactory.eINSTANCE.createDimension(d, d2);
            this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)ellipse, (EReference)DGPackage.Literals.ELLIPSE__CENTER, (EObject)point2, (EObject)point));
            this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)ellipse, (EReference)DGPackage.Literals.ELLIPSE__RADII, (EObject)dimension3, (EObject)dimension));
            this.applyAccessor((EObject)ellipse, DGPackage.Literals.ELLIPSE__CENTER, point2);
            this.applyAccessor((EObject)ellipse, DGPackage.Literals.ELLIPSE__RADII, dimension3);
        }
        return (Command)super.caseEllipse(ellipse);
    }

    public Command caseImage(Image image) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(image, this.getAccessor());
        if (bounds != null) {
            Dimension dimension = this.calculateImageSize(image);
            if (this.value == SetSizeCommand.AUTOMATIC_VALUE) {
                this.value = dimension;
            }
            if (this.value instanceof Dimension) {
                Dimension dimension2 = this.correctCommonMinimum((Dimension)this.value, dimension);
                Bounds bounds2 = this.applyBounds(bounds, dimension2);
                this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)image, (EReference)DGPackage.Literals.IMAGE__BOUNDS, (EObject)bounds2, (EObject)bounds));
                this.applyAccessor((EObject)image, DGPackage.Literals.IMAGE__BOUNDS, bounds2);
            }
        }
        return (Command)super.caseImage(image);
    }

    public Command caseLine(Line line) {
        List list;
        Point point = DGGeometryProviderHelper.getStart(line, this.getAccessor());
        Point point2 = DGGeometryProviderHelper.getEnd(line, this.getAccessor());
        if (this.value instanceof List && (list = (List)this.value).size() == 2) {
            Object e = list.get(0);
            Object e2 = list.get(1);
            if (e instanceof Point && e2 instanceof Point) {
                Point point3 = (Point)e;
                Point point4 = (Point)e2;
                this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)line, (EReference)DGPackage.Literals.LINE__START, (EObject)point3, (EObject)point));
                this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)line, (EReference)DGPackage.Literals.LINE__END, (EObject)point4, (EObject)point2));
                this.applyAccessor((EObject)line, DGPackage.Literals.LINE__START, point3);
                this.applyAccessor((EObject)line, DGPackage.Literals.LINE__END, point4);
            }
        }
        return (Command)super.caseLine(line);
    }

    public Command casePolyline(Polyline polyline) {
        if (this.value instanceof Dimension) {
            Dimension dimension = this.correctCommonMinimum((Dimension)this.value);
            Bounds bounds = DGGetBoundsHelper.INSTANCE.doSwitch((EObject)polyline, this.getAccessor());
            double d = bounds.getX();
            double d2 = bounds.getY();
            double d3 = dimension.getWidth() / bounds.getWidth();
            double d4 = dimension.getHeight() / bounds.getHeight();
            List<Point> list = DGGeometryProviderHelper.getPoints(polyline, this.getAccessor());
            Iterable iterable = Iterables.transform(list, point -> {
                double d5 = d + (point.getX() - d) * d3;
                double d6 = d2 + (point.getY() - d2) * d4;
                return DCFactory.eINSTANCE.createPoint(d5, d6);
            });
            this.command.append(DataTypeCommands.eChangeAll((EditingDomain)this.domain, (EObject)polyline, (EReference)DGPackage.Literals.POLYLINE__POINT, (Iterable)iterable, list));
            this.applyAccessor((EObject)polyline, DGPackage.Literals.POLYLINE__POINT, iterable);
        }
        return (Command)super.casePolyline(polyline);
    }

    public Command caseRectangle(Rectangle rectangle) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(rectangle, this.getAccessor());
        if (bounds != null && this.value instanceof Dimension) {
            Dimension dimension = this.correctCommonMinimum((Dimension)this.value);
            Bounds bounds2 = this.applyBounds(bounds, dimension);
            this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)rectangle, (EReference)DGPackage.Literals.RECTANGLE__BOUNDS, (EObject)bounds2, (EObject)bounds));
            this.applyAccessor((EObject)rectangle, DGPackage.Literals.RECTANGLE__BOUNDS, bounds2);
            if (rectangle.getCornerRadius() > 0.0) {
                double d = DGSetSizeHelper.getCornerRadius(bounds2);
                if (rectangle.getCornerRadius() != d) {
                    this.command.append(SetCommand.create((EditingDomain)this.domain, (Object)rectangle, (Object)DGPackage.Literals.RECTANGLE__CORNER_RADIUS, (Object)d));
                    this.applyAccessor((EObject)rectangle, DGPackage.Literals.RECTANGLE__CORNER_RADIUS, d);
                }
            }
        }
        return (Command)super.caseRectangle(rectangle);
    }

    public Command caseText(Text text) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(text, this.getAccessor());
        if (bounds != null) {
            Bounds bounds2;
            Font font = DGSetSizeHelper.getFont((GraphicalElement)text);
            String string = text.getData();
            if (font != null && string != null) {
                if (this.value == SetSizeCommand.AUTOMATIC_VALUE) {
                    this.value = DGSetSizeHelper.calculateTextSize(font, string, 0.0, 0.0);
                } else if (this.value instanceof Dimension) {
                    bounds2 = DGSetSizeHelper.a(font, (Dimension)this.value);
                    double d = DGSetSizeHelper.innerizeText((Dimension)bounds2).getWidth();
                    double d2 = DGSetSizeHelper.getWrappedTextHeight(font, string, d);
                    double d3 = Math.max(bounds2.getHeight(), d2);
                    this.value = DCFactory.eINSTANCE.createDimension(bounds2.getWidth(), d3);
                }
            }
            if (this.value instanceof Dimension) {
                bounds2 = this.applyBounds(bounds, DGSetSizeHelper.innerizeText((Dimension)this.value));
                this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)text, (EReference)DGPackage.Literals.TEXT__BOUNDS, (EObject)bounds2, (EObject)bounds));
                this.applyAccessor((EObject)text, DGPackage.Literals.TEXT__BOUNDS, bounds2);
            }
        }
        return (Command)super.caseText(text);
    }

    protected Bounds applyBounds(Bounds bounds, Dimension dimension) {
        double d = bounds.getX();
        double d2 = bounds.getY();
        double d3 = dimension.getWidth();
        double d4 = dimension.getHeight();
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }

    protected Dimension calculateImageSize(Image image) {
        SwingImageAdapter swingImageAdapter = SwingImageAdapter.getInstance((Notifier)image);
        CImageIcon cImageIcon = swingImageAdapter.getImage();
        if (cImageIcon != null) {
            double d = cImageIcon.getIconWidth();
            double d2 = cImageIcon.getIconHeight();
            if (d >= 0.0 && d2 >= 0.0) {
                return DCFactory.eINSTANCE.createDimension(d, d2);
            }
        }
        return null;
    }

    public static Dimension calculateTextSize(Font font, String string, double d, double d2) {
        double d3 = Math.max(d, DGSetSizeHelper.getDefaultTextWidth(font, string));
        double d4 = Math.max(d2, DGSetSizeHelper.getDefaultTextHeight(font, string));
        return DCFactory.eINSTANCE.createDimension(d3, d4);
    }

    public static double getCornerRadius(Bounds bounds) {
        double d = bounds.getX();
        double d2 = bounds.getY();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        return new RoundRectangle2d(d, d2, d3, d4).getArcWidth();
    }

    public static double getDefaultTextWidth(Font font, String string) {
        double d = DGSetSizeHelper.getRawTextWidth(font, string);
        return 10.0 + d + 10.0;
    }

    public static double getDefaultTextHeight(Font font, String string) {
        double d = DGSetSizeHelper.getRawTextHeight(font, string);
        return 4.0 + d + 4.0;
    }

    public static double getWrappedTextHeight(Font font, String string, double d) {
        double d2 = GolfUtilities.computeMultiLineStringHeight((Font)font, (String)string, (double)d, (double)0.0);
        return 4.0 + d2 + 4.0;
    }

    public static Bounds innerizeText(Bounds bounds) {
        double d = bounds.getX() + 10.0;
        double d2 = bounds.getY() + 4.0;
        double d3 = bounds.getWidth() - 20.0 + 2.0;
        double d4 = bounds.getHeight() - 4.0 - 4.0;
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }

    public static Point innerizeText(Point point) {
        double d = point.getX() + 10.0;
        double d2 = point.getY() + 4.0;
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    public static Dimension innerizeText(Dimension dimension) {
        double d = dimension.getWidth() - 20.0 + 2.0;
        double d2 = dimension.getHeight() - 4.0 - 4.0;
        return DCFactory.eINSTANCE.createDimension(d, d2);
    }

    private static Dimension a(Font font, Dimension dimension) {
        double d = DGSetSizeHelper.getRawTextWidth(font, "m");
        double d2 = DGSetSizeHelper.getRawTextHeight(font, "m");
        Dimension dimension2 = DGSetSizeHelper.innerizeText(dimension);
        if (dimension2.getWidth() < d || dimension2.getHeight() < d2) {
            double d3 = dimension.getWidth();
            double d4 = dimension.getHeight();
            if (dimension2.getWidth() < d) {
                d3 -= dimension2.getWidth() - d;
            }
            if (dimension2.getHeight() < d2) {
                d4 -= dimension2.getHeight() - d2;
            }
            return DCFactory.eINSTANCE.createDimension(d3, d4);
        }
        return dimension;
    }

    public static double getRawTextWidth(Font font, String string) {
        double d = 0.0;
        for (String string2 : Splitter.on((char)'\n').split((CharSequence)string)) {
            double d2 = JomtFontUtilities.computeStringWidth((Font)font, (String)string2);
            d = Math.max(d, d2);
        }
        return d;
    }

    public static double getRawTextHeight(Font font, String string) {
        double d = JomtFontUtilities.computeStringHeight((Font)font, (String)"m");
        int n = Iterables.size((Iterable)Splitter.on((char)'\n').split((CharSequence)string));
        return (d + 0.0) * (double)n - 0.0;
    }

    public static Font getFont(GraphicalElement graphicalElement) {
        if (DGSetSizeHelper.b(graphicalElement)) {
            return DGSetSizeHelper.a(graphicalElement);
        }
        return JomtFontUtilities.getProjectFont();
    }

    private static Font a(GraphicalElement graphicalElement) {
        DGStyleResolver dGStyleResolver = DGStyleResolver.getInstance((EObject)graphicalElement);
        String string = dGStyleResolver.resolveFontName(graphicalElement);
        int n = (dGStyleResolver.resolveFontBold(graphicalElement) ? 1 : 0) | (dGStyleResolver.resolveFontItalic(graphicalElement) ? 2 : 0);
        int n2 = (int)dGStyleResolver.resolveFontSize(graphicalElement);
        return new Font(string, n, n2);
    }

    private static boolean b(GraphicalElement graphicalElement) {
        return graphicalElement != null && (graphicalElement.getLocalStyles() != null && !graphicalElement.getLocalStyles().isEmpty() || graphicalElement.getSharedStyles() != null && !graphicalElement.getSharedStyles().isEmpty());
    }

    protected Dimension correctCommonMinimum(Dimension dimension) {
        return this.correctCommonMinimum(dimension, null);
    }

    protected Dimension correctCommonMinimum(Dimension dimension, Dimension dimension2) {
        double d = 10.0;
        double d2 = 10.0;
        if (dimension2 != null) {
            d = Math.min(d, dimension2.getWidth());
            d2 = Math.min(d2, dimension2.getHeight());
        }
        return DCFactory.eINSTANCE.createDimension(Math.max(dimension.getWidth(), d), Math.max(dimension.getHeight(), d2));
    }
}

