/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.emf.edit.command.DataTypeCommands;
import net.astah.notation.NotationFactory;
import net.astah.notation.Vector;
import net.astah.notation.provider.graphics.DGGeometryProviderHelper;
import net.astah.notation.provider.graphics.DGGetBoundsHelper;
import net.astah.notation.provider.graphics.DGLayoutHelper;
import net.astah.notation.provider.graphics.DGMoveLocationHelper;
import net.astah.notation.provider.graphics.DGSetSizeHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DGSetLocationHelper
extends DGLayoutHelper {
    public DGSetLocationHelper(EditingDomain editingDomain, Object object, Object object2) {
        super(editingDomain, object, object2);
    }

    public Command caseEllipse(Ellipse ellipse) {
        Command command = this.delegateToMove((EObject)ellipse);
        if (command != null) {
            return command;
        }
        return (Command)super.caseEllipse(ellipse);
    }

    public Command caseImage(Image image) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(image, this.getAccessor());
        this.command.append(this.eChangeBounds((EObject)image, DGPackage.Literals.IMAGE__BOUNDS, bounds));
        return (Command)super.caseImage(image);
    }

    public Command caseLine(Line line) {
        Command command = this.delegateToMove((EObject)line);
        if (command != null) {
            this.command.append(command);
        }
        return (Command)super.caseLine(line);
    }

    public Command casePolyline(Polyline polyline) {
        Command command = this.delegateToMove((EObject)polyline);
        if (command != null) {
            this.command.append(command);
        }
        return (Command)super.casePolyline(polyline);
    }

    public Command caseRectangle(Rectangle rectangle) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(rectangle, this.getAccessor());
        this.command.append(this.eChangeBounds((EObject)rectangle, DGPackage.Literals.RECTANGLE__BOUNDS, bounds));
        return (Command)super.caseRectangle(rectangle);
    }

    public Command caseText(Text text) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(text, this.getAccessor());
        if (bounds != null && this.value instanceof Point) {
            Point point = DGSetSizeHelper.innerizeText((Point)this.value);
            double d = point.getX();
            double d2 = point.getY();
            double d3 = bounds.getWidth();
            double d4 = bounds.getHeight();
            Bounds bounds2 = DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
            this.applyAccessor((EObject)text, DGPackage.Literals.TEXT__BOUNDS, bounds2);
            this.command.append(DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)text, (EReference)DGPackage.Literals.TEXT__BOUNDS, (EObject)bounds2, (EObject)bounds));
        }
        return (Command)super.caseText(text);
    }

    protected Command eChangeBounds(EObject eObject, EReference eReference, Bounds bounds) {
        if (bounds != null && this.value instanceof Point) {
            Bounds bounds2 = this.applyBounds(bounds, (Point)this.value);
            this.applyAccessor(eObject, eReference, bounds2);
            return DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)eObject, (EReference)eReference, (EObject)bounds2, (EObject)bounds);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Bounds applyBounds(Bounds bounds, Point point) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }

    protected Command delegateToMove(EObject eObject) {
        Bounds bounds;
        if (this.value instanceof Point && (bounds = DGGetBoundsHelper.INSTANCE.doSwitch(eObject, this.getAccessor())) != null) {
            Point point = (Point)this.value;
            double d = point.getX() - bounds.getX();
            double d2 = point.getY() - bounds.getY();
            Vector vector = NotationFactory.eINSTANCE.createVector(d, d2);
            return new DGMoveLocationHelper(this.domain, this.context, vector).create(eObject);
        }
        return null;
    }
}

