/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import com.google.common.collect.Iterables;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.emf.edit.command.DataTypeCommands;
import net.astah.notation.Vector;
import net.astah.notation.provider.graphics.DGGeometryProviderHelper;
import net.astah.notation.provider.graphics.DGLayoutHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DGMoveLocationHelper
extends DGLayoutHelper {
    public DGMoveLocationHelper(EditingDomain editingDomain, Object object, Object object2) {
        super(editingDomain, object, object2);
    }

    public Command caseEllipse(Ellipse ellipse) {
        Point point = DGGeometryProviderHelper.getCenter(ellipse, this.getAccessor());
        this.command.append(this.eChangePoint((EObject)ellipse, DGPackage.Literals.ELLIPSE__CENTER, point));
        return (Command)super.caseEllipse(ellipse);
    }

    public Command caseImage(Image image) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(image, this.getAccessor());
        this.command.append(this.eChangeBounds((EObject)image, DGPackage.Literals.IMAGE__BOUNDS, bounds));
        return (Command)super.caseImage(image);
    }

    public Command caseLine(Line line) {
        Point point = DGGeometryProviderHelper.getStart(line, this.getAccessor());
        Point point2 = DGGeometryProviderHelper.getEnd(line, this.getAccessor());
        this.command.append(this.eChangePoint((EObject)line, DGPackage.Literals.LINE__START, point));
        this.command.append(this.eChangePoint((EObject)line, DGPackage.Literals.LINE__END, point2));
        return (Command)super.caseLine(line);
    }

    public Command casePolyline(Polyline polyline) {
        List<Point> list = DGGeometryProviderHelper.getPoints(polyline, this.getAccessor());
        this.command.append(this.eChangeAllPoint((EObject)polyline, DGPackage.Literals.POLYLINE__POINT, list));
        return (Command)super.casePolyline(polyline);
    }

    public Command caseRectangle(Rectangle rectangle) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(rectangle, this.getAccessor());
        this.command.append(this.eChangeBounds((EObject)rectangle, DGPackage.Literals.RECTANGLE__BOUNDS, bounds));
        return (Command)super.caseRectangle(rectangle);
    }

    public Command caseText(Text text) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(text, this.getAccessor());
        this.command.append(this.eChangeBounds((EObject)text, DGPackage.Literals.TEXT__BOUNDS, bounds));
        return (Command)super.caseText(text);
    }

    protected Command eChangePoint(EObject eObject, EReference eReference, Point point) {
        if (point != null && this.value instanceof Vector) {
            Point point2 = this.applyPoint(point, (Vector)this.value);
            this.applyAccessor(eObject, eReference, point2);
            return DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)eObject, (EReference)eReference, (EObject)point2, (EObject)point);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command eChangeBounds(EObject eObject, EReference eReference, Bounds bounds) {
        if (bounds != null && this.value instanceof Vector) {
            Bounds bounds2 = this.applyBounds(bounds, (Vector)this.value);
            this.applyAccessor(eObject, eReference, bounds2);
            return DataTypeCommands.eChange((EditingDomain)this.domain, (EObject)eObject, (EReference)eReference, (EObject)bounds2, (EObject)bounds);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command eChangeAllPoint(EObject eObject, EReference eReference, List<Point> list) {
        if (this.value instanceof Vector) {
            Vector vector = (Vector)this.value;
            Iterable iterable = Iterables.transform(list, point -> this.applyPoint((Point)point, vector));
            this.applyAccessor(eObject, eReference, iterable);
            return DataTypeCommands.eChangeAll((EditingDomain)this.domain, (EObject)eObject, (EReference)eReference, (Iterable)iterable, list);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Point applyPoint(Point point, Vector vector) {
        double d = point.getX() + vector.getX();
        double d2 = point.getY() + vector.getY();
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    protected Bounds applyBounds(Bounds bounds, Vector vector) {
        double d = bounds.getX() + vector.getX();
        double d2 = bounds.getY() + vector.getY();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }
}

