/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.dc.util.DCUtil;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGSwitch;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.notation.provider.graphics.DGGeometryProviderHelper;
import org.eclipse.emf.ecore.EObject;

public class DGGetBoundsHelper
extends DGSwitch<Bounds> {
    public static DGGetBoundsHelper INSTANCE = new DGGetBoundsHelper();
    private FeatureAccessor a;

    public Bounds doSwitch(EObject eObject) {
        return this.doSwitch(eObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds doSwitch(EObject eObject, FeatureAccessor featureAccessor) {
        Bounds bounds;
        FeatureAccessor featureAccessor2 = this.a;
        this.a = featureAccessor;
        try {
            bounds = (Bounds)super.doSwitch(eObject);
        }
        finally {
            this.a = featureAccessor2;
        }
        return bounds;
    }

    protected FeatureAccessor getAccessor() {
        return this.a;
    }

    public Bounds caseGroup(Group group) {
        Bounds bounds = null;
        for (GraphicalElement graphicalElement : group.getMembers()) {
            Bounds bounds2 = (Bounds)super.doSwitch((EObject)graphicalElement);
            if (bounds2 == null) continue;
            if (bounds == null) {
                bounds = bounds2;
                continue;
            }
            bounds = DCUtil.add((Bounds)bounds, (Bounds)bounds2);
        }
        return bounds;
    }

    public Bounds caseEllipse(Ellipse ellipse) {
        Point point = DGGeometryProviderHelper.getCenter(ellipse, this.getAccessor());
        Dimension dimension = DGGeometryProviderHelper.getRadii(ellipse, this.getAccessor());
        double d = point.getX() - dimension.getWidth();
        double d2 = point.getY() - dimension.getHeight();
        double d3 = dimension.getWidth() * 2.0;
        double d4 = dimension.getHeight() * 2.0;
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }

    public Bounds caseImage(Image image) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(image, this.getAccessor());
        return DCFactory.eINSTANCE.createBounds(bounds);
    }

    public Bounds caseLine(Line line) {
        Point point = DGGeometryProviderHelper.getStart(line, this.getAccessor());
        Point point2 = DGGeometryProviderHelper.getEnd(line, this.getAccessor());
        double d = Math.min(point.getX(), point2.getX());
        double d2 = Math.min(point.getY(), point2.getY());
        double d3 = Math.max(point.getX(), point2.getX());
        double d4 = Math.max(point.getY(), point2.getY());
        return DCFactory.eINSTANCE.createBounds(d, d2, d3 - d, d4 - d2);
    }

    public Bounds casePolyline(Polyline polyline) {
        List<Point> list = DGGeometryProviderHelper.getPoints(polyline, this.getAccessor());
        return DGGetBoundsHelper.getBounds(list);
    }

    public Bounds caseRectangle(Rectangle rectangle) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(rectangle, this.getAccessor());
        return DCFactory.eINSTANCE.createBounds(bounds);
    }

    public Bounds caseText(Text text) {
        Bounds bounds = DGGeometryProviderHelper.getBounds(text, this.getAccessor());
        double d = bounds.getX() - 10.0;
        double d2 = bounds.getY() - 4.0;
        double d3 = bounds.getWidth() + 20.0 - 2.0;
        double d4 = bounds.getHeight() + 4.0 + 4.0;
        return DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
    }

    public static Bounds getBounds(Iterable<Point> iterable) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (Point point : iterable) {
            d = Math.min(d, point.getX());
            d2 = Math.min(d2, point.getY());
            d3 = Math.max(d3, point.getX());
            d4 = Math.max(d4, point.getY());
        }
        return DCFactory.eINSTANCE.createBounds(d, d2, d3 - d, d4 - d2);
    }
}

