/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider.graphics;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Image;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.notation.provider.GeometryProviderHelper;
import net.astah.notation.provider.graphics.DGGetBoundsHelper;
import net.astah.notation.provider.graphics.DGGetImageAspectRatioPreservedHelper;
import net.astah.notation.provider.graphics.DGGetImageSourceHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DGGeometryProviderHelper {
    public static Bounds getBoundsOn(GraphicalElement graphicalElement, Point point, LayoutCalculator layoutCalculator) {
        Bounds bounds = DGGetBoundsHelper.INSTANCE.doSwitch((EObject)graphicalElement, layoutCalculator.getFeatureAccessor());
        if (bounds != null) {
            return LayoutCalculator.translate((Bounds)bounds, (Point)point);
        }
        return null;
    }

    public static Point getLocationOn(GraphicalElement graphicalElement, Point point, LayoutCalculator layoutCalculator) {
        Bounds bounds = DGGetBoundsHelper.INSTANCE.doSwitch((EObject)graphicalElement, layoutCalculator.getFeatureAccessor());
        if (bounds != null) {
            return GeometryProviderHelper.getBoundsPoint(bounds, point);
        }
        return null;
    }

    public static Dimension getBoundsSize(GraphicalElement graphicalElement, LayoutCalculator layoutCalculator) {
        Bounds bounds = DGGeometryProviderHelper.getBoundsOn(graphicalElement, null, layoutCalculator);
        if (bounds != null) {
            return GeometryProviderHelper.getBoundsDimension(bounds);
        }
        return null;
    }

    public static URI getImageSource(GraphicalElement graphicalElement) {
        return (URI)DGGetImageSourceHelper.INSTANCE.doSwitch((EObject)graphicalElement);
    }

    public static boolean getImageAspectRatioPreserved(GraphicalElement graphicalElement) {
        return (Boolean)DGGetImageAspectRatioPreservedHelper.INSTANCE.doSwitch((EObject)graphicalElement);
    }

    public static Point getCenter(Ellipse ellipse, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)ellipse, (EStructuralFeature)DGPackage.Literals.ELLIPSE__CENTER, Point.class, featureAccessor);
    }

    public static Dimension getRadii(Ellipse ellipse, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)ellipse, (EStructuralFeature)DGPackage.Literals.ELLIPSE__RADII, Dimension.class, featureAccessor);
    }

    public static Bounds getBounds(Image image, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)image, (EStructuralFeature)DGPackage.Literals.IMAGE__BOUNDS, Bounds.class, featureAccessor);
    }

    public static Point getStart(Line line, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)line, (EStructuralFeature)DGPackage.Literals.LINE__START, Point.class, featureAccessor);
    }

    public static Point getEnd(Line line, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)line, (EStructuralFeature)DGPackage.Literals.LINE__END, Point.class, featureAccessor);
    }

    public static List<Point> getPoints(Polyline polyline, FeatureAccessor featureAccessor) {
        Iterable iterable = DGGeometryProviderHelper.a((EObject)polyline, (EStructuralFeature)DGPackage.Literals.POLYLINE__POINT, Iterable.class, featureAccessor);
        if (iterable == null) {
            return null;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Iterables.addAll(arrayList, (Iterable)Iterables.filter((Iterable)iterable, Point.class));
        return arrayList;
    }

    public static Bounds getBounds(Rectangle rectangle, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)rectangle, (EStructuralFeature)DGPackage.Literals.RECTANGLE__BOUNDS, Bounds.class, featureAccessor);
    }

    public static Bounds getBounds(Text text, FeatureAccessor featureAccessor) {
        return DGGeometryProviderHelper.a((EObject)text, (EStructuralFeature)DGPackage.Literals.TEXT__BOUNDS, Bounds.class, featureAccessor);
    }

    private static <T> T a(@NonNull EObject eObject, @NonNull EStructuralFeature eStructuralFeature, @NonNull Class<T> clazz, FeatureAccessor featureAccessor) {
        Object object;
        if (eObject == null) {
            throw new NullPointerException("owner");
        }
        if (eStructuralFeature == null) {
            throw new NullPointerException("feature");
        }
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        Object object2 = object = featureAccessor != null ? featureAccessor.get((Object)eObject, (Object)eStructuralFeature) : null;
        if (object == null && eObject.eClass().getEAllStructuralFeatures().contains((Object)eStructuralFeature)) {
            return clazz.cast(eObject.eGet(eStructuralFeature));
        }
        return (T)FeatureAccessor.actualValue((Object)object, clazz);
    }
}

