/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dg.DGPackage;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jutil.JFont;
import net.astah.model.extension.Preferences;
import net.astah.notation.NotationPackage;
import net.astah.notation.Style;
import net.astah.project.Facet;
import net.astah.project.Project;
import net.astah.project.ProjectFactory;
import net.astah.project.StylePreferenceContainer;
import net.astah.project.StylePreferences;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;

public class StylePreferencesHelper {
    public static final URI SYSTEM_RESOURCE_URI = URI.createURI((String)"pathmap://SYSTEM_PROPERTY/style");
    private static final String a = "default.font.name";
    private static final String b = "default.font.style";
    private static final String c = "default.font.size";
    private static final String d = "font_style";
    private static final String e = "fill_color";
    private static final String f = "fill_opacity";
    private static final String g = "font_bold";
    private static final String h = "font_color";
    private static final String i = "font_italic";
    private static final String j = "font_name";
    private static final String k = "font_opacity";
    private static final String l = "font_size";
    private static final String m = "font_strike_through";
    private static final String n = "font_underline";
    private static final String o = "stroke_color";
    private static final String p = "stroke_dash_length";
    private static final String q = "stroke_opacity";
    private static final String r = "stroke_width";
    private static final String s = "stroke_pattern";
    public static StylePreferencesHelper INSTANCE = new StylePreferencesHelper();
    private final Map<String, EStructuralFeature> t = new HashMap<String, EStructuralFeature>();
    private final Map<String, EStructuralFeature> u;

    private StylePreferencesHelper() {
        this.t.put(e, (EStructuralFeature)NotationPackage.Literals.STYLE__FILL_COLOR);
        this.t.put(f, (EStructuralFeature)NotationPackage.Literals.STYLE__FILL_OPACITY);
        this.t.put(g, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_BOLD);
        this.t.put(h, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_COLOR);
        this.t.put(i, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_ITALIC);
        this.t.put(j, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_NAME);
        this.t.put(k, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_OPACITY);
        this.t.put(l, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_SIZE);
        this.t.put(m, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_STRIKE_THROUGH);
        this.t.put(n, (EStructuralFeature)NotationPackage.Literals.STYLE__FONT_UNDERLINE);
        this.t.put(o, (EStructuralFeature)NotationPackage.Literals.STYLE__STROKE_COLOR);
        this.t.put(p, (EStructuralFeature)NotationPackage.Literals.STYLE__STROKE_DASH_LENGTH);
        this.t.put(q, (EStructuralFeature)NotationPackage.Literals.STYLE__STROKE_OPACITY);
        this.t.put(r, (EStructuralFeature)NotationPackage.Literals.STYLE__STROKE_WIDTH);
        this.t.put(s, (EStructuralFeature)NotationPackage.Literals.STYLE__STROKE_DASH_LENGTH);
        this.u = new HashMap<String, EStructuralFeature>();
        this.u.put(e, (EStructuralFeature)DGPackage.Literals.STYLE__FILL_COLOR);
        this.u.put(f, (EStructuralFeature)DGPackage.Literals.STYLE__FILL_OPACITY);
        this.u.put(g, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_BOLD);
        this.u.put(h, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_COLOR);
        this.u.put(i, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_ITALIC);
        this.u.put(j, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_NAME);
        this.u.put(l, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_SIZE);
        this.u.put(m, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_STRIKE_THROUGH);
        this.u.put(n, (EStructuralFeature)DGPackage.Literals.STYLE__FONT_UNDERLINE);
        this.u.put(o, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_COLOR);
        this.u.put(p, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_DASH_LENGTH);
        this.u.put(q, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_OPACITY);
        this.u.put(r, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_WIDTH);
        this.u.put(s, (EStructuralFeature)DGPackage.Literals.STYLE__STROKE_DASH_LENGTH);
    }

    public StylePreferences getSystemStylePreferences() {
        EObject eObject = (EObject)Iterables.getFirst((Iterable)RuntimeGlobal.systemPropertyStyleResource.getContents(), null);
        if (eObject != null) {
            return (StylePreferences)eObject;
        }
        return null;
    }

    public boolean isStyleKey(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return this.a(string) || this.t.containsKey(this.b(string));
        }
        return false;
    }

    private boolean a(String string) {
        return string.equals(a) || string.equals(b) || string.equals(c);
    }

    public EStructuralFeature getNotationStyleFeature(String string) {
        if (this.t.containsKey(string)) {
            return this.t.get(this.b(string));
        }
        return NotationPackage.Literals.STYLE__FILL_COLOR;
    }

    public EStructuralFeature getDGStyleFeature(String string) {
        if (this.u.containsKey(string)) {
            return this.u.get(this.b(string));
        }
        return DGPackage.Literals.STYLE__FILL_COLOR;
    }

    public void setStyleAttribute(EObject eObject, String string, Object object) {
        String string2 = this.b(string);
        Object object2 = this.a(string2, object);
        if (object2 != null) {
            if (string2.equals(d)) {
                String string3 = (String)object2;
                boolean bl = string3.contains("BOLD");
                boolean bl2 = string3.contains("ITALIC");
                eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_BOLD, (Object)bl);
                eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_ITALIC, (Object)bl2);
            } else if (eObject instanceof Style) {
                EStructuralFeature eStructuralFeature = this.getNotationStyleFeature(string2);
                if (this.a(eStructuralFeature, object2)) {
                    eObject.eUnset(eStructuralFeature);
                } else {
                    eObject.eSet(eStructuralFeature, object2);
                }
            } else if (eObject instanceof net.astah.dd.dg.Style) {
                EStructuralFeature eStructuralFeature = this.getDGStyleFeature(string2);
                if (this.a(eStructuralFeature, object2)) {
                    eObject.eUnset(eStructuralFeature);
                } else {
                    eObject.eSet(eStructuralFeature, object2);
                }
            }
        }
    }

    private Object a(String string, Object object) {
        switch (string) {
            case "fill_color": 
            case "font_color": 
            case "stroke_color": {
                if (!(object instanceof Color)) {
                    SwingColor swingColor = new SwingColor(Color.decode((String)object));
                    return DCFactory.eINSTANCE.createColor(swingColor.getRGB());
                }
                return DCFactory.eINSTANCE.createColor(((Color)object).getRGB());
            }
            case "stroke_pattern": {
                String string2 = (String)object;
                if ("Dashed".equals(string2)) {
                    return new BasicEList((Collection)Lists.newArrayList((Object[])new Double[]{5.0, 5.0}));
                }
                if ("Solid".equals(string2)) {
                    return Collections.emptyList();
                }
                return null;
            }
            case "fill_opacity": 
            case "font_opacity": 
            case "stroke_opacity": 
            case "stroke_width": 
            case "font_size": {
                return Double.parseDouble((String)object);
            }
            case "font_bold": 
            case "font_italic": 
            case "font_strike_through": 
            case "font_underline": {
                return Boolean.parseBoolean((String)object);
            }
        }
        if (object instanceof String && ((String)object).startsWith("#")) {
            SwingColor swingColor = new SwingColor(Color.decode((String)object));
            return DCFactory.eINSTANCE.createColor(swingColor.getRGB());
        }
        if (object instanceof Color) {
            return DCFactory.eINSTANCE.createColor(((Color)object).getRGB());
        }
        return object;
    }

    public String getParentKey(String string) {
        String string2 = string;
        if (string2.contains(".")) {
            if (string2.endsWith("selected")) {
                string2 = string2.substring(0, string2.lastIndexOf("."));
            }
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        return string2;
    }

    private String b(String string) {
        String string2 = string;
        if (this.a(string)) {
            switch (string) {
                case "default.font.name": {
                    return j;
                }
                case "default.font.size": {
                    return l;
                }
                case "default.font.style": {
                    return d;
                }
            }
            return string;
        }
        if (string2.contains(".")) {
            if (string2.endsWith("selected")) {
                string2 = string2.substring(0, string2.lastIndexOf("."));
            }
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
        }
        if (this.t.containsKey(string2)) {
            return string2;
        }
        return string;
    }

    public void applyStylePreferences(Project project, Preferences preferences) {
        JFont jFont = StyleSupport.getJFontWithAuto((Preferences)project.getPreferences());
        String string = jFont.getFontStyle();
        EObject eObject = this.prepareStyle((StylePreferenceContainer)project, "font", NotationPackage.Literals.STYLE);
        eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_NAME, (Object)jFont.getFontName());
        eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_SIZE, (Object)jFont.getFontSize());
        eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_BOLD, (Object)string.contains("BOLD"));
        eObject.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_ITALIC, (Object)string.contains("ITALIC"));
        EObject eObject2 = this.prepareStyle((StylePreferenceContainer)project, "common_figure.font", DGPackage.Literals.STYLE);
        eObject2.eSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_NAME, (Object)jFont.getFontName());
        eObject2.eSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_SIZE, (Object)jFont.getFontSize());
        eObject2.eSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_BOLD, (Object)string.contains("BOLD"));
        eObject2.eSet((EStructuralFeature)DGPackage.Literals.STYLE__FONT_ITALIC, (Object)string.contains("ITALIC"));
        Color color = this.getColor(this.a(preferences, "other.color.common"));
        if (color != null) {
            EObject eObject3 = this.prepareStyle((StylePreferenceContainer)project, "common_figure", DGPackage.Literals.STYLE);
            eObject3.eSet((EStructuralFeature)DGPackage.Literals.STYLE__FILL_COLOR, (Object)DCFactory.eINSTANCE.createColor(color.getRGB()));
        }
        for (String string2 : RuntimeGlobal.sysProp.getKeys()) {
            Object object;
            String string3;
            Facet facet;
            if (!this.isStyleKey(string2) || this.a(string2)) continue;
            String string4 = this.getParentKey(string2);
            Project project2 = project;
            int n = string4.indexOf(46);
            if (n >= 0 && (facet = project.getFacet(string3 = RuntimeGlobal.sysProp.getDefaultString((String)(object = string4.substring(0, n) + ".facet")))) != null) {
                project2 = facet;
                string4 = string4.substring(n + 1);
            }
            object = this.prepareStyle((StylePreferenceContainer)project2, string4, NotationPackage.Literals.STYLE);
            this.setStyleAttribute((EObject)object, string2, this.a(preferences, string2));
        }
    }

    protected EObject prepareStyle(StylePreferenceContainer stylePreferenceContainer, String string, EClass eClass) {
        StylePreferences stylePreferences = this.prepareStylePreferences(stylePreferenceContainer);
        EObject eObject = stylePreferences.getStyle(string);
        if (!eClass.isInstance((Object)eObject)) {
            eObject = EcoreUtil.create((EClass)eClass);
            stylePreferences.putStyle(string, eObject);
        }
        return eObject;
    }

    protected StylePreferences prepareStylePreferences(StylePreferenceContainer stylePreferenceContainer) {
        StylePreferences stylePreferences = stylePreferenceContainer.getStylePreferences();
        if (stylePreferences == null) {
            stylePreferences = ProjectFactory.eINSTANCE.createStylePreferences();
            Project project = (Project)EObjects.getAncestor(Project.class, (EObject)stylePreferenceContainer);
            ResourceSet resourceSet = project.eResource().getResourceSet();
            Resource resource = ResourceSets.getOrCreateResource((ResourceSet)resourceSet, (URI)project.createResourceURI("style.axmi"), (String)"");
            resource.getContents().add((Object)stylePreferences);
            stylePreferenceContainer.setStylePreferences(stylePreferences);
        }
        ItemProviders.adapt((EObject)stylePreferences, IEditingDomainItemProvider.class);
        return stylePreferences;
    }

    protected Color getColor(Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        if (object instanceof String) {
            try {
                return Color.decode((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    Object a(Preferences preferences, String string) {
        String string2;
        if (preferences != null && (string2 = preferences.getStringValue(string)) != null) {
            return string2;
        }
        return RuntimeGlobal.sysProp.getWithDefault(string);
    }

    boolean a(EStructuralFeature eStructuralFeature, Object object) {
        if (eStructuralFeature.isMany()) {
            return ((List)object).isEmpty();
        }
        return object == null;
    }
}

