/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import java.awt.Color;
import java.awt.Font;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.di.DIPackage;
import net.astah.emf.edit.provider.swing.ColorURIResolver;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.Style;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetStyleHelper {
    public static SetStyleHelper INSTANCE = new SetStyleHelper();

    public Command applyFillColor(EditingDomain editingDomain, Object object, EObject eObject, Object object2) {
        return this.applyColor(editingDomain, eObject, object2, NotationPackage.Literals.STYLE__FILL_COLOR, NotationPackage.Literals.STYLE__FILL_OPACITY);
    }

    public Command applyStrokeColor(EditingDomain editingDomain, Object object, EObject eObject, Object object2) {
        return this.applyColor(editingDomain, eObject, object2, NotationPackage.Literals.STYLE__STROKE_COLOR, NotationPackage.Literals.STYLE__STROKE_OPACITY);
    }

    public Command applyFontColor(EditingDomain editingDomain, Object object, EObject eObject, Object object2) {
        return this.applyColor(editingDomain, eObject, object2, NotationPackage.Literals.STYLE__FONT_COLOR, NotationPackage.Literals.STYLE__FONT_OPACITY);
    }

    public Command applyFont(EditingDomain editingDomain, Object object, EObject eObject, Object object2) {
        if (object2 instanceof URI) {
            return this.applyFontURI(editingDomain, eObject, (URI)object2);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command applyColor(EditingDomain editingDomain, EObject eObject, Object object, EReference eReference, EAttribute eAttribute) {
        if (object instanceof URI) {
            return this.applyColorURI(editingDomain, eObject, eReference, eAttribute, (URI)object);
        }
        if (object instanceof net.astah.dd.dc.Color) {
            return this.applyColor(editingDomain, eObject, eReference, eAttribute, (net.astah.dd.dc.Color)object, 1.0);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command applyColorURI(EditingDomain editingDomain, EObject eObject, EReference eReference, EAttribute eAttribute, URI uRI) {
        Color color = new ColorURIResolver(null, null).resolve(uRI);
        net.astah.dd.dc.Color color2 = DCFactory.eINSTANCE.createColor(color.getRGB());
        double d = (double)color.getAlpha() / 255.0;
        return this.applyColor(editingDomain, eObject, eReference, eAttribute, color2, d);
    }

    protected Command applyColor(EditingDomain editingDomain, EObject eObject, EReference eReference, EAttribute eAttribute, net.astah.dd.dc.Color color, double d) {
        if (eObject.eIsSet((EStructuralFeature)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE)) {
            Object object = eObject.eGet((EStructuralFeature)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE);
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eReference, (Object)color));
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eAttribute, (Object)d));
            return compoundCommand.unwrap();
        }
        Style style = NotationFactory.eINSTANCE.createStyle();
        style.eSet((EStructuralFeature)eReference, (Object)color);
        style.eSet((EStructuralFeature)eAttribute, (Object)d);
        return SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE, (Object)style);
    }

    protected Command applyFontURI(EditingDomain editingDomain, EObject eObject, URI uRI) {
        Font font = new FontURIResolver(null).resolve(uRI);
        String string = font.getName();
        double d = font.getSize2D();
        boolean bl = font.isBold();
        boolean bl2 = font.isItalic();
        if (eObject.eIsSet((EStructuralFeature)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE)) {
            Object object = eObject.eGet((EStructuralFeature)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE);
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)NotationPackage.Literals.STYLE__FONT_NAME, (Object)string));
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)NotationPackage.Literals.STYLE__FONT_SIZE, (Object)d));
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)NotationPackage.Literals.STYLE__FONT_BOLD, (Object)bl));
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)object, (Object)NotationPackage.Literals.STYLE__FONT_ITALIC, (Object)bl2));
            return compoundCommand.unwrap();
        }
        Style style = NotationFactory.eINSTANCE.createStyle();
        style.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_NAME, (Object)string);
        style.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_SIZE, (Object)d);
        style.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_BOLD, (Object)bl);
        style.eSet((EStructuralFeature)NotationPackage.Literals.STYLE__FONT_ITALIC, (Object)bl2);
        return SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__LOCAL_STYLE, (Object)style);
    }
}

