/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import net.astah.dd.dc.Color;
import org.eclipse.emf.common.util.URI;

public class NotationStyles {
    public static URI createColorURI(Color color, double d) {
        if (d >= 1.0) {
            return NotationStyles.createRGBColorURI(color.getRed(), color.getGreen(), color.getBlue());
        }
        int n = (int)(255.0 * Math.max(d, 0.0));
        return NotationStyles.createRGBAColorURI(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static URI createRGBColorURI(int n, int n2, int n3) {
        return URI.createURI((String)("color://rgb/" + n + "/" + n2 + "/" + n3));
    }

    public static URI createRGBAColorURI(int n, int n2, int n3, int n4) {
        return URI.createURI((String)("color://rgba/" + n + "/" + n2 + "/" + n3 + "/" + n4));
    }

    public static URI createFontURI(String string, double d, boolean bl, boolean bl2) {
        String string2 = NotationStyles.createFontStyleSegment(bl, bl2);
        return URI.createURI((String)("font://" + string + "/" + d + "/" + string2));
    }

    public static String createFontStyleSegment(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return "bold+italic";
        }
        if (bl) {
            return "bold";
        }
        if (bl2) {
            return "italic";
        }
        return "normal";
    }
}

