/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import com.google.common.collect.Iterables;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.DCPackage;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.MoveLocationCommand;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.notation.Location;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.provider.LayoutHelper;
import net.astah.notation.provider.NormalizeEdgeOwnerHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class MoveLocationHelper
extends LayoutHelper {
    public static MoveLocationHelper INSTANCE = new MoveLocationHelper();

    @Override
    protected EObject apply(EClass eClass, EObject eObject, Object object) {
        if (object instanceof Vector) {
            return this.applyVector(eClass, eObject, (Vector)object);
        }
        return null;
    }

    @Override
    protected EObject create(EClass eClass, Object object) {
        if (eClass.isSuperTypeOf(NotationPackage.Literals.LOCATION) && object instanceof Vector) {
            Vector vector = (Vector)object;
            double d = vector.getX();
            double d2 = vector.getY();
            return NotationFactory.eINSTANCE.createLocation(d, d2);
        }
        if (eClass.isSuperTypeOf(DCPackage.Literals.POINT) && object instanceof Vector) {
            Vector vector = (Vector)object;
            double d = vector.getX();
            double d3 = vector.getY();
            return DCFactory.eINSTANCE.createPoint(d, d3);
        }
        return null;
    }

    protected EObject applyVector(EClass eClass, EObject eObject, Vector vector) {
        Location location = (Location)eObject;
        double d = location.getX() + vector.getX();
        double d2 = location.getY() + vector.getY();
        return NotationFactory.eINSTANCE.createLocation(d, d2);
    }

    @Override
    protected Command changeValue(EditingDomain editingDomain, Object object, EObject eObject, Object object2) {
        return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)object2);
    }

    @Override
    public Command applyFeature(EditingDomain editingDomain, Object object, EObject eObject, EReference eReference, Object object2, int n) {
        if (eObject instanceof DiagramElement && object2 instanceof Vector) {
            DiagramElement diagramElement = (DiagramElement)eObject;
            Vector vector = this.a(object, diagramElement, (Vector)object2);
            Command command = super.applyFeature(editingDomain, object, eObject, eReference, vector, n);
            DiagramElement diagramElement2 = DiagramContext.getLocationElement((Object)object);
            DiagramElement diagramElement3 = diagramElement.getOwningElement();
            if (diagramElement2 != null && diagramElement2 != diagramElement3) {
                command = command.chain(AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement2, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, (Object)diagramElement, (int)0));
                FeatureAccessor featureAccessor = (FeatureAccessor)DiagramContext.get((Object)object, FeatureAccessor.class);
                assert (featureAccessor != null) : "FeatureAccessor must be set in context.";
                featureAccessor.put((Object)diagramElement, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNING_ELEMENT, (Object)diagramElement2);
                for (Edge edge : Iterables.concat((Iterable)diagramElement.getSourceEdges(), (Iterable)diagramElement.getTargetEdges())) {
                    DiagramElement diagramElement4 = edge.getSource() == diagramElement ? edge.getTarget() : edge.getSource();
                    command = command.chain(NormalizeEdgeOwnerHelper.INSTANCE.apply(editingDomain, object, edge, diagramElement, diagramElement4));
                }
            }
            return command;
        }
        return super.applyFeature(editingDomain, object, eObject, eReference, object2, n);
    }

    private Vector a(Object object, DiagramElement diagramElement, Vector vector) {
        DiagramElement diagramElement2;
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Vector vector2 = NotationFactory.eINSTANCE.createVector(vector.getX(), vector.getY());
        if (diagramElement.getOwningElement() instanceof Shape) {
            diagramElement2 = layoutCalculator.getOrigin((Object)diagramElement);
            vector2.setX(vector2.getX() + diagramElement2.getX());
            vector2.setY(vector2.getY() + diagramElement2.getY());
        }
        if ((diagramElement2 = DiagramContext.getLocationElement((Object)object)) != diagramElement && diagramElement2 instanceof Shape) {
            Point point = new LayoutCalculator().getElementOrigin((Object)diagramElement2, (Object)diagramElement, layoutCalculator.getOrigin((Object)diagramElement2));
            vector2.setX(vector2.getX() - point.getX());
            vector2.setY(vector2.getY() - point.getY());
        }
        return vector2;
    }
}

