/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import java.util.List;
import net.astah.dd.dc.Color;
import net.astah.notation.DiagramElement;
import net.astah.notation.provider.NotationStyles;
import net.astah.notation.util.NotationStyleResolver;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class GraphicalStyleProviderHelper {
    public static final GraphicalStyleProviderHelper INSTANCE = new GraphicalStyleProviderHelper();

    public EObject getStyleFromProjectPreference(EObject eObject, String string) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)eObject);
        return project.getStylePreferences().getStyle(string);
    }

    public List<EObject> getApplicableStyles(EObject eObject, String string, List<EObject> list) {
        list.add(0, this.getStyleFromProjectPreference(eObject, string));
        return list;
    }

    public List<EObject> getApplicableStyles(EObject eObject, List<String> list, List<EObject> list2) {
        list.forEach(string -> list2.add(0, this.getStyleFromProjectPreference(eObject, (String)string)));
        return list2;
    }

    public URI getFillColor(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        Color color = notationStyleResolver.resolveFillColor(diagramElement);
        if (color == null) {
            return null;
        }
        double d = notationStyleResolver.resolveFillOpacity(diagramElement);
        return NotationStyles.createColorURI(color, d);
    }

    public double getStrokeWidth(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        return notationStyleResolver.resolveStrokeWidth(diagramElement);
    }

    public URI getStrokeColor(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        Color color = notationStyleResolver.resolveStrokeColor(diagramElement);
        if (color == null) {
            return null;
        }
        double d = notationStyleResolver.resolveStrokeOpacity(diagramElement);
        return NotationStyles.createColorURI(color, d);
    }

    public List<Double> getStrokePattern(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        return notationStyleResolver.resolveStrokeDashLengths(diagramElement);
    }

    public URI getFontColor(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        Color color = notationStyleResolver.resolveFontColor(diagramElement);
        if (color == null) {
            return null;
        }
        double d = notationStyleResolver.resolveFontOpacity(diagramElement);
        return NotationStyles.createColorURI(color, d);
    }

    public URI getFont(DiagramElement diagramElement) {
        NotationStyleResolver notationStyleResolver = NotationStyleResolver.resolverFor((EObject)diagramElement);
        String string = notationStyleResolver.resolveFontName(diagramElement);
        double d = notationStyleResolver.resolveFontSize(diagramElement);
        if (string == null || d == 0.0) {
            return null;
        }
        boolean bl = notationStyleResolver.resolveFontBold(diagramElement);
        boolean bl2 = notationStyleResolver.resolveFontItalic(diagramElement);
        return NotationStyles.createFontURI(string, d, bl, bl2);
    }
}

