/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.FeatureAccessor;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.golf.util.Geometry;
import net.astah.jmodel.RightAngleUtil;
import net.astah.notation.AnchorConstraint;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.LineConstraint;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.NotationPackage;
import net.astah.notation.RatioAnchor;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.Shape;
import net.astah.notation.Size;
import net.astah.notation.SizeConstraint;
import net.astah.notation.Vector;
import net.astah.notation.edit.command.RightAngles;
import net.astah.notation.util.NotationGetPointsHelper;
import org.eclipse.emf.ecore.EObject;

public class GeometryProviderHelper {
    public static Bounds getBoundsOn(Shape shape, Point point, LayoutCalculator layoutCalculator) {
        LocationConstraint locationConstraint = GeometryProviderHelper.getLocation(shape, layoutCalculator);
        SizeConstraint sizeConstraint = GeometryProviderHelper.getSize(shape, layoutCalculator);
        if (point == null && locationConstraint == null && sizeConstraint == null || locationConstraint != null && !(locationConstraint instanceof Location) || sizeConstraint != null && !(sizeConstraint instanceof Size)) {
            return null;
        }
        Location location = (Location)locationConstraint;
        Size size = (Size)sizeConstraint;
        double d = point == null ? 0.0 : point.getX();
        double d2 = point == null ? 0.0 : point.getY();
        double d3 = location == null ? 0.0 : location.getX();
        double d4 = location == null ? 0.0 : location.getY();
        double d5 = size == null ? 0.0 : size.getWidth();
        double d6 = size == null ? 0.0 : size.getHeight();
        double d7 = d + d3;
        double d8 = d2 + d4;
        double d9 = d5;
        double d10 = d6;
        return DCFactory.eINSTANCE.createBounds(d7, d8, d9, d10);
    }

    public static Bounds getBoundsOn(Edge edge, List<Point> list, Point point) {
        Rectangle2D rectangle2D = null;
        for (Point point2 : list) {
            double d = point2.getX();
            double d2 = point2.getY();
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                continue;
            }
            rectangle2D.add(d, d2);
        }
        return rectangle2D != null ? Geometries.toBounds(rectangle2D) : null;
    }

    public static Bounds getBoundsOn(Iterable<Point> iterable, Point point) {
        if (!iterable.iterator().hasNext()) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (Point point2 : iterable) {
            d = Math.min(d, point2.getX());
            d2 = Math.min(d2, point2.getY());
            d3 = Math.max(d3, point2.getX());
            d4 = Math.max(d4, point2.getY());
        }
        Bounds bounds = DCFactory.eINSTANCE.createBounds(d, d2, d3 - d, d4 - d2);
        return LayoutCalculator.translate((Bounds)bounds, (Point)point);
    }

    public static Point getLocationOn(Shape shape, Point point, LayoutCalculator layoutCalculator) {
        Location location = (Location)GeometryProviderHelper.getLocation(shape, layoutCalculator);
        if (location != null) {
            return LayoutCalculator.translate((Point)DCFactory.eINSTANCE.createPoint(location.getX(), location.getY()), (Point)point);
        }
        return point;
    }

    public static Point getBoundsPoint(Bounds bounds, Point point) {
        double d = bounds.getX();
        double d2 = bounds.getY();
        if (point != null) {
            d += point.getX();
            d2 += point.getY();
        }
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    public static Point getBoundsPoint(Bounds bounds, Location location) {
        double d = bounds.getX();
        double d2 = bounds.getY();
        if (location != null) {
            d += location.getX();
            d2 += location.getY();
        }
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    public static Dimension getBoundsSize(Shape shape, LayoutCalculator layoutCalculator) {
        Size size = (Size)GeometryProviderHelper.getSize(shape, layoutCalculator);
        return size == null ? null : DCFactory.eINSTANCE.createDimension(size.getWidth(), size.getHeight());
    }

    public static Dimension getBoundsDimension(Bounds bounds) {
        double d = bounds.getWidth();
        double d2 = bounds.getHeight();
        return DCFactory.eINSTANCE.createDimension(d, d2);
    }

    public static List<Point> getWaypoints(LineConstraint lineConstraint, Rectangle2d rectangle2d, Rectangle2d rectangle2d2, List<Point> list, LayoutCalculator layoutCalculator) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Pnt2d[] pnt2dArray = (Pnt2d[])list.stream().map(Geometries::toPnt2d).toArray(Pnt2d[]::new);
        Pnt2d[] pnt2dArray2 = Geometry.getOuterPnts((Rectangle2d)rectangle2d, (Rectangle2d)rectangle2d2, (Pnt2d[])pnt2dArray);
        if (pnt2dArray2 == null) {
            pnt2dArray2 = pnt2dArray;
        }
        if (RightAngleUtil.isRightAngle((LineConstraint)lineConstraint)) {
            Pnt2d[] pnt2dArray3 = RightAngleUtil.adjustMiddleEndWaypoints((Pnt2d[])pnt2dArray2);
            return Arrays.asList(pnt2dArray3).stream().map(pnt2d -> DCFactory.eINSTANCE.createPoint(pnt2d.x, pnt2d.y)).collect(Collectors.toList());
        }
        return Arrays.asList(pnt2dArray2).stream().map(pnt2d -> DCFactory.eINSTANCE.createPoint(pnt2d.x, pnt2d.y)).collect(Collectors.toList());
    }

    public static List<Point> getWaypoints(Edge edge, List<Point> list, Point point, LayoutCalculator layoutCalculator) {
        assert (list.size() >= 2) : "The size of controlPoints is less than 2.";
        Bounds bounds = layoutCalculator.getEdgeEndBounds((net.astah.dd.di.Edge)edge, layoutCalculator.getSource((net.astah.dd.di.Edge)edge), list.get(0), point);
        Bounds bounds2 = layoutCalculator.getEdgeEndBounds((net.astah.dd.di.Edge)edge, layoutCalculator.getTarget((net.astah.dd.di.Edge)edge), list.get(list.size() - 1), point);
        if (bounds == null && bounds2 == null) {
            return Collections.emptyList();
        }
        return GeometryProviderHelper.getWaypoints(GeometryProviderHelper.getLine(edge, layoutCalculator), Geometries.toRectangle2d((Bounds)bounds), Geometries.toRectangle2d((Bounds)bounds2), list, layoutCalculator);
    }

    public static List<Point> getControlPoints(Edge edge, Point point, LayoutCalculator layoutCalculator) {
        List list = (List)FeatureAccessor.actualValue((Object)layoutCalculator.getFeatureAccessor().get((Object)edge, List.class), List.class);
        if (list != null && !list.isEmpty() && list.get(0) instanceof Point) {
            List list2 = list;
            return list2;
        }
        Point point2 = GeometryProviderHelper.getSourceEndPoint(edge, point, layoutCalculator);
        if (point2 == null) {
            return Collections.emptyList();
        }
        Point point3 = GeometryProviderHelper.getTargetEndPoint(edge, point, layoutCalculator);
        if (point3 == null) {
            return Collections.emptyList();
        }
        LineConstraint lineConstraint = GeometryProviderHelper.getLine(edge, layoutCalculator);
        if (lineConstraint != null) {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            arrayList.add(point2);
            if (RightAngleUtil.isRightAngle((LineConstraint)lineConstraint)) {
                arrayList.addAll(RightAngles.optimizePoints(edge, point, layoutCalculator));
            } else {
                arrayList.addAll(LayoutCalculator.translate((List)((List)NotationGetPointsHelper.INSTANCE.doSwitch((EObject)lineConstraint)), (Point)point));
            }
            arrayList.add(point3);
            return arrayList;
        }
        return Arrays.asList(point2, point3);
    }

    public static Point getAnchorPoint(Bounds bounds, Object object) {
        if (bounds != null) {
            if (object instanceof RatioAnchor) {
                return GeometryProviderHelper.a(bounds, (RatioAnchor)object);
            }
            if (object instanceof Point) {
                return GeometryProviderHelper.getBoundsPoint(bounds, (Point)object);
            }
            if (object instanceof Location) {
                return GeometryProviderHelper.getBoundsPoint(bounds, (Location)object);
            }
        }
        return null;
    }

    public static Point getAnchorPoint(Edge edge, Object object, Point point, LayoutCalculator layoutCalculator) {
        if (object instanceof RatioAnchor || object == null) {
            double d = object != null ? ((RatioAnchor)object).getRx() : 0.5;
            List list = layoutCalculator.getWaypoints((Object)edge, point);
            LineConstraint lineConstraint = GeometryProviderHelper.getLine(edge, layoutCalculator);
            if (lineConstraint instanceof Curve || lineConstraint instanceof RightAngleCurve) {
                return GeometryProviderHelper.getEdgeCurvePreferedPoint(d, list);
            }
            return GeometryProviderHelper.getEdgeLinePreferedPoint(d, list);
        }
        return null;
    }

    public static Point getSourceEndPoint(Edge edge, Point point, LayoutCalculator layoutCalculator) {
        AnchorConstraint anchorConstraint = GeometryProviderHelper.getSourceAnchor(edge, layoutCalculator);
        DiagramElement diagramElement = layoutCalculator.getSource((net.astah.dd.di.Edge)edge);
        point = LayoutCalculator.addition((Point)point, (Point)layoutCalculator.getOrigin((Object)diagramElement));
        point = LayoutCalculator.subtraction((Point)point, (Point)layoutCalculator.getOrigin((Object)edge));
        return layoutCalculator.getAnchorPoint((Object)diagramElement, (Object)anchorConstraint, point);
    }

    public static Point getTargetEndPoint(Edge edge, Point point, LayoutCalculator layoutCalculator) {
        AnchorConstraint anchorConstraint = GeometryProviderHelper.getTargetAnchor(edge, layoutCalculator);
        DiagramElement diagramElement = layoutCalculator.getTarget((net.astah.dd.di.Edge)edge);
        point = LayoutCalculator.addition((Point)point, (Point)layoutCalculator.getOrigin((Object)diagramElement));
        point = LayoutCalculator.subtraction((Point)point, (Point)layoutCalculator.getOrigin((Object)edge));
        return layoutCalculator.getAnchorPoint((Object)diagramElement, (Object)anchorConstraint, point);
    }

    private static Point a(Bounds bounds, RatioAnchor ratioAnchor) {
        Objects.requireNonNull(bounds, "bounds");
        double d = bounds.getX() + ratioAnchor.getRx() * bounds.getWidth();
        double d2 = bounds.getY() + ratioAnchor.getRy() * bounds.getHeight();
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    public static Point getEdgeMidpoint(Edge edge, Point point, LayoutCalculator layoutCalculator) {
        List list = layoutCalculator.getWaypoints((Object)edge, point);
        LineConstraint lineConstraint = GeometryProviderHelper.getLine(edge, layoutCalculator);
        if (lineConstraint instanceof Curve || lineConstraint instanceof RightAngleCurve) {
            return GeometryProviderHelper.getEdgeCurvePreferedPoint(0.5, list);
        }
        return GeometryProviderHelper.getEdgeLinePreferedPoint(0.5, list);
    }

    protected static Point getEdgeCurvePreferedPoint(double d, List<Point> list) {
        Point[] pointArray = list.toArray(new Point[list.size()]);
        double d2 = pointArray[0].getX() * Math.pow(1.0 - d, 3.0) + 3.0 * pointArray[1].getX() * d * Math.pow(1.0 - d, 2.0) + 3.0 * pointArray[pointArray.length - 2].getX() * Math.pow(d, 2.0) * (1.0 - d) + pointArray[pointArray.length - 1].getX() * Math.pow(d, 3.0);
        double d3 = pointArray[0].getY() * Math.pow(1.0 - d, 3.0) + 3.0 * pointArray[1].getY() * d * Math.pow(1.0 - d, 2.0) + 3.0 * pointArray[pointArray.length - 2].getY() * Math.pow(d, 2.0) * (1.0 - d) + pointArray[pointArray.length - 1].getY() * Math.pow(d, 3.0);
        return DCFactory.eINSTANCE.createPoint(d2, d3);
    }

    protected static Point getEdgeLinePreferedPoint(double d, List<Point> list) {
        Pnt2d pnt2d;
        Point point = null;
        double d2 = 0.0;
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size() - 1; ++i) {
            Pnt2d pnt2d2 = new Pnt2d(list.get(i).getX(), list.get(i).getY());
            pnt2d = new Pnt2d(list.get(i + 1).getX(), list.get(i + 1).getY());
            dArray[i] = pnt2d2.distance((Point2D)pnt2d);
            d2 += dArray[i];
        }
        if (d2 < 1.0E-5) {
            point = DCFactory.eINSTANCE.createPoint(list.get(0));
            return point;
        }
        double d3 = d2 * d;
        pnt2d = new Pnt2d();
        for (int i = 0; i < list.size() - 1; ++i) {
            if (d3 > dArray[i]) {
                d3 -= dArray[i];
                continue;
            }
            double d4 = d3 / dArray[i];
            Pnt2d pnt2d3 = new Pnt2d(list.get(i).getX(), list.get(i).getY());
            Pnt2d pnt2d4 = new Pnt2d(list.get(i + 1).getX(), list.get(i + 1).getY());
            pnt2d.interpolate((Tpl2d)pnt2d3, (Tpl2d)pnt2d4, d4);
            point = DCFactory.eINSTANCE.createPoint(pnt2d.getX(), pnt2d.getY());
            break;
        }
        return point;
    }

    public static LocationConstraint getLocation(@NonNull Shape shape, @NonNull LayoutCalculator layoutCalculator) {
        if (shape == null) {
            throw new NullPointerException("shape");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        Object object = featureAccessor.get((Object)shape, (Object)NotationPackage.Literals.SHAPE__LOCATION);
        if (object != null) {
            if ((object = FeatureAccessor.actualValue((Object)object)) instanceof Vector) {
                LocationConstraint locationConstraint = shape.getLocation();
                Vector vector = (Vector)object;
                if (locationConstraint instanceof Location) {
                    Location location = (Location)locationConstraint;
                    return NotationFactory.eINSTANCE.createLocation(location.getX() + vector.getX(), location.getY() + vector.getY());
                }
                return NotationFactory.eINSTANCE.createLocation(vector.getX(), vector.getY());
            }
            return (LocationConstraint)FeatureAccessor.actualValue((Object)object, LocationConstraint.class);
        }
        object = featureAccessor.get((Object)shape, (Object)DIPackage.Literals.SHAPE__BOUNDS);
        if (object != null) {
            Bounds bounds = (Bounds)FeatureAccessor.actualValue((Object)object, Bounds.class);
            if (bounds == null) {
                return null;
            }
            double d = bounds.getX();
            double d2 = bounds.getY();
            Point point = layoutCalculator.getOrigin((Object)shape, (Object)shape.getOwningElement());
            if (point != null) {
                d -= point.getX();
                d2 -= point.getY();
            }
            return NotationFactory.eINSTANCE.createLocation(d, d2);
        }
        return shape.getLocation();
    }

    public static SizeConstraint getSize(@NonNull Shape shape, @NonNull LayoutCalculator layoutCalculator) {
        if (shape == null) {
            throw new NullPointerException("shape");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        Object object = featureAccessor.get((Object)shape, (Object)NotationPackage.Literals.SHAPE__SIZE);
        if (object != null) {
            return (SizeConstraint)FeatureAccessor.actualValue((Object)object, SizeConstraint.class);
        }
        object = featureAccessor.get((Object)shape, (Object)DIPackage.Literals.SHAPE__BOUNDS);
        if (object != null) {
            Bounds bounds = (Bounds)FeatureAccessor.actualValue((Object)object, Bounds.class);
            if (bounds == null) {
                return null;
            }
            return NotationFactory.eINSTANCE.createSize(bounds.getWidth(), bounds.getHeight());
        }
        return shape.getSize();
    }

    public static LineConstraint getLine(@NonNull Edge edge, @NonNull LayoutCalculator layoutCalculator) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        Object object = featureAccessor.get((Object)edge, (Object)NotationPackage.Literals.EDGE__LINE);
        if (object != null) {
            return (LineConstraint)FeatureAccessor.actualValue((Object)object, LineConstraint.class);
        }
        return edge.getLine();
    }

    @NonNull
    public static AnchorConstraint getSourceAnchor(@NonNull Edge edge, @NonNull LayoutCalculator layoutCalculator) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        Object object = featureAccessor.get((Object)edge, (Object)NotationPackage.Literals.EDGE__SOURCE_ANCHOR);
        if (object != null) {
            Bounds bounds;
            if ((object = FeatureAccessor.actualValue((Object)object)) instanceof AnchorConstraint) {
                return (AnchorConstraint)object;
            }
            if (object instanceof Point && (bounds = layoutCalculator.getBounds((Object)layoutCalculator.getSource((net.astah.dd.di.Edge)edge))) != null && bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0) {
                return NotationFactory.eINSTANCE.createRatioAnchor(bounds, (Point)object);
            }
        } else {
            AnchorConstraint anchorConstraint = edge.getSourceAnchor();
            if (anchorConstraint != null) {
                return anchorConstraint;
            }
        }
        return NotationFactory.eINSTANCE.createRatioAnchor();
    }

    @NonNull
    public static AnchorConstraint getTargetAnchor(@NonNull Edge edge, @NonNull LayoutCalculator layoutCalculator) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (layoutCalculator == null) {
            throw new NullPointerException("layoutCalculator");
        }
        FeatureAccessor featureAccessor = layoutCalculator.getFeatureAccessor();
        Object object = featureAccessor.get((Object)edge, (Object)NotationPackage.Literals.EDGE__TARGET_ANCHOR);
        if (object != null) {
            Bounds bounds;
            if ((object = FeatureAccessor.actualValue((Object)object)) instanceof AnchorConstraint) {
                return (AnchorConstraint)object;
            }
            if (object instanceof Point && (bounds = layoutCalculator.getBounds((Object)layoutCalculator.getTarget((net.astah.dd.di.Edge)edge))) != null && bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0) {
                return NotationFactory.eINSTANCE.createRatioAnchor(bounds, (Point)object);
            }
        } else {
            AnchorConstraint anchorConstraint = edge.getTargetAnchor();
            if (anchorConstraint != null) {
                return anchorConstraint;
            }
        }
        return NotationFactory.eINSTANCE.createRatioAnchor();
    }
}

