/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.provider;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.command.AlignLocationCommand;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.MoveLocationCommand;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.notation.Edge;
import net.astah.notation.Location;
import net.astah.notation.NotationFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AlignLocationHelper {
    public static AlignLocationHelper INSTANCE = new AlignLocationHelper();

    protected Command changeValue(EditingDomain editingDomain, Object object, EObject eObject, Collection<?> collection, Object object2) {
        List<Shape> list = this.getSelectedShapes(((DiagramContext)object).getSelection());
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        Bounds bounds = layoutCalculator.getBounds((Object)eObject);
        Location location = NotationFactory.eINSTANCE.createLocation(bounds.getX(), bounds.getY());
        switch ((AlignLocationCommand.AlignKind)object2) {
            case TOP: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, this.getSelectionMinY(list) - location.getY()));
            }
            case HORIZONTAL_CENTER: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, this.getCenterY(list) - bounds.getHeight() / 2.0 - location.getY()));
            }
            case BOTTOM: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, this.getBottomY(list) - bounds.getHeight() - location.getY()));
            }
            case HORIZONTAL_SPACE_EVENLY: {
                List<Shape> list2 = this.getHorizontalSortedShapes(list);
                int n = list2.indexOf(eObject);
                if (n == 0 || n == collection.size() - 1) {
                    return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, 0.0));
                }
                double d = this.getHorizontalSpaceBetweenShapes(list);
                Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)bounds);
                double d2 = this.a(rectangle2d, d, list2, n);
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(d2, 0.0));
            }
            case LEFT: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(this.a(list) - location.getX(), 0.0));
            }
            case VERTICAL_CENTER: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(this.getCenterX(list) - bounds.getWidth() / 2.0 - location.getX(), 0.0));
            }
            case RIGHT: {
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(this.getRightX(list) - location.getX() - bounds.getWidth(), 0.0));
            }
            case VERTICAL_SPACE_EVENLY: {
                List<Shape> list3 = this.getVerticalSortedShapes(list);
                int n = list3.indexOf(eObject);
                if (n == 0 || n == collection.size() - 1) {
                    return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, 0.0));
                }
                double d = this.getVerticalSpaceBetweenShapes(list);
                Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)bounds);
                double d3 = this.b(rectangle2d, d, list3, n);
                return MoveLocationCommand.create((EditingDomain)editingDomain, (Object)object, (Object)eObject, null, (Object)NotationFactory.eINSTANCE.createVector(0.0, d3));
            }
        }
        return null;
    }

    private double a(Rectangle2d rectangle2d, double d, List<Shape> list, int n) {
        Shape shape = list.get(0);
        double d2 = shape.getBounds().getX();
        for (int i = 1; i <= n; ++i) {
            Shape shape2 = list.get(i - 1);
            double d3 = shape2.getBounds().getWidth();
            d2 += d3 + d;
        }
        return d2 - rectangle2d.x;
    }

    private double b(Rectangle2d rectangle2d, double d, List<Shape> list, int n) {
        Shape shape = list.get(0);
        double d2 = shape.getBounds().getY();
        for (int i = 1; i <= n; ++i) {
            Shape shape2 = list.get(i - 1);
            double d3 = shape2.getBounds().getHeight();
            d2 += d3 + d;
        }
        return d2 - rectangle2d.y;
    }

    public List<Shape> getSelectedShapes(Collection<? extends EObject> collection) {
        if (collection.stream().allMatch(eObject -> eObject instanceof Shape && ((Shape)eObject).getOwningElement() instanceof Edge)) {
            ArrayList arrayList = Lists.newArrayList(collection);
            return arrayList;
        }
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (EObject eObject2 : collection) {
            if (!(eObject2 instanceof Shape) || ((Shape)eObject2).getOwningElement() instanceof Edge) continue;
            arrayList.add((Shape)eObject2);
        }
        return arrayList;
    }

    public double getRightX(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d = Double.NEGATIVE_INFINITY;
        for (Shape shape : collection) {
            Bounds bounds = shape.getBounds();
            if (!(bounds.getX() + bounds.getWidth() > d)) continue;
            d = bounds.getX() + bounds.getWidth();
        }
        return d;
    }

    private double a(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d = Double.MAX_VALUE;
        for (Shape shape : collection) {
            double d2 = shape.getBounds().getX();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getSelectionMinY(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d = Double.MAX_VALUE;
        for (Shape shape : collection) {
            double d2 = shape.getBounds().getY();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getBottomY(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        double d = Double.NEGATIVE_INFINITY;
        for (Shape shape : collection) {
            Bounds bounds = shape.getBounds();
            double d2 = bounds.getY() + bounds.getHeight();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getCenterY(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        return Geometries.toRectangle2d((Bounds)new LayoutCalculator().getTotalBounds(collection)).getCenterY();
    }

    public double getCenterX(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        return Geometries.toRectangle2d((Bounds)new LayoutCalculator().getTotalBounds(collection)).getCenterX();
    }

    public double getVerticalSpaceBetweenShapes(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Shape shape : collection) {
            ++n;
            Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)shape.getBounds());
            if (rectangle2d.y < d) {
                d = rectangle2d.y;
            }
            if (rectangle2d.y > d2) {
                d2 = rectangle2d.y;
                d4 = rectangle2d.height;
            }
            d3 += rectangle2d.height;
        }
        return (d2 - d + d4 - d3) / (double)(n - 1);
    }

    public double getHorizontalSpaceBetweenShapes(Collection<Shape> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("targets is null.");
        }
        int n = 0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Shape shape : collection) {
            ++n;
            Rectangle2d rectangle2d = Geometries.toRectangle2d((Bounds)shape.getBounds());
            if (rectangle2d.x < d) {
                d = rectangle2d.x;
            }
            if (rectangle2d.x > d2) {
                d2 = rectangle2d.x;
                d4 = rectangle2d.width;
            }
            d3 += rectangle2d.width;
        }
        return (d2 - d + d4 - d3) / (double)(n - 1);
    }

    public List<Shape> getVerticalSortedShapes(List<Shape> list) {
        if (list == null) {
            throw new IllegalArgumentException("sortedPresentation is null.");
        }
        Collections.sort(list, (shape, shape2) -> (int)Math.rint(Geometries.toRectangle2d((Bounds)shape.getBounds()).y - Geometries.toRectangle2d((Bounds)shape2.getBounds()).y));
        return list;
    }

    public List<Shape> getHorizontalSortedShapes(List<Shape> list) {
        if (list == null) {
            throw new IllegalArgumentException("sortedPresentation is null.");
        }
        Collections.sort(list, (shape, shape2) -> (int)Math.rint(Geometries.toRectangle2d((Bounds)shape.getBounds()).x - Geometries.toRectangle2d((Bounds)shape2.getBounds()).x));
        return list;
    }
}

