/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.edit.layout;

import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Dimension;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.DataTypeEObject;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.FontURIResolver;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.notation.Edge;
import net.astah.notation.Shape;
import net.astah.notation.Size;
import net.astah.notation.SizeConstraint;
import net.astah.notation.edit.layout.AlignKind;
import net.astah.notation.edit.layout.Layout;
import net.astah.notation.edit.layout.ModelElementLayoutInfo;
import net.astah.notation.provider.GeometryProviderHelper;
import net.astah.notation.provider.graphics.DGSetSizeHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

public class TextAreaLayout
extends Layout {
    private final AlignKind a;
    private final AlignKind b;
    private final boolean c;
    private final EFeaturePath d;
    private final boolean e;
    private final boolean f;
    private final int g;
    private final Collection<ModelElementLayoutInfo> h;

    protected TextAreaLayout(String string, double d, double d2, double d3, double d4, double d5, double d6, Map<String, Layout> map, AlignKind alignKind, AlignKind alignKind2, boolean bl, EFeaturePath eFeaturePath, boolean bl2, boolean bl3, int n, Collection<ModelElementLayoutInfo> collection) {
        super(string, d, d2, d3, d4, d5, d6, map);
        this.a = alignKind;
        this.b = alignKind2;
        this.c = bl;
        this.d = eFeaturePath;
        this.e = bl2;
        this.f = bl3;
        this.g = n;
        this.h = collection;
    }

    public AlignKind getTextAlign() {
        return this.a;
    }

    public AlignKind getTextGroupAlign() {
        return this.b;
    }

    public boolean isLineWrappable() {
        return this.c;
    }

    public boolean isWidthStretch() {
        return this.e;
    }

    @Override
    public Map<DiagramElement, DataTypeEObject> calculate(Map<String, List<DiagramElement>> map, Bounds bounds, LayoutCalculator layoutCalculator, Class<? extends DataTypeEObject> clazz) {
        HashMap<DiagramElement, DataTypeEObject> hashMap = new HashMap<DiagramElement, DataTypeEObject>();
        if (map.containsKey(this.id)) {
            List<DiagramElement> list = map.get(this.id);
            if (clazz == Point.class) {
                this.calculateTextAreaLocation(list, bounds, layoutCalculator, hashMap);
            } else {
                this.a(list, bounds, layoutCalculator, hashMap);
            }
        }
        return hashMap;
    }

    protected void calculateTextAreaLocation(List<DiagramElement> list, Bounds bounds, LayoutCalculator layoutCalculator, Map<DiagramElement, DataTypeEObject> map) {
        double d = 0.0;
        double d2 = bounds.getY() + this.topMargin;
        boolean bl = list.size() == 1 && this.f;
        for (int i = 0; i < list.size(); ++i) {
            Dimension dimension;
            DiagramElement diagramElement = list.get(i);
            Dimension dimension2 = dimension = this.g <= i ? this.getLabelSize(diagramElement, bounds, bl, layoutCalculator) : DCFactory.eINSTANCE.createDimension();
            if (this.e) {
                d = bounds.getX() + this.leftMargin;
                map.put(diagramElement, (DataTypeEObject)DCFactory.eINSTANCE.createPoint(d, d2));
            } else {
                switch (this.a) {
                    case LEFT: {
                        d = bounds.getX() + this.leftMargin;
                        ModelElementLayoutInfo modelElementLayoutInfo = this.b(diagramElement);
                        if (modelElementLayoutInfo != null) {
                            d += modelElementLayoutInfo.b();
                        }
                        map.put(diagramElement, (DataTypeEObject)DCFactory.eINSTANCE.createPoint(d, d2));
                        break;
                    }
                    case CENTER: {
                        d = bounds.getX() + (bounds.getWidth() - dimension.getWidth()) / 2.0;
                        map.put(diagramElement, (DataTypeEObject)DCFactory.eINSTANCE.createPoint(d, d2));
                        break;
                    }
                    case RIGHT: {
                        d = bounds.getX() + bounds.getWidth() - this.rightMargin - dimension.getWidth();
                        map.put(diagramElement, (DataTypeEObject)DCFactory.eINSTANCE.createPoint(d, d2));
                        break;
                    }
                }
            }
            if (dimension.getHeight() == 0.0) continue;
            d2 += dimension.getHeight() + this.bottomMargin;
        }
    }

    private void a(List<DiagramElement> list, Bounds bounds, LayoutCalculator layoutCalculator, Map<DiagramElement, DataTypeEObject> map) {
        boolean bl = list.size() == 1 && this.f;
        for (int i = 0; i < list.size(); ++i) {
            DiagramElement diagramElement = list.get(i);
            Dimension dimension = this.g <= i ? this.getLabelSize(diagramElement, bounds, bl, layoutCalculator) : DCFactory.eINSTANCE.createDimension();
            map.put(diagramElement, (DataTypeEObject)DCFactory.eINSTANCE.createDimension(dimension.getWidth(), dimension.getHeight()));
        }
    }

    @Override
    public void calculateTotalBounds(DiagramElement diagramElement, Shape shape, Map<String, List<DiagramElement>> map, LayoutCalculator layoutCalculator, Bounds bounds) {
        if (!map.containsKey(this.id)) {
            return;
        }
        List<DiagramElement> list = map.get(this.id);
        Dimension dimension = DCFactory.eINSTANCE.createDimension(bounds.getWidth(), 0.0);
        this.calculateTotalSize(list, layoutCalculator, dimension);
        if (dimension.getWidth() == 0.0) {
            return;
        }
        DiagramElement diagramElement2 = list.get(0);
        Point point = layoutCalculator.getUnaffectedOrigin((Object)diagramElement2, (Object)diagramElement);
        DiagramElement diagramElement3 = layoutCalculator.getOwningElement(diagramElement2);
        Point point2 = diagramElement3 instanceof Edge ? (point != null ? this.getTotalLocationForEdge(point, dimension) : DCFactory.eINSTANCE.createPoint(0.0, 0.0)) : point;
        bounds.setX(point2.getX());
        bounds.setY(point2.getY());
        bounds.setWidth(dimension.getWidth());
        bounds.setHeight(dimension.getHeight());
    }

    public void calculateTotalSize(List<DiagramElement> list, LayoutCalculator layoutCalculator, Dimension dimension) {
        Rectangle2d rectangle2d = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ModelElementLayoutInfo modelElementLayoutInfo;
            DiagramElement diagramElement = list.get(i);
            Dimension dimension2 = DCFactory.eINSTANCE.createDimension();
            if (this.g <= i) {
                dimension2.setWidth(dimension.getWidth());
                this.calculateLabelSize(diagramElement, layoutCalculator, dimension2);
            }
            d = 0.0;
            if (this.a == AlignKind.LEFT && (modelElementLayoutInfo = this.b(diagramElement)) != null) {
                d = modelElementLayoutInfo.b();
            }
            d3 = dimension2.getWidth();
            d4 = dimension2.getHeight();
            modelElementLayoutInfo = DCFactory.eINSTANCE.createBounds(d, d2, d3, d4);
            Rectangle2d rectangle2d2 = Geometries.toRectangle2d((Bounds)modelElementLayoutInfo);
            if (rectangle2d == null) {
                rectangle2d = rectangle2d2;
            } else {
                rectangle2d.add((Rectangle2D)rectangle2d2);
            }
            if (d4 == 0.0) continue;
            d2 += d4 + this.bottomMargin;
        }
        if (rectangle2d != null) {
            Bounds bounds = Geometries.toBounds(rectangle2d);
            d3 = bounds.getWidth() + this.leftMargin + this.rightMargin;
            d4 = bounds.getHeight() + this.topMargin + this.bottomMargin;
            dimension.setWidth(d3);
            dimension.setHeight(d4);
        }
    }

    protected Point getTotalLocationForEdge(Point point, Dimension dimension) {
        double d = 0.0;
        double d2 = 0.0;
        switch (this.b) {
            case CENTER: {
                d = point.getX() - dimension.getWidth() / 2.0;
                d2 = point.getY() - dimension.getHeight() / 2.0;
                break;
            }
            case TOP: {
                break;
            }
            case BOTTOM: {
                d = point.getX() - dimension.getWidth() / 2.0;
                d2 = point.getY() - dimension.getHeight() - this.bottomMargin;
                break;
            }
            case LEFT: {
                break;
            }
            case RIGHT: {
                break;
            }
            case TOP_LEFT: {
                break;
            }
            case TOP_RIGHT: {
                break;
            }
            case BOTTOM_LEFT: {
                break;
            }
            case BOTTOM_RIGHT: {
                break;
            }
        }
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    public Point getLocationPointForEdge(Bounds bounds) {
        double d = 0.0;
        double d2 = 0.0;
        switch (this.b) {
            case CENTER: {
                d = bounds.getX() + bounds.getWidth() / 2.0;
                d2 = bounds.getY() + (bounds.getHeight() - this.topMargin + this.bottomMargin) / 2.0;
                break;
            }
            case TOP: {
                break;
            }
            case BOTTOM: {
                break;
            }
            case LEFT: {
                break;
            }
            case RIGHT: {
                break;
            }
            case TOP_LEFT: {
                break;
            }
            case TOP_RIGHT: {
                break;
            }
            case BOTTOM_LEFT: {
                break;
            }
            case BOTTOM_RIGHT: {
                break;
            }
        }
        return DCFactory.eINSTANCE.createPoint(d, d2);
    }

    protected void calculateLabelSize(DiagramElement diagramElement, LayoutCalculator layoutCalculator, Dimension dimension) {
        if (this.a(diagramElement, layoutCalculator)) {
            this.calculateLabelSizeWithWrappingLine(diagramElement, layoutCalculator, dimension);
        } else {
            this.calculateLabelSizeWithoutWrappingLine(diagramElement, layoutCalculator, dimension);
        }
    }

    protected Dimension getLabelSize(DiagramElement diagramElement, Bounds bounds, boolean bl, LayoutCalculator layoutCalculator) {
        return this.a(diagramElement, layoutCalculator) ? this.getLabelSizeWithWrappingLine(diagramElement, bounds, bl, layoutCalculator) : this.a(diagramElement, bounds, bl, layoutCalculator);
    }

    protected void calculateLabelSizeWithWrappingLine(DiagramElement diagramElement, LayoutCalculator layoutCalculator, Dimension dimension) {
        Size size;
        double d = 0.0;
        double d2 = 0.0;
        DiagramElement diagramElement2 = layoutCalculator.getOwningElement(diagramElement);
        if (diagramElement2 instanceof Shape) {
            size = (Size)GeometryProviderHelper.getSize((Shape)diagramElement2, layoutCalculator);
            double d3 = Math.max(size.getWidth(), dimension.getWidth());
            d = Math.max(d3 - this.leftMargin - this.rightMargin, this.minWidth);
        } else if (diagramElement2 instanceof Edge && diagramElement instanceof Shape) {
            size = (Size)GeometryProviderHelper.getSize((Shape)diagramElement, layoutCalculator);
            d = Math.max(size.getWidth(), this.minWidth);
            d2 = Math.max(size.getHeight(), this.minHeight);
        } else if (layoutCalculator.getOwningElement(diagramElement2) instanceof Shape) {
            size = (Size)GeometryProviderHelper.getSize((Shape)layoutCalculator.getOwningElement(diagramElement2), layoutCalculator);
            d = Math.max(size.getWidth() - this.leftMargin - this.rightMargin, this.minWidth);
        }
        size = this.getWrappedTextSize(diagramElement, d, layoutCalculator);
        dimension.setWidth(size.getWidth());
        dimension.setHeight(Math.max(size.getHeight(), d2));
    }

    protected Dimension getLabelSizeWithWrappingLine(DiagramElement diagramElement, Bounds bounds, boolean bl, LayoutCalculator layoutCalculator) {
        Dimension dimension;
        double d = 0.0;
        double d2 = 0.0;
        DiagramElement diagramElement2 = layoutCalculator.getOwningElement(diagramElement);
        if (diagramElement2 instanceof Shape || layoutCalculator.getOwningElement(diagramElement2) instanceof Shape) {
            d = bounds.getWidth() - this.leftMargin - this.rightMargin;
        } else if (diagramElement2 instanceof Edge && diagramElement instanceof Shape) {
            dimension = (Size)GeometryProviderHelper.getSize((Shape)diagramElement, layoutCalculator);
            d = Math.max(dimension.getWidth(), this.minWidth);
            d2 = Math.max(dimension.getHeight(), this.minHeight);
        }
        dimension = this.getWrappedTextSize(diagramElement, d, layoutCalculator);
        if (!this.e) {
            d = dimension.getWidth();
        }
        d2 = bl ? bounds.getHeight() - this.topMargin - this.bottomMargin : Math.max(dimension.getHeight(), d2);
        return DCFactory.eINSTANCE.createDimension(d, d2);
    }

    protected void calculateLabelSizeWithoutWrappingLine(DiagramElement diagramElement, LayoutCalculator layoutCalculator, Dimension dimension) {
        Dimension dimension2;
        double d = 0.0;
        double d2 = 0.0;
        if (diagramElement instanceof Shape && (dimension2 = GeometryProviderHelper.getSize((Shape)diagramElement, layoutCalculator)) instanceof Size) {
            Size size = (Size)dimension2;
            d = size.getWidth();
            d2 = size.getHeight();
        }
        dimension2 = this.getTextSize(diagramElement);
        dimension.setWidth(this.a(d, dimension2.getWidth(), this.minWidth));
        dimension.setHeight(this.a(d2, dimension2.getHeight(), this.minHeight));
    }

    private Dimension a(DiagramElement diagramElement, Bounds bounds, boolean bl, LayoutCalculator layoutCalculator) {
        double d = 0.0;
        double d2 = 0.0;
        Dimension dimension = this.getTextSize(diagramElement);
        if (diagramElement instanceof Shape) {
            SizeConstraint sizeConstraint = GeometryProviderHelper.getSize((Shape)diagramElement, layoutCalculator);
            if (sizeConstraint instanceof Size) {
                Size size = (Size)sizeConstraint;
                d = size.getWidth();
                d2 = size.getHeight();
            } else {
                if (this.e) {
                    d = bounds.getWidth() - this.leftMargin - this.rightMargin;
                }
                if (bl) {
                    d2 = bounds.getHeight() - this.topMargin - this.bottomMargin;
                }
            }
        }
        return DCFactory.eINSTANCE.createDimension(Math.max(d, dimension.getWidth()), Math.max(d2, dimension.getHeight()));
    }

    protected Dimension getTextSize(DiagramElement diagramElement) {
        Font font = this.a(diagramElement);
        if (font == null) {
            font = JomtFontUtilities.getProjectFont();
        }
        double d = 0.0;
        double d2 = 0.0;
        String string = this.getLabelText(diagramElement);
        if (string != null) {
            d = DGSetSizeHelper.getRawTextWidth(font, string);
            d2 = DGSetSizeHelper.getRawTextHeight(font, string);
        }
        return DCFactory.eINSTANCE.createDimension(d, d2);
    }

    protected Dimension getWrappedTextSize(DiagramElement diagramElement, double d, LayoutCalculator layoutCalculator) {
        Font font = this.a(diagramElement);
        if (font == null) {
            font = JomtFontUtilities.getProjectFont();
        }
        double d2 = 0.0;
        double d3 = 0.0;
        String string = this.getLabelText(diagramElement);
        if (string != null) {
            DiagramElement diagramElement2 = layoutCalculator.getOwningElement(diagramElement);
            if (diagramElement2 instanceof Shape || layoutCalculator.getOwningElement(diagramElement2) instanceof Shape) {
                double d4 = DGSetSizeHelper.getRawTextWidth(font, string);
                if (d < d4) {
                    d2 = d;
                    ModelElementLayoutInfo modelElementLayoutInfo = this.b(diagramElement);
                    if (modelElementLayoutInfo != null) {
                        d2 -= modelElementLayoutInfo.b();
                    }
                } else {
                    d2 = d4;
                }
            } else if (diagramElement2 instanceof Edge) {
                d2 = d;
            }
            d3 = GolfUtilities.computeMultiLineStringHeight((Font)font, (String)string, (double)d2, (double)0.0);
        }
        return DCFactory.eINSTANCE.createDimension(d2, d3);
    }

    private Font a(DiagramElement diagramElement) {
        IItemGraphicalStyleProvider iItemGraphicalStyleProvider = (IItemGraphicalStyleProvider)ItemProviders.adapt((EObject)diagramElement, IItemGraphicalStyleProvider.class);
        if (iItemGraphicalStyleProvider == null) {
            return null;
        }
        URI uRI = (URI)iItemGraphicalStyleProvider.getGraphicalStyle((Object)diagramElement, (Object)IItemGraphicalStyleProvider.Feature.FONT);
        if (uRI == null) {
            return null;
        }
        return new FontURIResolver(null).resolve(uRI);
    }

    protected String getLabelText(DiagramElement diagramElement) {
        String string = "";
        ModelElementLayoutInfo modelElementLayoutInfo = this.b(diagramElement);
        if (modelElementLayoutInfo != null) {
            string = modelElementLayoutInfo.c();
        }
        return string + Objects.toString(this.d.getReference((EObject)diagramElement), "");
    }

    private ModelElementLayoutInfo b(DiagramElement diagramElement) {
        EObject eObject = DiagramElements.getModelElement((DiagramElement)diagramElement);
        return eObject != null ? (ModelElementLayoutInfo)this.h.stream().filter(modelElementLayoutInfo -> modelElementLayoutInfo.a() == eObject.eClass()).findFirst().orElse(null) : null;
    }

    public boolean needsToWrapLine(DiagramElement diagramElement) {
        return this.a(diagramElement, new LayoutCalculator());
    }

    private boolean a(DiagramElement diagramElement, LayoutCalculator layoutCalculator) {
        if (!this.c) {
            return false;
        }
        DiagramElement diagramElement2 = layoutCalculator.getOwningElement(diagramElement);
        Shape shape = null;
        if (diagramElement2 == null) {
            return false;
        }
        if (diagramElement2 instanceof Shape) {
            shape = (Shape)diagramElement2;
        } else if (diagramElement2 instanceof Edge && diagramElement instanceof Shape) {
            shape = (Shape)diagramElement;
        } else if (layoutCalculator.getOwningElement(diagramElement2) instanceof Shape) {
            shape = (Shape)layoutCalculator.getOwningElement(diagramElement2);
        }
        return shape != null && GeometryProviderHelper.getSize(shape, layoutCalculator) instanceof Size;
    }

    private double a(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }

    @Keep
    @KeepPublicProtectedClassMembers
    public static class Builder
    extends Layout.Builder<Builder> {
        private AlignKind a;
        private AlignKind b;
        private boolean c;
        private EFeaturePath d;
        private boolean e;
        private boolean f;
        private int g;
        private Collection<ModelElementLayoutInfo> h = Collections.emptySet();

        public Builder(String string) {
            this.id = string;
        }

        public Builder textAlign(AlignKind alignKind) {
            this.a = alignKind;
            return this;
        }

        public Builder textGroupAlign(AlignKind alignKind) {
            this.b = alignKind;
            return this;
        }

        public Builder lineWrappable(boolean bl) {
            this.c = bl;
            return this;
        }

        public Builder path(EFeaturePath eFeaturePath) {
            this.d = eFeaturePath;
            return this;
        }

        public Builder widthStretch(boolean bl) {
            this.e = bl;
            return this;
        }

        public Builder heightStretch(boolean bl) {
            this.f = bl;
            return this;
        }

        public Builder skip(int n) {
            this.g = n;
            return this;
        }

        public Builder modelElementLayoutInfos(Collection<ModelElementLayoutInfo> collection) {
            this.h = collection;
            return this;
        }

        @Override
        @Keep
        public TextAreaLayout build() {
            return new TextAreaLayout(this.id, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.minWidth, this.minHeight, this.ownedLayouts, this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }
    }
}

