/*
 * Decompiled with CFR 0.152.
 */
package net.astah.notation.edit.layout;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.emf.common.ecore.DataTypeEObject;
import net.astah.notation.Shape;

public abstract class Layout {
    protected final String id;
    protected final double topMargin;
    protected final double bottomMargin;
    protected final double leftMargin;
    protected final double rightMargin;
    protected final double minWidth;
    protected final double minHeight;
    protected final Map<String, Layout> ownedLayouts;

    protected Layout(String string, double d, double d2, double d3, double d4, double d5, double d6, Map<String, Layout> map) {
        this.id = string;
        this.topMargin = d;
        this.bottomMargin = d2;
        this.leftMargin = d3;
        this.rightMargin = d4;
        this.minWidth = d5;
        this.minHeight = d6;
        this.ownedLayouts = map;
    }

    public String getId() {
        return this.id;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public double getMinWidth() {
        return this.minWidth;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public abstract Map<DiagramElement, DataTypeEObject> calculate(Map<String, List<DiagramElement>> var1, Bounds var2, LayoutCalculator var3, Class<? extends DataTypeEObject> var4);

    public abstract void calculateTotalBounds(DiagramElement var1, Shape var2, Map<String, List<DiagramElement>> var3, LayoutCalculator var4, Bounds var5);

    public Layout getOwnedLayoutById(String string) {
        return this.ownedLayouts.get(string);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected double topMargin;
        protected double bottomMargin;
        protected double leftMargin;
        protected double rightMargin;
        protected double minWidth;
        protected double minHeight;
        protected Map<String, Layout> ownedLayouts;

        public T id(String string) {
            this.id = string;
            return (T)this;
        }

        public T margin(double d) {
            return this.margin(d, d, d, d);
        }

        public T margin(double d, double d2) {
            return this.margin(d, d2, d, d2);
        }

        public T margin(double d, double d2, double d3) {
            return this.margin(d, d2, d3, d2);
        }

        public T margin(double d, double d2, double d3, double d4) {
            this.topMargin = d;
            this.rightMargin = d2;
            this.bottomMargin = d3;
            this.leftMargin = d4;
            return (T)this;
        }

        public T topMargin(double d) {
            this.topMargin = d;
            return (T)this;
        }

        public T bottomMargin(double d) {
            this.bottomMargin = d;
            return (T)this;
        }

        public T leftMargin(double d) {
            this.leftMargin = d;
            return (T)this;
        }

        public T rightMargin(double d) {
            this.rightMargin = d;
            return (T)this;
        }

        public T minWidth(double d) {
            this.minWidth = d;
            return (T)this;
        }

        public T minHeight(double d) {
            this.minHeight = d;
            return (T)this;
        }

        public T add(Builder<?> builder) {
            if (this.ownedLayouts == null) {
                this.ownedLayouts = new LinkedHashMap<String, Layout>();
            }
            Layout layout = builder.build();
            this.ownedLayouts.put(layout.getId(), layout);
            return (T)this;
        }

        public T add(Layout layout) {
            if (this.ownedLayouts == null) {
                this.ownedLayouts = new LinkedHashMap<String, Layout>();
            }
            this.ownedLayouts.put(layout.getId(), layout);
            return (T)this;
        }

        public abstract Layout build();
    }
}

